/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeJoin;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.HasBranch;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.SortOrder;
import org.eclipse.osee.jdbc.SqlTable;
import org.eclipse.osee.orcs.QueryType;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.HasOptions;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.ds.SelectData;
import org.eclipse.osee.orcs.core.ds.SelectSet;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaArtifactGuids;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaArtifactIds;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaArtifactTxComment;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaArtifactType;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeKeywords;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeRaw;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeSort;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeTypeExists;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeTypeNotExists;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeValueRange;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaFollowSearch;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaGetReferenceArtifact;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaPagination;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelatedRecursive;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelatedTo;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeExists;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeFollow;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeNotExists;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeSideExists;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeSideNotExists;
import org.eclipse.osee.orcs.core.internal.search.CallableQueryFactory;
import org.eclipse.osee.orcs.search.ArtifactTable;
import org.eclipse.osee.orcs.search.ArtifactTableOptions;
import org.eclipse.osee.orcs.search.Match;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public final class QueryData
implements QueryBuilder,
HasOptions,
HasBranch {
    private final List<List<Criteria>> criterias;
    private final SelectData selectData;
    private final Options options;
    private ArtifactTableOptions tableoptions;
    private final BranchToken branch;
    private final ArtifactId view;
    private final QueryData parentQueryData;
    private final List<QueryData> childrenQueryData = new ArrayList<QueryData>();
    private AttributeTypeToken attributeType = AttributeTypeToken.SENTINEL;
    private final CallableQueryFactory artQueryFactory;
    private final QueryFactory queryFactory;
    private final QueryEngine queryEngine;
    private final OrcsTokenService tokenService;
    private final HashMap<SqlTable, String> mainAliases = new HashMap(4);
    private QueryType queryType;
    private boolean followCausesChild = true;
    private final ApplicabilityId appId;

    public QueryData(QueryData parentQueryData, QueryFactory queryFactory, QueryEngine queryEngine, CallableQueryFactory artQueryFactory, OrcsTokenService tokenService, BranchToken branch, ArtifactId view, ApplicabilityId appId) {
        this.parentQueryData = parentQueryData;
        this.queryFactory = queryFactory;
        this.queryEngine = queryEngine;
        this.artQueryFactory = artQueryFactory;
        this.criterias = new ArrayList<List<Criteria>>();
        this.selectData = new SelectData();
        this.options = OptionsUtil.createOptions();
        this.branch = branch;
        this.view = view;
        this.criterias.add(new ArrayList());
        this.tokenService = tokenService;
        this.appId = appId;
        this.setOrderMechanism("RELATION");
    }

    public QueryData(QueryFactory queryFactory, QueryEngine queryEngine, CallableQueryFactory artQueryFactory, OrcsTokenService tokenService, BranchToken branch, ArtifactId view) {
        this(null, queryFactory, queryEngine, artQueryFactory, tokenService, branch, view, ApplicabilityId.SENTINEL);
    }

    public QueryData(QueryFactory queryFactory, QueryEngine queryEngine, CallableQueryFactory artQueryFactory, OrcsTokenService tokenService, BranchToken branch, ApplicabilityId appId) {
        this(null, queryFactory, queryEngine, artQueryFactory, tokenService, branch, ArtifactId.SENTINEL, appId);
    }

    public QueryData(QueryData parentQueryData) {
        this(parentQueryData, parentQueryData.queryFactory, parentQueryData.queryEngine, parentQueryData.artQueryFactory, parentQueryData.tokenService, parentQueryData.branch, parentQueryData.view, ApplicabilityId.SENTINEL);
    }

    public QueryData(QueryFactory queryFactory, QueryEngine queryEngine, CallableQueryFactory artQueryFactory, OrcsTokenService tokenService, BranchToken branch) {
        this(queryFactory, queryEngine, artQueryFactory, tokenService, branch, ArtifactId.SENTINEL);
    }

    public QueryData(QueryFactory queryFactory, QueryEngine queryEngine, CallableQueryFactory artQueryFactory, OrcsTokenService tokenService) {
        this(queryFactory, queryEngine, artQueryFactory, tokenService, BranchToken.SENTINEL, ArtifactId.SENTINEL);
    }

    public QueryData(QueryType queryType, OrcsTokenService tokenService) {
        this(null, null, null, tokenService);
        this.setQueryType(queryType);
    }

    public static QueryData mock() {
        return new QueryData(null, null, null, null, BranchToken.SENTINEL);
    }

    public ArtifactId getView() {
        return this.view;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    public boolean isSelectQueryType() {
        return this.queryType == QueryType.SELECT;
    }

    public boolean isCountQueryType() {
        return this.queryType == QueryType.COUNT;
    }

    public boolean isTokenQueryType() {
        return this.queryType == QueryType.TOKEN;
    }

    public boolean isIdQueryType() {
        return this.queryType == QueryType.ID;
    }

    public boolean isAttributesOnlyQueryType() {
        return this.queryType == QueryType.ATTRIBUTES_ONLY;
    }

    public List<Criteria> getAllCriteria() {
        ArrayList<Criteria> allCriterias = new ArrayList<Criteria>();
        for (List<Criteria> list : this.criterias) {
            allCriterias.addAll(list);
        }
        return allCriterias;
    }

    public boolean hasNoCriteria() {
        return this.criterias.get(0).isEmpty();
    }

    public List<Criteria> getOnlyCriteriaSet() {
        if (this.criterias.size() > 1) {
            throw new OseeStateException("Expected excactly one criteria set not:" + this.criterias.size(), new Object[0]);
        }
        return this.criterias.get(0);
    }

    public List<List<Criteria>> getCriteriaSets() {
        return Collections.unmodifiableList(this.criterias);
    }

    public List<Criteria> getLastCriteriaSet() {
        return this.criterias.get(this.criterias.size() - 1);
    }

    public List<Criteria> newCriteriaSet() {
        ArrayList<Criteria> criteriaSet = new ArrayList<Criteria>();
        this.criterias.add(criteriaSet);
        this.selectData.newSelectSet();
        return criteriaSet;
    }

    public SelectSet getSelectSet() {
        SelectSet data = this.selectData.getLast();
        if (data == null) {
            data = this.selectData.newSelectSet();
        }
        return data;
    }

    public List<SelectSet> getSelectSets() {
        return this.selectData.getAll();
    }

    public void addCriteria(Criteria ... criterias) {
        List<Criteria> criteriaSet = this.getLastCriteriaSet();
        Criteria[] criteriaArray = criterias;
        int n = criterias.length;
        int n2 = 0;
        while (n2 < n) {
            Criteria criteria = criteriaArray[n2];
            criteriaSet.add(criteria);
            ++n2;
        }
    }

    public void addCriteria(Criteria criteria) {
        this.getLastCriteriaSet().add(criteria);
    }

    public boolean hasCriteriaType(Class<? extends Criteria> type) {
        for (List<Criteria> criteriaSet : this.criterias) {
            for (Criteria criteria : criteriaSet) {
                if (!type.isInstance(criteria)) continue;
                return true;
            }
        }
        return false;
    }

    public <T extends Criteria> List<T> getCriteriaByType(Class<T> type) {
        ArrayList<Criteria> matchingCriteria = new ArrayList<Criteria>(2);
        for (List<Criteria> criteriaSet : this.criterias) {
            for (Criteria criteria : criteriaSet) {
                if (!type.isInstance(criteria)) continue;
                matchingCriteria.add((Criteria)type.cast(criteria));
            }
        }
        return matchingCriteria;
    }

    public void reset() {
        OptionsUtil.reset(this.options);
        List<Criteria> criteriaSet = this.criterias.get(0);
        criteriaSet.clear();
        this.criterias.clear();
        this.criterias.add(criteriaSet);
        this.selectData.reset();
        this.mainAliases.clear();
        this.childrenQueryData.clear();
        this.followCausesChild = true;
        this.attributeType = AttributeTypeToken.SENTINEL;
    }

    public String toString() {
        return "QueryData [criterias=" + this.criterias + ", selects=" + this.selectData + ", options=" + this.options + "]";
    }

    public BranchToken getBranch() {
        return this.branch;
    }

    public void select(AttributeTypeToken attributeType) {
        this.attributeType = attributeType;
    }

    public QueryBuilder includeDeletedAttributes() {
        return this.includeDeletedAttributes(true);
    }

    public QueryBuilder includeDeletedAttributes(boolean enabled) {
        OptionsUtil.setIncludeDeletedAttributes(this.getOptions(), enabled);
        return this;
    }

    public boolean areDeletedAttributesIncluded() {
        return OptionsUtil.areDeletedAttributesIncluded(this.getOptions());
    }

    public QueryBuilder includeDeletedRelations() {
        return this.includeDeletedRelations(true);
    }

    public QueryBuilder includeDeletedRelations(boolean enabled) {
        OptionsUtil.setIncludeDeletedRelations(this.getOptions(), enabled);
        return this;
    }

    public QueryBuilder includeApplicabilityTokens() {
        OptionsUtil.setIncludeApplicabilityTokens(this.getOptions(), true);
        return this;
    }

    public QueryBuilder includeTransactionDetails() {
        OptionsUtil.setIncludeTransactionDetails(this.getOptions(), true);
        return this;
    }

    public boolean areApplicabilityTokensIncluded() {
        return OptionsUtil.getIncludeApplicabilityTokens(this.getOptions());
    }

    public boolean areTransactionDetailsIncluded() {
        return OptionsUtil.getIncludeLatestTransactionDetails(this.getOptions());
    }

    public QueryBuilder followSearch(Collection<AttributeTypeToken> attributeTypes, Collection<String> values, QueryOption ... options) {
        boolean isIncludeAllTypes = attributeTypes.contains(QueryBuilder.ANY_ATTRIBUTE_TYPE);
        OptionsUtil.setFollowSearchInProgress(this.getOptions(), true);
        return this.addAndCheck(new CriteriaFollowSearch(isIncludeAllTypes, attributeTypes, values, options));
    }

    public QueryBuilder followSearch(Collection<AttributeTypeToken> attributeTypes, String value, QueryOption ... options) {
        boolean isIncludeAllTypes = attributeTypes.contains(QueryBuilder.ANY_ATTRIBUTE_TYPE);
        OptionsUtil.setFollowSearchInProgress(this.getOptions(), true);
        return this.addAndCheck(new CriteriaFollowSearch(isIncludeAllTypes, attributeTypes, value, options));
    }

    public void setTableOptions(ArtifactTableOptions tableOptions) {
        this.tableoptions = tableOptions;
    }

    public AttributeTypeToken getAttributeType() {
        return this.attributeType;
    }

    public boolean areDeletedRelationsIncluded() {
        return OptionsUtil.areDeletedRelationsIncluded(this.getOptions());
    }

    public QueryBuilder includeDeletedArtifacts() {
        return this.includeDeletedArtifacts(true);
    }

    public QueryBuilder includeDeletedArtifacts(boolean enabled) {
        OptionsUtil.setIncludeDeletedArtifacts(this.getOptions(), enabled);
        return this;
    }

    public boolean areDeletedArtifactsIncluded() {
        return OptionsUtil.areDeletedArtifactsIncluded(this.getOptions());
    }

    public QueryBuilder fromTransaction(TransactionId transaction) {
        OptionsUtil.setFromTransaction(this.getOptions(), transaction);
        return this;
    }

    public TransactionId getFromTransaction() {
        return OptionsUtil.getFromTransaction(this.getOptions());
    }

    public QueryBuilder headTransaction() {
        OptionsUtil.setHeadTransaction(this.getOptions());
        return this;
    }

    public boolean isHeadTransaction() {
        return OptionsUtil.isHeadTransaction(this.getOptions());
    }

    public QueryBuilder excludeDeleted() {
        this.includeDeletedArtifacts(false);
        return this;
    }

    public QueryBuilder andUuid(long id) {
        return this.andId(ArtifactId.valueOf((Long)id));
    }

    public QueryBuilder andId(ArtifactId id) {
        return this.addAndCheck(new CriteriaArtifactIds(id));
    }

    public QueryBuilder andIds(Collection<? extends ArtifactId> ids) {
        return this.addAndCheck(new CriteriaArtifactIds(ids));
    }

    public QueryBuilder andUuids(Collection<Long> artifactIds) {
        return this.andIds(artifactIds.stream().map(id -> ArtifactId.valueOf((Long)id)).collect(Collectors.toList()));
    }

    public QueryBuilder andIdsL(Collection<Long> artifactIds) {
        return this.andIds(artifactIds.stream().map(id -> ArtifactId.valueOf((Long)id)).collect(Collectors.toList()));
    }

    public QueryBuilder andGuid(String id) {
        return this.andGuids(Collections.singleton(id));
    }

    public QueryBuilder andGuids(Collection<String> ids) {
        HashSet<String> guids = new HashSet<String>();
        HashSet<String> invalids = new HashSet<String>();
        for (String id : ids) {
            if (GUID.isValid((CharSequence)id)) {
                guids.add(id);
                continue;
            }
            invalids.add(id);
        }
        Conditions.checkExpressionFailOnTrue((!invalids.isEmpty() ? 1 : 0) != 0, (String)"Invalid guids detected - %s", (Object[])new Object[]{invalids});
        if (!guids.isEmpty()) {
            this.addAndCheck(new CriteriaArtifactGuids(guids));
        }
        return this;
    }

    public QueryBuilder andIsOfType(ArtifactTypeToken ... artifactType) {
        return this.andIsOfType(Arrays.asList(artifactType));
    }

    public QueryBuilder andIsOfType(Collection<ArtifactTypeToken> artifactTypes) {
        return this.addAndCheck(new CriteriaArtifactType(artifactTypes, true));
    }

    public QueryBuilder andTxComment(String commentPattern, AttributeTypeJoin typeJoin) {
        return this.addAndCheck(new CriteriaArtifactTxComment(commentPattern, typeJoin));
    }

    public QueryBuilder andTypeEquals(ArtifactTypeToken ... artifactType) {
        return this.andTypeEquals(Arrays.asList(artifactType));
    }

    public QueryBuilder andTypeEquals(Collection<ArtifactTypeToken> artifactTypes) {
        return this.addAndCheck(new CriteriaArtifactType(artifactTypes, false));
    }

    public QueryBuilder andExists(AttributeTypeToken ... attributeType) {
        return this.andExists(Arrays.asList(attributeType));
    }

    public QueryBuilder andExists(Collection<AttributeTypeToken> attributeTypes) {
        return this.addAndCheck(new CriteriaAttributeTypeExists(attributeTypes));
    }

    public QueryBuilder andNotExists(AttributeTypeToken attributeType) {
        return this.addAndCheck(new CriteriaAttributeTypeNotExists(attributeType));
    }

    public QueryBuilder andNotExists(AttributeTypeToken attributeType, String value) {
        return this.addAndCheck(new CriteriaAttributeTypeNotExists(attributeType, value));
    }

    public QueryBuilder andNotExists(Collection<AttributeTypeToken> attributeTypes) {
        return this.addAndCheck(new CriteriaAttributeTypeNotExists(attributeTypes));
    }

    public QueryBuilder andRelationExists(RelationTypeToken relationType) {
        return this.addAndCheck(new CriteriaRelationTypeExists(relationType));
    }

    public QueryBuilder andRelationNotExists(RelationTypeToken relationType) {
        return this.addAndCheck(new CriteriaRelationTypeNotExists(relationType));
    }

    public QueryBuilder andRelationNotExists(RelationTypeSide relationType) {
        return this.addAndCheck(new CriteriaRelationTypeSideNotExists(relationType));
    }

    public QueryBuilder andRelationExists(RelationTypeSide relationTypeSide) {
        return this.addAndCheck(new CriteriaRelationTypeSideExists(relationTypeSide));
    }

    public QueryBuilder and(AttributeTypeToken attributeType, Collection<String> values, QueryOption ... options) {
        return this.and(Collections.singleton(attributeType), values, options);
    }

    public QueryBuilder andAttributeIs(AttributeTypeToken attributeType, String value) {
        return this.addAndCheck(new CriteriaAttributeRaw(Collections.singleton(attributeType), Collections.singleton(value)));
    }

    public QueryBuilder andAttributeValueRange(AttributeTypeToken attributeType, String fromValue, String toValue) {
        return this.addAndCheck(new CriteriaAttributeValueRange(attributeType, fromValue, toValue));
    }

    public QueryBuilder and(AttributeTypeToken attributeType, String value, QueryOption ... options) {
        return this.and(Collections.singleton(attributeType), Collections.singleton(value), options);
    }

    public QueryBuilder and(Collection<AttributeTypeToken> attributeTypes, String value, QueryOption ... options) {
        return this.and(attributeTypes, Collections.singleton(value), options);
    }

    public QueryBuilder and(Collection<AttributeTypeToken> attributeTypes, Collection<String> values, QueryOption ... options) {
        boolean isIncludeAllTypes = attributeTypes.contains(QueryBuilder.ANY_ATTRIBUTE_TYPE);
        return this.addAndCheck(new CriteriaAttributeKeywords(isIncludeAllTypes, attributeTypes, this.tokenService, values, options));
    }

    public QueryBuilder andNameEquals(String artifactName) {
        return this.andAttributeIs((AttributeTypeToken)CoreAttributeTypes.Name, artifactName);
    }

    public QueryBuilder andIds(ArtifactId ... ids) {
        return this.andIds(Arrays.asList(ids));
    }

    public QueryBuilder andRelatedTo(RelationTypeSide relationTypeSide, Collection<? extends ArtifactId> artifacts) {
        return this.addAndCheck(new CriteriaRelatedTo(relationTypeSide, artifacts));
    }

    public QueryBuilder andRelatedTo(RelationTypeSide relationTypeSide, ArtifactId artifactId) {
        return this.addAndCheck(new CriteriaRelatedTo(relationTypeSide, artifactId));
    }

    public QueryBuilder andRelatedRecursive(RelationTypeSide relationTypeSide, ArtifactId artifactId) {
        return this.addAndCheck(new CriteriaRelatedRecursive((RelationTypeToken)relationTypeSide, artifactId));
    }

    public QueryBuilder followRelation(RelationTypeSide relationTypeSide) {
        this.addAndCheck(new CriteriaRelationTypeFollow(relationTypeSide, ArtifactTypeToken.SENTINEL, true, true));
        this.newCriteriaSet();
        return this;
    }

    private QueryBuilder addAndCheck(Criteria criteria) {
        criteria.checkValid(this.getOptions());
        this.addCriteria(criteria);
        return this;
    }

    public QueryBuilder andIsHeirarchicalRootArtifact() {
        this.andId((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot);
        return this;
    }

    public QueryBuilder follow(RelationTypeSide relationTypeSide) {
        return this.follow(relationTypeSide, ArtifactTypeToken.SENTINEL, true);
    }

    public QueryBuilder follow(RelationTypeSide relationTypeSide, ArtifactTypeToken artifactType) {
        return this.follow(relationTypeSide, artifactType, true);
    }

    public QueryBuilder followNoSelect(RelationTypeSide relationTypeSide, ArtifactTypeToken artifactType) {
        return this.follow(relationTypeSide, artifactType, false);
    }

    public QueryBuilder followAll(Boolean singleLevel) {
        OptionsUtil.setSingleLevelRelationsSearch(this.getOptions(), singleLevel);
        return this.followAll();
    }

    public QueryBuilder followAll() {
        return this.follow(RelationTypeSide.SENTINEL, ArtifactTypeToken.SENTINEL, true);
    }

    public List<RelationTypeSide> getRelationTypesForLevel(int level) {
        int depth = this.getDepth();
        if (level > depth) {
            throw new OseeCoreException("level greater than depth of query", new Object[0]);
        }
        QueryData cursor = this;
        int i = 0;
        while (i < depth - level) {
            cursor = cursor.getParentQueryData();
            ++i;
        }
        ArrayList<RelationTypeSide> sides = new ArrayList<RelationTypeSide>();
        CriteriaRelationTypeFollow criteria = cursor.getCriteriaByType(CriteriaRelationTypeFollow.class).get(0);
        sides.add((RelationTypeSide)criteria.getType());
        return sides;
    }

    private int getDepth() {
        int depth = 0;
        QueryData cursor = this.getParentQueryData();
        while (cursor != null) {
            cursor = cursor.getParentQueryData();
            ++depth;
        }
        return depth;
    }

    private QueryBuilder follow(RelationTypeSide relationTypeSide, ArtifactTypeToken artifactType, boolean terminalFollow) {
        QueryData followQueryData = this.followQueryData();
        followQueryData.followCausesChild = terminalFollow;
        followQueryData.addCriteria((Criteria)new CriteriaRelationTypeFollow(relationTypeSide, artifactType, terminalFollow, true));
        if (this.hasCriteriaType(CriteriaFollowSearch.class)) {
            followQueryData.addCriteria(this.getAllCriteria().stream().filter(a -> a.getClass().equals(CriteriaFollowSearch.class)).findFirst().get());
        }
        if (this.hasCriteriaType(CriteriaAttributeSort.class)) {
            followQueryData.addCriteria((Criteria)new CriteriaAttributeSort(-1L));
        }
        if (relationTypeSide.isInvalid()) {
            followQueryData = this.followQueryData();
            followQueryData.addCriteria((Criteria)new CriteriaRelationTypeFollow(relationTypeSide, artifactType, terminalFollow, false));
        }
        return followQueryData;
    }

    public QueryBuilder followFork(RelationTypeSide relationTypeSide) {
        return this.followFork(relationTypeSide, ArtifactTypeToken.SENTINEL, null);
    }

    public QueryBuilder followFork(RelationTypeSide relationTypeSide, QueryBuilder queryBuilder) {
        return this.followFork(relationTypeSide, ArtifactTypeToken.SENTINEL, queryBuilder);
    }

    public QueryBuilder followFork(RelationTypeSide relationTypeSide, ArtifactTypeToken artifactType, QueryBuilder queryBuilder) {
        QueryData followQueryData = this.followQueryData();
        followQueryData.addCriteria((Criteria)new CriteriaRelationTypeFollow(relationTypeSide, artifactType, true, true));
        if (this.hasCriteriaType(CriteriaFollowSearch.class)) {
            followQueryData.addCriteria(this.getAllCriteria().stream().filter(a -> a.getClass().equals(CriteriaFollowSearch.class)).findFirst().get());
        }
        if (this.hasCriteriaType(CriteriaAttributeSort.class)) {
            followQueryData.addCriteria((Criteria)new CriteriaAttributeSort(-1L));
        }
        if (queryBuilder != null) {
            QueryData descendant = (QueryData)queryBuilder;
            while (descendant.getParentQueryData() != null) {
                if ((descendant = descendant.getParentQueryData()).getParentQueryData() == null || descendant.getParentQueryData().getOnlyCriteriaSet().isEmpty()) break;
            }
            this.loadChildQueryData(descendant, followQueryData);
        }
        return this;
    }

    private void loadChildQueryData(QueryData queryData, QueryData parent) {
        QueryData child = new QueryData(parent);
        for (Criteria criteria : queryData.getOnlyCriteriaSet()) {
            child.addCriteria(criteria);
            if (parent.hasCriteriaType(CriteriaFollowSearch.class)) {
                child.addCriteria(this.getAllCriteria().stream().filter(a -> a.getClass().equals(CriteriaFollowSearch.class)).findFirst().get());
            }
            if (!this.hasCriteriaType(CriteriaAttributeSort.class)) continue;
            child.addCriteria((Criteria)new CriteriaAttributeSort(-1L));
        }
        for (QueryData grandChild : queryData.getChildrenQueryData()) {
            if (queryData.getOnlyCriteriaSet().isEmpty()) {
                this.loadChildQueryData(grandChild, parent);
                continue;
            }
            this.loadChildQueryData(grandChild, child);
        }
        if (!child.getOnlyCriteriaSet().isEmpty()) {
            parent.childrenQueryData.add(child);
        }
    }

    private QueryData followQueryData() {
        if (this.followCausesChild) {
            QueryData child = new QueryData(this);
            this.childrenQueryData.add(child);
            return child;
        }
        return this;
    }

    public List<Map<String, Object>> asArtifactMaps() {
        this.setQueryType(QueryType.ATTRIBUTES_ONLY);
        return this.queryEngine.asArtifactMaps(this);
    }

    public ArtifactTable asArtifactsTable() {
        this.setQueryType(QueryType.ATTRIBUTES_ONLY);
        return this.queryEngine.asArtifactsTable(this, this.queryFactory);
    }

    public Map<ArtifactId, ArtifactReadable> asArtifactMap() {
        this.setQueryType(QueryType.SELECT);
        return this.queryEngine.asArtifactMap(this, this.queryFactory);
    }

    public Map<ArtifactId, ArtifactReadable> asArtifactMap(Map<ArtifactId, ArtifactReadable> map) {
        this.setQueryType(QueryType.SELECT);
        return this.queryEngine.asArtifactMap(this, this.queryFactory, map);
    }

    public List<ArtifactReadable> asArtifacts() {
        this.setQueryType(QueryType.SELECT);
        return this.queryEngine.asArtifacts(this, this.queryFactory);
    }

    public ArtifactReadable asArtifact() {
        this.setQueryType(QueryType.SELECT);
        return (ArtifactReadable)org.eclipse.osee.framework.jdk.core.util.Collections.exactlyOne(this.queryEngine.asArtifact(this, this.queryFactory));
    }

    public ArtifactToken asArtifactToken() {
        return (ArtifactToken)org.eclipse.osee.framework.jdk.core.util.Collections.exactlyOne(this.asArtifactTokens());
    }

    public List<ArtifactToken> asArtifactTokens() {
        return this.asArtifactTokens((AttributeTypeToken)CoreAttributeTypes.Name);
    }

    public Map<ArtifactId, ArtifactToken> asArtifactTokenMap() {
        this.select((AttributeTypeToken)CoreAttributeTypes.Name);
        return this.queryEngine.asArtifactTokenMap(this);
    }

    public List<ArtifactToken> asArtifactTokens(AttributeTypeToken attributeType) {
        this.setQueryType(QueryType.TOKEN);
        this.select(attributeType);
        return this.queryEngine.asArtifactTokens(this);
    }

    public ArtifactId asArtifactId() {
        return (ArtifactId)org.eclipse.osee.framework.jdk.core.util.Collections.exactlyOne(this.asArtifactIds());
    }

    public ArtifactId asArtifactIdOrSentinel() {
        return (ArtifactId)org.eclipse.osee.framework.jdk.core.util.Collections.oneOrSentinel(this.asArtifactIds(), (Object)ArtifactId.SENTINEL);
    }

    public ArtifactToken asArtifactTokenOrSentinel() {
        return (ArtifactToken)org.eclipse.osee.framework.jdk.core.util.Collections.oneOrSentinel(this.asArtifactTokens(), (Object)ArtifactToken.SENTINEL);
    }

    public ArtifactReadable asArtifactOrSentinel() {
        return (ArtifactReadable)org.eclipse.osee.framework.jdk.core.util.Collections.oneOrSentinel(this.asArtifacts(), (Object)ArtifactReadable.SENTINEL);
    }

    public List<ArtifactId> asArtifactIds() {
        this.setQueryType(QueryType.ID);
        return this.queryEngine.asArtifactIds(this);
    }

    public ResultSet<ArtifactReadable> getResults() {
        this.setQueryType(QueryType.SELECT);
        return this.artQueryFactory.createSearch(this);
    }

    public ArtifactReadable getArtifact() {
        return (ArtifactReadable)this.getResults().getExactlyOne();
    }

    public ArtifactReadable getArtifactOrNull() {
        return (ArtifactReadable)this.getResults().getAtMostOneOrNull();
    }

    public ResultSet<Match<ArtifactReadable, AttributeReadable<?>>> getMatches() {
        return this.artQueryFactory.createSearchWithMatches(null, this);
    }

    public int getCount() {
        this.setQueryType(QueryType.COUNT);
        return this.queryEngine.getArtifactCount(this);
    }

    public boolean exists() {
        return this.getCount() > 0;
    }

    public ArtifactToken getArtifactOrSentinal() {
        ArtifactReadable art = this.getArtifactOrNull();
        if (art == null) {
            return ArtifactToken.SENTINEL;
        }
        return art;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
        if (this.parentQueryData != null) {
            this.parentQueryData.setQueryType(queryType);
        }
    }

    public String getMainTableAlias(SqlTable table, Function<SqlTable, String> addTable) {
        String alias = this.mainAliases.get(table);
        if (alias == null) {
            alias = addTable.apply(table);
            this.mainAliases.put(table, alias);
        }
        return alias;
    }

    public boolean mainTableAliasExists(SqlTable table) {
        return this.mainAliases.containsKey(table);
    }

    public QueryData getRootQueryData() {
        if (this.parentQueryData == null) {
            return this;
        }
        return this.parentQueryData.getRootQueryData();
    }

    public QueryData getParentQueryData() {
        return this.parentQueryData;
    }

    public List<QueryData> getChildrenQueryData() {
        return this.childrenQueryData;
    }

    public boolean isFollowCausesChild() {
        return this.followCausesChild;
    }

    public ApplicabilityId getAppId() {
        return this.appId;
    }

    public List<BranchCategoryToken> getBranchCategories() {
        return this.queryFactory.branchQuery().getBranchCategories((BranchId)this.branch);
    }

    public QueryBuilder isOnPage(long pageNum, long pageSize) {
        return this.addAndCheck(new CriteriaPagination(pageNum, pageSize));
    }

    public QueryBuilder setOrderByAttribute(AttributeTypeToken attributeTypeToken) {
        if (this.orderMechanism().equals("RELATION")) {
            this.setOrderMechanism("RELATION AND ATTRIBUTE");
        } else {
            this.setOrderMechanism("ATTRIBUTE");
        }
        OptionsUtil.setOrderByAttribute(this.getOptions(), (AttributeTypeId)attributeTypeToken);
        return this.addAndCheck(new CriteriaAttributeSort(attributeTypeToken));
    }

    public AttributeTypeToken orderByAttribute() {
        return AttributeTypeToken.valueOf((Long)OptionsUtil.getOrderByAttribute(this.getOptions()), (String)"");
    }

    public QueryBuilder setOrderByAttributeDirection(SortOrder direction) {
        OptionsUtil.setOrderByAttributeDirection(this.getOptions(), direction);
        return this;
    }

    public SortOrder orderByAttributeDirection() {
        return OptionsUtil.getOrderByAttributeDirection(this.getOptions());
    }

    public QueryBuilder setOrderMechanism(String orderMechanism) {
        OptionsUtil.setOrderByMechanism(this.getOptions(), orderMechanism);
        return this;
    }

    public QueryBuilder setMaxTime(Date maxTime) {
        OptionsUtil.setMaxTime(this.getOptions(), maxTime);
        OptionsUtil.setLegacyPostProcessing(this.getOptions(), false);
        return this;
    }

    public Date getMaxTime() {
        return OptionsUtil.getMaxTime(this.getOptions());
    }

    public String orderMechanism() {
        return OptionsUtil.getOrderByMechanism(this.getOptions());
    }

    public ArtifactTableOptions getTableoptions() {
        return this.tableoptions;
    }

    public void setTableoptions(ArtifactTableOptions tableoptions) {
        this.tableoptions = tableoptions;
    }

    public QueryBuilder getReferenceArtifact(BranchId branch, AttributeTypeToken attributeType) {
        return this.addAndCheck(new CriteriaGetReferenceArtifact(branch, attributeType));
    }

    public QueryBuilder setLegacyPostProcessing(boolean postProcessing) {
        OptionsUtil.setLegacyPostProcessing(this.getOptions(), postProcessing);
        return this;
    }

    public boolean getLegacyPostProcessing() {
        return OptionsUtil.getLegacyPostProcessing(this.getOptions());
    }
}

