/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.xml.publishing;

import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.xml.publishing.XmlAttributeSpecification;
import org.eclipse.osee.framework.core.xml.publishing.XmlNameSpecification;
import org.eclipse.osee.framework.core.xml.publishing.XmlTagType;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public interface XmlTagSpecification
extends XmlNameSpecification {
    public static final /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$osee$framework$core$xml$publishing$XmlTagType;

    public Set<XmlAttributeSpecification> getAllowedAttributes();

    public @NonNull String getCloseTag();

    public @NonNull String getOpenTag();

    public @NonNull String getSelfCloseTag();

    public int sizeCloseTag();

    public int sizeOpenTag();

    public int sizeSelfCloseTag();

    default public @NonNull String getTag(@NonNull XmlTagType xmlTagType) {
        XmlTagType safeXmlTagType = (XmlTagType)((Object)Conditions.requireNonNull((Object)((Object)xmlTagType), (String)"xmlTagType"));
        switch (safeXmlTagType) {
            case OPEN: {
                return this.getOpenTag();
            }
            case CLOSE: {
                return this.getCloseTag();
            }
            case SELF_CLOSING: {
                return this.getSelfCloseTag();
            }
        }
        throw Conditions.invalidCase((Object)((Object)xmlTagType), (String)"xmlTagType", IllegalArgumentException::new);
    }

    public String getRegexOpenTag();

    default public boolean isTagName(CharSequence tagName) {
        return this.getFullname().contentEquals(tagName);
    }

    default public boolean isValidAttribute(XmlAttributeSpecification xmlAttribute) {
        return this.getAllowedAttributes().contains(xmlAttribute);
    }

    default public int size(@NonNull XmlTagType xmlTagType) {
        XmlTagType safeXmlTagType = (XmlTagType)((Object)Conditions.requireNonNull((Object)((Object)xmlTagType), (String)"xmlTagType"));
        switch (safeXmlTagType) {
            case OPEN: {
                return this.sizeOpenTag();
            }
            case CLOSE: {
                return this.sizeCloseTag();
            }
            case SELF_CLOSING: {
                return this.sizeSelfCloseTag();
            }
        }
        throw Conditions.invalidCase((Object)((Object)xmlTagType), (String)"xmlTagType", IllegalArgumentException::new);
    }

    default public @NonNull String getRegexEverythingBetweenTags() {
        return new StringBuilder(128).append("<").append(this.getFullname()).append("[\\s\\S]+?").append(this.getCloseTag()).toString();
    }

    public static int sizeBothTags(XmlTagSpecification ... xmlTagSpecifications) {
        if (Objects.isNull(xmlTagSpecifications) || xmlTagSpecifications.length == 0) {
            return 0;
        }
        int sum = 0;
        XmlTagSpecification[] xmlTagSpecificationArray = xmlTagSpecifications;
        int n = xmlTagSpecifications.length;
        int n2 = 0;
        while (n2 < n) {
            XmlTagSpecification xmlTagSpecification = xmlTagSpecificationArray[n2];
            sum += xmlTagSpecification.sizeOpenTag() + xmlTagSpecification.sizeCloseTag();
            ++n2;
        }
        return sum;
    }

    public static int sizeCloseTags(XmlTagSpecification ... xmlTags) {
        if (Objects.isNull(xmlTags) || xmlTags.length == 0) {
            return 0;
        }
        int sum = 0;
        int i = 0;
        while (i < xmlTags.length) {
            sum += xmlTags[i].sizeCloseTag();
            ++i;
        }
        return sum;
    }

    public static int sizeOpenTags(XmlTagSpecification ... xmlTags) {
        if (Objects.isNull(xmlTags) || xmlTags.length == 0) {
            return 0;
        }
        int sum = 0;
        int i = 0;
        while (i < xmlTags.length) {
            sum += xmlTags[i].sizeOpenTag();
            ++i;
        }
        return sum;
    }
}

