/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.xml.publishing;

import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.xml.publishing.AbstractXmlNamespaceSpecification;
import org.eclipse.osee.framework.core.xml.publishing.AbstractXmlTagSpecification;
import org.eclipse.osee.framework.core.xml.publishing.WordMlAttribute;
import org.eclipse.osee.framework.core.xml.publishing.WordXmlNamespace;
import org.eclipse.osee.framework.core.xml.publishing.XmlAttribute;
import org.eclipse.osee.framework.core.xml.publishing.XmlAttributeSpecification;
import org.eclipse.osee.framework.core.xml.publishing.XmlNamespaceSpecification;
import org.eclipse.osee.framework.core.xml.publishing.XmlTagSpecification;

public enum WordMlTag implements XmlTagSpecification
{
    BODY(WordXmlNamespace.WORDML, "body"),
    BOLD(WordXmlNamespace.WORDML, "b"),
    COLOR(WordXmlNamespace.WORDML, "color", Set.of(WordMlAttribute.VALUE)),
    FIELD_CHARACTER(WordXmlNamespace.WORDML, "fldChar", Set.of(WordMlAttribute.FIELD_CHARACTER_TYPE)),
    FIELD_SIMPLE(WordXmlNamespace.WORDML, "fldSimple", Set.of(WordMlAttribute.INSTRUCTION)),
    FOOTER(WordXmlNamespace.WORDML, "ftr"),
    HARD_BREAK(WordXmlNamespace.WORDML, "br", Set.of(WordMlAttribute.TYPE)),
    HEADER(WordXmlNamespace.WORDML, "hdr"),
    HLINK(WordXmlNamespace.WORDML, "hlink", Set.of(WordMlAttribute.DESTINATION)),
    INSTRUCTION_TEXT(WordXmlNamespace.WORDML, "instrText"),
    LIST_PRESENTATION(WordXmlNamespace.WORDML, "listPr"),
    NFC(WordXmlNamespace.WORDML, "nfc", Set.of(WordMlAttribute.VALUE)),
    NO_BREAK_HYPHEN(WordXmlNamespace.WORDML, "noBreakHyphen"),
    NO_PROOF(WordXmlNamespace.WORDML, "noProof"),
    OLE_DATA(WordXmlNamespace.WORDML, "docOleData"),
    PAGE_MARGINS(WordXmlNamespace.WORDML, "pgMar", Set.of(WordMlAttribute.BOTTOM, WordMlAttribute.FOOTER, WordMlAttribute.GUTTER, WordMlAttribute.HEADER, WordMlAttribute.LEFT, WordMlAttribute.RIGHT, WordMlAttribute.TOP)),
    PAGE_SIZE(WordXmlNamespace.WORDML, "pgSz", Set.of(WordMlAttribute.CODE, WordMlAttribute.HEIGHT, WordMlAttribute.ORIENTATION, WordMlAttribute.WIDTH)),
    PARAGRAPH(WordXmlNamespace.WORDML, "p"),
    PARAGRAPH_PRESENTATION(WordXmlNamespace.WORDML, "pPr"),
    PARAGRAPH_STYLE(WordXmlNamespace.WORDML, "pStyle", Set.of(WordMlAttribute.VALUE)),
    RUN(WordXmlNamespace.WORDML, "r"),
    RUN_PRESENTATION(WordXmlNamespace.WORDML, "rPr"),
    RUN_STYLE(WordXmlNamespace.WORDML, "rStyle", Set.of(WordMlAttribute.VALUE)),
    SECTION(WordXmlNamespace.WORDML, "sect"),
    SECTION_PRESENTATION(WordXmlNamespace.WORDML, "sectPr"),
    START(WordXmlNamespace.WORDML, "start", Set.of(WordMlAttribute.VALUE)),
    STYLES(WordXmlNamespace.WORDML, "styles"),
    TABLE(WordXmlNamespace.WORDML, "tbl"),
    TABLE_COLUMN(WordXmlNamespace.WORDML, "tc"),
    TABLE_ROW(WordXmlNamespace.WORDML, "tr"),
    TEXT(WordXmlNamespace.WORDML, "t", Set.of(XmlAttribute.SPACE)),
    TYPE(WordXmlNamespace.WORDML, "type", Set.of(WordMlAttribute.VALUE)),
    VANISH(WordXmlNamespace.WORDML, "vanish"),
    WORD_DOCUMENT(WordXmlNamespace.WORDML, "wordDocument");

    private final AbstractXmlTagSpecification abstractTagSpecification;

    private WordMlTag(XmlNamespaceSpecification xmlNamespaceSpecification, String tagName) {
        this(xmlNamespaceSpecification, tagName, Set.of());
    }

    private WordMlTag(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NonNull @NonNull XmlNamespaceSpecification xmlNamespaceSpecification, String tagName, Set<XmlAttributeSpecification> xmlAttributeSpecifications) {
        this.abstractTagSpecification = new AbstractXmlTagSpecification(new AbstractXmlNamespaceSpecification(xmlNamespaceSpecification.getPrefix(), xmlNamespaceSpecification.getUri().orElse(null)), tagName, xmlAttributeSpecifications);
    }

    @Override
    public String getName() {
        return this.abstractTagSpecification.name;
    }

    @Override
    public String getFullname() {
        return this.abstractTagSpecification.fullName;
    }

    @Override
    public String getPrefix() {
        return this.abstractTagSpecification.prefix;
    }

    @Override
    public Optional<String> getUri() {
        return Optional.ofNullable(this.abstractTagSpecification.uri);
    }

    @Override
    public Set<XmlAttributeSpecification> getAllowedAttributes() {
        return this.abstractTagSpecification.attributes;
    }

    @Override
    public @NonNull String getCloseTag() {
        return this.abstractTagSpecification.closeTag;
    }

    @Override
    public @NonNull String getOpenTag() {
        return this.abstractTagSpecification.openTag;
    }

    @Override
    public @NonNull String getSelfCloseTag() {
        return this.abstractTagSpecification.selfCloseTag;
    }

    @Override
    public String getRegexOpenTag() {
        return this.abstractTagSpecification.regexOpenTag;
    }

    @Override
    public int sizeCloseTag() {
        return this.abstractTagSpecification.sizeCloseTag;
    }

    @Override
    public int sizeOpenTag() {
        return this.abstractTagSpecification.sizeOpenTag;
    }

    @Override
    public int sizeSelfCloseTag() {
        return this.abstractTagSpecification.sizeSelfCloseTag;
    }

    @Override
    public @NonNull String getRegexEverythingBetweenTags() {
        return new StringBuilder(128).append("<").append(this.abstractTagSpecification.fullName).append("[\\s\\S]+?").append(this.getCloseTag()).toString();
    }
}

