/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationTypeMultiplicity;

public class RelationOrderUtil {
    private static final long SPACING = (long)Math.pow(2.0, 18.0);

    public static int getRelOrder(RelationTypeToken relType, String insertType, int afterIndex, int beforeIndex, int minOrder, int maxOrder) {
        int relOrder = 0;
        RelationTypeMultiplicity mult = relType.getMultiplicity();
        if (mult.equals((Object)RelationTypeMultiplicity.MANY_TO_MANY) || mult.equals((Object)RelationTypeMultiplicity.ONE_TO_MANY)) {
            relOrder = insertType.equals("start") ? RelationOrderUtil.calculateHeadInsertionOrderIndex(minOrder) : (insertType.equals("insert") ? RelationOrderUtil.calculateInsertionOrderIndex(afterIndex, beforeIndex) : RelationOrderUtil.calculateEndInsertionOrderIndex(maxOrder));
        }
        return relOrder;
    }

    static int calculateHeadInsertionOrderIndex(int currentHeadIndex) {
        long idealIndex = (long)currentHeadIndex - SPACING;
        if (idealIndex > Integer.MIN_VALUE) {
            return (int)idealIndex;
        }
        return RelationOrderUtil.calculateInsertionOrderIndex(Integer.MIN_VALUE, currentHeadIndex);
    }

    static int calculateEndInsertionOrderIndex(int currentEndIndex) {
        long idealIndex = (long)currentEndIndex + SPACING;
        if (idealIndex < Integer.MAX_VALUE) {
            return (int)idealIndex;
        }
        return RelationOrderUtil.calculateInsertionOrderIndex(currentEndIndex, Integer.MAX_VALUE);
    }

    static int calculateInsertionOrderIndex(int afterIndex, int beforeIndex) {
        return (int)((long)afterIndex + (long)beforeIndex) / 2;
    }
}

