/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.renderer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.core.renderer.RenderLocation;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Message;

public class RenderLocationDeserializer
extends StdDeserializer<RenderLocation> {
    private static final long serialVersionUID = 1L;

    public RenderLocationDeserializer() {
        super(RenderLocation.class);
    }

    public @NonNull RenderLocation deserialize(@NonNull JsonParser jsonParser, @Nullable DeserializationContext deserializationContext) throws IOException {
        JsonParser safeJsonParser = (JsonParser)Conditions.requireNonNull((Object)jsonParser);
        JsonNode readTree = (JsonNode)safeJsonParser.getCodec().readTree(safeJsonParser);
        JsonNode safeReadTree = (JsonNode)Conditions.requireNonNull((Object)readTree);
        String renderLocationName = safeReadTree instanceof TextNode ? ((TextNode)readTree).asText() : readTree.get("renderLocation").asText();
        try {
            RenderLocation renderLocation = RenderLocation.valueOf(renderLocationName);
            return (RenderLocation)((Object)Conditions.requireNonNull((Object)((Object)renderLocation)));
        }
        catch (Exception exception) {
            throw new OseeCoreException(new Message().title((CharSequence)"RenderLocation::deserialize, unknown format name.").indentInc().segment((CharSequence)"Render Location", (Object)renderLocationName).toString(), new Object[0]);
        }
    }
}

