/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.publishing.Cause;
import org.eclipse.osee.framework.core.publishing.DataAccessException;
import org.eclipse.osee.framework.core.publishing.DataAccessOperations;
import org.eclipse.osee.framework.core.publishing.FilterForView;
import org.eclipse.osee.framework.core.publishing.IdentifierTypeIndicator;
import org.eclipse.osee.framework.core.publishing.IncludeDeleted;
import org.eclipse.osee.framework.core.publishing.ProcessRecursively;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;
import org.eclipse.osee.framework.core.publishing.PublishingErrorLog;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.type.Result;
import org.eclipse.osee.framework.jdk.core.type.Triplet;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.DoubleEnumMap;
import org.eclipse.osee.framework.jdk.core.util.DoubleMap;
import org.eclipse.osee.framework.jdk.core.util.EnumMapHashMap;
import org.eclipse.osee.framework.jdk.core.util.ListMap;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.RankHashMap;
import org.eclipse.osee.framework.jdk.core.util.RankMap;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class PublishingArtifactLoader
implements ToMessage {
    private DoubleMap<BranchIndicator, ApplicabilityId, Boolean> applicabilityMap;
    AtsTeamWorkflowLoader atsTeamWorkflowLoader;
    private BranchSpecification branchSpecification;
    private DoubleEnumMap<BranchIndicator, FilterForView, BranchSpecification> branchSpecificationMap;
    private BranchSpecification branchSpecificationProductLine;
    private BranchSpecification branchSpecificationProductLineWithoutView;
    private BranchSpecification branchSpecificationWithoutView;
    private int cacheClearBranchView;
    private int cacheHit;
    private int cacheMiss;
    private int cacheSetApplicable;
    private int cacheTest;
    private boolean changedArtifactsLoaded;
    private ListMap<ArtifactId, PublishingArtifact> changedArtifactsMap;
    private int childCacheHit;
    private int childCacheMiss;
    private RankMap<List<PublishingArtifact>> childrenCacheMap;
    private final DataAccessOperations dataAccessOperations;
    private int dropCount;
    private int getChildrenCount;
    private int getParentCount;
    private int loadByIdCacheHitCount;
    private int maxLoadByIdCacheHitCount;
    private int maxLoaded;
    private int maxLoadRequest;
    private DoubleMap<BranchIndicator, ArtifactId, PublishingArtifact> publishingArtifactByArtifactIdentifierMap;
    private DoubleMap<BranchIndicator, String, PublishingArtifact> publishingArtifactByGuidMap;
    private final PublishingArtifactFactoryWithoutView publishingArtifactFactoryWithoutView;
    private final PublishingArtifactFactoryWithView publishingArtifactFactoryWithView;
    private final PublishingErrorLog publishingErrorLog;

    public PublishingArtifactLoader(DataAccessOperations dataAccessOperations, PublishingErrorLog publishingErrorLog, PublishingArtifactFactoryWithoutView publishingArtifactFactoryWithoutView, PublishingArtifactFactoryWithView publishingArtifactFactoryWithView, AtsTeamWorkflowLoader atsTeamWorkflowLoader) {
        this.dataAccessOperations = Objects.requireNonNull(dataAccessOperations);
        this.publishingErrorLog = Objects.requireNonNull(publishingErrorLog);
        this.publishingArtifactFactoryWithoutView = Objects.requireNonNull(publishingArtifactFactoryWithoutView);
        this.publishingArtifactFactoryWithView = Objects.requireNonNull(publishingArtifactFactoryWithView);
        this.changedArtifactsLoaded = false;
        this.atsTeamWorkflowLoader = atsTeamWorkflowLoader;
        this.cacheClearBranchView = 0;
        this.cacheHit = 0;
        this.cacheMiss = 0;
        this.cacheSetApplicable = 0;
        this.cacheTest = 0;
        this.childCacheHit = 0;
        this.childCacheMiss = 0;
        this.dropCount = 0;
        this.getChildrenCount = 0;
        this.getParentCount = 0;
        this.loadByIdCacheHitCount = 0;
        this.maxLoaded = 0;
        this.maxLoadRequest = 0;
        this.maxLoadByIdCacheHitCount = 0;
    }

    private void cacheIt(BranchIndicator branchIndicator, ArtifactId artifactIdentifier, PublishingArtifact loadedArtifact) {
        PublishingArtifact cachedArtifact;
        assert (Objects.nonNull((Object)branchIndicator) && Objects.nonNull(artifactIdentifier) && Objects.nonNull(loadedArtifact) && (loadedArtifact.isValid() || loadedArtifact instanceof PublishingArtifact.PublishingArtifactNotFound) && (loadedArtifact.isValid() ? loadedArtifact.getId().equals(artifactIdentifier.getId()) : Strings.isValidAndNonBlank((String)loadedArtifact.getGuid())) && (loadedArtifact.getArtifactId().isValid() && Strings.isValidAndNonBlank((String)loadedArtifact.getGuid()) ? loadedArtifact.isFound() : !loadedArtifact.isFound()) && (loadedArtifact.isInvalid() || loadedArtifact.getBranch().isSameBranch(this.getBranchSpecification(branchIndicator, FilterForView.NO).getBranchId()))) : new Message().title((CharSequence)"PublishingArtifactLoader::cacheIt, invalid input parameters.").indentInc().segment((CharSequence)"Artifact Identifier", (Object)artifactIdentifier).segment((CharSequence)"Loaded Artifact", (Object)loadedArtifact).segment((CharSequence)"Loaded Artifact Is Found", (Object)loadedArtifact.isFound()).segment((CharSequence)"Loaded Artiact Has View", (Object)loadedArtifact.branchHasView()).toString();
        String guid = loadedArtifact.getGuid();
        PublishingArtifact artifactCachedByArtifactIdentifier = this.publishingArtifactByArtifactIdentifierMap.get((Object)branchIndicator, (Object)artifactIdentifier).orElse(null);
        PublishingArtifact artifactCachedByGuid = this.publishingArtifactByGuidMap.get((Object)branchIndicator, (Object)guid).orElse(null);
        assert (Objects.isNull(artifactCachedByArtifactIdentifier) || Objects.isNull(artifactCachedByGuid) || !artifactCachedByArtifactIdentifier.isFound() || !artifactCachedByGuid.isFound() || artifactCachedByArtifactIdentifier == artifactCachedByGuid) : new Message().title((CharSequence)"PublishingArtifactLoader::cacheIt, artifact identifier and GUID cache entries dont' match.").indentInc().segment((CharSequence)"Branch Indicator", (Object)branchIndicator).segment((CharSequence)"Artifact Identifier", (Object)artifactIdentifier).segment((CharSequence)"Artifact GUID", (Object)guid).segmentToMessage((CharSequence)"Artifact Identifier Cache", (ToMessage)artifactCachedByArtifactIdentifier).segmentToMessage((CharSequence)"GUID Cache", (ToMessage)artifactCachedByGuid).segmentToMessage((CharSequence)"Loaded Artifact", (ToMessage)loadedArtifact).toString();
        PublishingArtifact publishingArtifact = cachedArtifact = artifactIdentifier.isValid() ? artifactCachedByArtifactIdentifier : artifactCachedByGuid;
        assert (Objects.isNull(cachedArtifact) || cachedArtifact.getBranch().isSameBranch(this.getBranchSpecification(branchIndicator, FilterForView.NO).getBranchId())) : new Message().title((CharSequence)"PublishingArtifactLoader::cacheIt, cached artifact branch does not match the parameter \"branchIdentifier.").indentInc().segment((CharSequence)"Branch Indicator", (Object)branchIndicator).segment((CharSequence)"Cached Artifact Branch Identifier", (Object)cachedArtifact.getBranchIdString()).toString();
        int state = (Objects.nonNull(cachedArtifact) && cachedArtifact.branchHasView() ? 1 : 0) + (Objects.nonNull(cachedArtifact) && !cachedArtifact.branchHasView() ? 2 : 0) + (Objects.nonNull(cachedArtifact) && cachedArtifact.isFound() ? 4 : 0) + (Objects.nonNull(cachedArtifact) && !cachedArtifact.isFound() ? 8 : 0) + (loadedArtifact.isValid() && Strings.isValidAndNonBlank((String)guid) ? 16 : 0) + (loadedArtifact.isInvalid() && Strings.isValidAndNonBlank((String)guid) ? 32 : 0) + (loadedArtifact.isValid() && Strings.isInvalidOrBlank((String)guid) ? 64 : 0) + (loadedArtifact.branchHasView() ? 128 : 0);
        switch (state) {
            case 16: 
            case 25: 
            case 26: 
            case 144: {
                assert (Objects.nonNull(loadedArtifact.getArtifactId()) && loadedArtifact.getArtifactId().isValid() && Strings.isValidAndNonBlank((String)loadedArtifact.getGuid()) && loadedArtifact.isFound()) : this.cacheItErrorMessage("artifact to be cached by ArtifactId and GUID has unexpected state.", "Add To ArtifactId And GUID Caches", state, branchIndicator, cachedArtifact, loadedArtifact);
                this.publishingArtifactByArtifactIdentifierMap.put((Object)branchIndicator, (Object)artifactIdentifier, (Object)loadedArtifact);
                this.publishingArtifactByGuidMap.put((Object)branchIndicator, (Object)guid, (Object)loadedArtifact);
                if (loadedArtifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                    this.publishingArtifactByArtifactIdentifierMap.put((Object)branchIndicator, (Object)artifactIdentifier, (Object)loadedArtifact);
                    this.publishingArtifactByGuidMap.put((Object)branchIndicator, (Object)guid, (Object)loadedArtifact);
                }
                return;
            }
            case 64: 
            case 192: {
                assert (Objects.nonNull(loadedArtifact.getArtifactId()) && loadedArtifact.getArtifactId().isValid() && Strings.isInvalidOrBlank((String)loadedArtifact.getGuid()) && !loadedArtifact.isFound()) : this.cacheItErrorMessage("artifact to be cached by ArtifactId only has unexpected state.", "Add To ArtifactId Cache", state, branchIndicator, cachedArtifact, loadedArtifact);
                this.publishingArtifactByArtifactIdentifierMap.put((Object)branchIndicator, (Object)artifactIdentifier, (Object)loadedArtifact);
                return;
            }
            case 32: 
            case 160: {
                assert ((Objects.isNull(loadedArtifact.getArtifactId()) || loadedArtifact.getArtifactId().isInvalid()) && Strings.isValidAndNonBlank((String)loadedArtifact.getGuid()) && !loadedArtifact.isFound()) : this.cacheItErrorMessage("artifact to be cached by GUID only has unexpected state.", "Add To GUID Cache", state, branchIndicator, cachedArtifact, loadedArtifact);
                this.publishingArtifactByGuidMap.put((Object)branchIndicator, (Object)guid, (Object)loadedArtifact);
                return;
            }
            case 41: 
            case 73: {
                assert (Objects.nonNull(cachedArtifact) && (cachedArtifact.isInvalid() || Strings.isInvalidOrBlank((String)cachedArtifact.getGuid())) && !cachedArtifact.isFound()) : this.cacheItErrorMessage("cached artifact is not a not found marker.", "Remove View From Cached Artifact", state, branchIndicator, cachedArtifact, loadedArtifact);
                cachedArtifact.clearBranchView();
                ++this.cacheClearBranchView;
                return;
            }
            case 150: {
                assert (Objects.nonNull(cachedArtifact) && cachedArtifact.getArtifactId().isValid() && Strings.isValidAndNonBlank((String)cachedArtifact.getGuid()) && cachedArtifact.isFound() && cachedArtifact.getArtifactId().getId().equals(loadedArtifact.getArtifactId().getId()) && cachedArtifact.getGuid().equals(loadedArtifact.getGuid())) : this.cacheItErrorMessage("cached artifact to be set applicable is in an unexpected state.", "Set Cached Artifact As Applicable", state, branchIndicator, cachedArtifact, loadedArtifact);
                cachedArtifact.setApplicable();
                ++this.cacheSetApplicable;
                return;
            }
            case 21: 
            case 22: 
            case 42: 
            case 74: 
            case 149: 
            case 169: 
            case 170: 
            case 201: 
            case 202: {
                assert (Objects.nonNull(cachedArtifact) && cachedArtifact.getId().equals(loadedArtifact.getId()) && cachedArtifact.getGuid().equals(loadedArtifact.getGuid()) && cachedArtifact.isFound() == loadedArtifact.isFound() && (!cachedArtifact.branchHasView() || cachedArtifact.isFound() || loadedArtifact.isFound() || loadedArtifact.branchHasView())) : this.cacheItErrorMessage("dropped artifact vs cached artifact has unexpected differences.", "Drop", state, branchIndicator, cachedArtifact, loadedArtifact);
                ++this.dropCount;
                return;
            }
            case 37: 
            case 38: 
            case 69: 
            case 70: 
            case 153: 
            case 154: 
            case 165: 
            case 166: 
            case 197: 
            case 198: {
                throw new OseeCoreException(this.cacheItErrorMessage("loaded artifact conflicts with cached artifact.", "Exception", state, branchIndicator, cachedArtifact, loadedArtifact), new Object[0]);
            }
        }
        throw new IllegalStateException(this.cacheItErrorMessage("invalid state.", "Unexpected State", state, branchIndicator, cachedArtifact, loadedArtifact));
    }

    String cacheItErrorMessage(String title, String action, int state, BranchIndicator branchIndicator, PublishingArtifact cachedArtifact, PublishingArtifact loadedArtifact) {
        Message message = new Message().title((CharSequence)"PublishingArtifactLoader::cacheIt, ").append((CharSequence)title).indentInc().segment((CharSequence)"Action", (Object)action).segment((CharSequence)"State", (Object)state).segment((CharSequence)"Branch Indicator", (Object)branchIndicator).title((CharSequence)"Cached Artifact").indentInc();
        if (Objects.nonNull(cachedArtifact)) {
            message.segment((CharSequence)"Artifact Identifier", (Object)cachedArtifact.getIdString()).segment((CharSequence)"Artifact GUID", (Object)cachedArtifact.getGuid()).segment((CharSequence)"If Found", (Object)cachedArtifact.isFound()).segment((CharSequence)"branchHasView", (Object)cachedArtifact.branchHasView()).segment((CharSequence)"Is Applicable", (Object)cachedArtifact.isApplicable());
        } else {
            message.title((CharSequence)"(null)");
        }
        message.indentDec().title((CharSequence)"Loaded Artifact").indentInc();
        if (Objects.nonNull(loadedArtifact)) {
            message.segment((CharSequence)"Artifact Identifier", (Object)loadedArtifact.getIdString()).segment((CharSequence)"Artifact GUID", (Object)loadedArtifact.getGuid()).segment((CharSequence)"If Found", (Object)loadedArtifact.isFound()).segment((CharSequence)"branchHasView", (Object)loadedArtifact.branchHasView()).segment((CharSequence)"Is Applicable", (Object)loadedArtifact.isApplicable());
        } else {
            message.title((CharSequence)"(null)");
        }
        return message.toString();
    }

    private boolean checkIsArtifactApplicable(BranchIndicator branchIndicator, ArtifactReadable artifact) {
        assert (this.branchSpecification.hasView()) : "PublishingArtifactLoader::checkIsArtifactApplicable, expected configured branch specification to have a view.";
        ApplicabilityId applicabilityId = artifact.getApplicability();
        return (Boolean)this.applicabilityMap.get((Object)branchIndicator, (Object)applicabilityId).or(() -> this.dataAccessOperations.getBranchViewsForApplicability(this.branchSpecification, applicabilityId).mapValue(validViews -> validViews.contains(this.branchSpecification.getViewId())).peekValue(isIncluded -> {
            Optional optional = this.applicabilityMap.put((Object)branchIndicator, (Object)applicabilityId, isIncluded);
        }).getAsOptionalOrElseThrow(exception -> {
            throw new OseeCoreException(new Message().title((CharSequence)"WordTemplateProcessorServer::checkIsArtifactApplicable, failed to get applicable views for branch.").indentInc().reasonFollows((Throwable)exception).segment((CharSequence)"Branch Identifier", (Object)this.branchSpecification.getBranchId()).segment((CharSequence)"Branch View", (Object)this.branchSpecification.getViewId()).segment((CharSequence)"Artifact Identifier", (Object)artifact.getIdString()).segment((CharSequence)"Artifact Applicability", (Object)applicabilityId).toString(), (Throwable)exception);
        })).get();
    }

    public void clearProcessedFlags() {
        this.publishingArtifactByArtifactIdentifierMap.values().stream().filter(PublishingArtifact::isFound).forEach(PublishingArtifact::clearProcessed);
    }

    public PublishingArtifactLoader configure(BranchSpecification branchSpecification, int estimatedArtifactCount) {
        if (Objects.nonNull(this.branchSpecification)) {
            throw new IllegalStateException("PublishingArtifactLoader::configure, already configured.");
        }
        Objects.requireNonNull(branchSpecification, "PublishingArtifactLoader::configure, the parameter \"branchSpecification\" cannot be null.");
        if (branchSpecification.getBranchId().isInvalid()) {
            throw new IllegalArgumentException("PublishingArtifactLoader::configure, the parameter \"branchSpecification\" is not valid.");
        }
        if (estimatedArtifactCount < 1) {
            throw new IllegalArgumentException("PublishingArtifactLoader::configure, the parameter \"initialCapacity\" must be greater than zero.");
        }
        int initialCapacity = estimatedArtifactCount * 8;
        this.applicabilityMap = new EnumMapHashMap(BranchIndicator.class, initialCapacity, 0.75f);
        this.branchSpecification = branchSpecification;
        this.branchSpecificationWithoutView = this.branchSpecification.hasView() ? new BranchSpecification(BranchId.valueOf(branchSpecification.getBranchId().getId())) : this.branchSpecification;
        this.branchSpecificationProductLineWithoutView = (BranchSpecification)this.getProductLineBranch().orElseThrow(dataAccessException -> new DataAccessException((CharSequence)new Message().title((CharSequence)"PublishingArtifactLoader::configure, failed to determine the product line branch.").indentInc().segment((CharSequence)"Branch Specification", (Object)branchSpecification).reasonFollows((Throwable)dataAccessException).toString(), dataAccessException.getPublishingUtilCause()));
        this.branchSpecificationProductLine = new BranchSpecification(this.branchSpecificationProductLineWithoutView.getBranchId(), this.branchSpecification.getViewId());
        this.branchSpecificationMap = new DoubleEnumMap(BranchIndicator.class, FilterForView.class);
        this.branchSpecificationMap.put((Enum)BranchIndicator.PRODUCT_LINE_BRANCH, (Enum)FilterForView.YES, (Object)this.branchSpecificationProductLine);
        this.branchSpecificationMap.put((Enum)BranchIndicator.PRODUCT_LINE_BRANCH, (Enum)FilterForView.NO, (Object)this.branchSpecificationProductLineWithoutView);
        this.branchSpecificationMap.put((Enum)BranchIndicator.PUBLISHING_BRANCH, (Enum)FilterForView.YES, (Object)this.branchSpecification);
        this.branchSpecificationMap.put((Enum)BranchIndicator.PUBLISHING_BRANCH, (Enum)FilterForView.NO, (Object)this.branchSpecificationWithoutView);
        this.changedArtifactsMap = new ListMap();
        Predicate[] predicates = new Predicate[]{key -> key instanceof BranchIndicator, key -> key instanceof ArtifactId, key -> key instanceof FilterForView};
        this.childrenCacheMap = new RankHashMap("Children Cache Map", 3, initialCapacity, 0.75f, predicates);
        this.publishingArtifactByArtifactIdentifierMap = new EnumMapHashMap(BranchIndicator.class, initialCapacity, 0.75f);
        this.publishingArtifactByGuidMap = new EnumMapHashMap(BranchIndicator.class, initialCapacity, 0.75f);
        return this;
    }

    private Result<List<ArtifactId>, DataAccessException> dataAccessLoadChildrenArtifactIdentifiers(ArtifactId rootArtifactIdentifier, ArtifactTypeToken childArtifactTypeToken, AttributeTypeId childAttributeTypeId, String attributeValue, FilterForView filterForView, ProcessRecursively processRecursively) {
        this.maxLoadRequest = this.maxLoadRequest <= 0 ? 1 : this.maxLoadRequest;
        BranchSpecification branchSpecification = this.getBranchSpecification(BranchIndicator.PUBLISHING_BRANCH, filterForView);
        Result<List<ArtifactId>, DataAccessException> result = this.dataAccessOperations.getChildrenArtifactIdentifiers(branchSpecification, rootArtifactIdentifier, childArtifactTypeToken, childAttributeTypeId, attributeValue, processRecursively);
        if (result.isPresentValue()) {
            int loaded = ((List)result.getValue()).size();
            this.maxLoaded = this.maxLoaded < loaded ? loaded : this.maxLoaded;
        }
        return result;
    }

    private Result<BranchId, DataAccessException> dataAccessLoadProductLineBranch() {
        Result result = this.dataAccessOperations.getBranchByIdentifier(this.branchSpecificationWithoutView.getBranchId()).mapValue(branch -> branch.getBranchType().equals((Object)BranchType.MERGE) ? branch.getParentBranch() : branch, (branch, throwable) -> new DataAccessException((CharSequence)new Message().title((CharSequence)"PublishingArtifactLoader::dataAccessLoadProductLineBranch failed to determine the product line branch.").indentInc().segment((CharSequence)"Publishing Branch", (Object)this.branchSpecification).reasonFollows(throwable).toString(), ((DataAccessException)throwable).getPublishingUtilCause()));
        return result;
    }

    private Result<Triplet<BranchId, ArtifactToken, Map<String, List<String>>>, DataAccessException> dataAccessLoadProductLineViewApplicabilitiesMap() {
        Result result = this.getProductLineBranch().mapValue(productLineBranchSpecification -> {
            if (!productLineBranchSpecification.hasView()) {
                return new Triplet((Object)productLineBranchSpecification.getBranchId(), (Object)ArtifactToken.SENTINEL, null);
            }
            ArtifactToken view = (ArtifactToken)((List)this.dataAccessOperations.getArtifactTokens((BranchSpecification)productLineBranchSpecification, (Collection<ArtifactId>)List.of(this.branchSpecification.getViewId()), ArtifactTypeToken.SENTINEL, RelationTypeSide.SENTINEL).orElseGet(List.of(ArtifactToken.SENTINEL))).get(0);
            HashMap viewApplicabilitesMap = view.isValid() ? (Map)this.dataAccessOperations.getApplicabilityNamedViewMap((BranchSpecification)productLineBranchSpecification).orElseGet(new HashMap()) : new HashMap();
            return new Triplet((Object)productLineBranchSpecification.getBranchId(), (Object)view, viewApplicabilitesMap);
        }, (productLineBranchSpecification, throwable) -> {
            if (throwable instanceof DataAccessException) {
                return (DataAccessException)throwable;
            }
            return new DataAccessException(new Message().title((CharSequence)"PublishingArtifactLoader::dataAccessLoadProductLineViewApplicabilityMap, failed to load map.").segment((CharSequence)"Product Line Branch", productLineBranchSpecification).indentInc().reasonFollows(throwable).toString(), Cause.ERROR, throwable);
        });
        return result;
    }

    private Result<? extends List<PublishingArtifact>, DataAccessException> dataAccessLoadPublishingArtifacts(BranchIndicator branchIndicator, Collection<ArtifactId> artifactIdentifiers, Collection<String> guids, FilterForView filterForView, ArtifactTypeToken artifactTypeToken, TransactionId transactionId, IncludeDeleted includeDeleted) {
        this.maxLoadRequest = this.maxLoadRequest < artifactIdentifiers.size() ? artifactIdentifiers.size() : this.maxLoadRequest;
        BranchSpecification branchSpecification = this.getBranchSpecification(branchIndicator, filterForView);
        Result result = this.dataAccessOperations.getArtifactReadables(branchSpecification, artifactIdentifiers, guids, "", artifactTypeToken, transactionId, includeDeleted).mapValue(artifactReadables -> artifactReadables.stream().map(artifact -> branchSpecification.hasView() ? this.publishingArtifactFactoryWithView.apply(artifact, branchSpecification) : this.publishingArtifactFactoryWithoutView.apply(artifact)).collect(Collectors.toList()), (artifactReadables, throwable) -> {
            if (throwable instanceof DataAccessException) {
                return (DataAccessException)throwable;
            }
            return new DataAccessException(new Message().title((CharSequence)"PublishingArtifactLoader::dataAccessLoadPublishingArtifacts, failed to load artifacts.").indentInc().segment((CharSequence)"Branch Indicator", (Object)branchIndicator).segmentIndexed((CharSequence)"Artifact Identifiers", artifactIdentifiers, t -> t, 20).segmentIndexed((CharSequence)"Artifact GUIDs", guids, t -> t, 20).segment((CharSequence)"Filter For View", (Object)filterForView).segmentIfNot((CharSequence)"Artifact Type Token", (Object)artifactTypeToken, (Object)ArtifactTypeToken.SENTINEL).segmentIfNot((CharSequence)"Transaction Identifier", (Object)transactionId, (Object)TransactionId.SENTINEL).segment((CharSequence)"Include Deleted", (Object)includeDeleted).reasonFollows(throwable).toString(), Cause.ERROR, throwable);
        });
        if (result.isPresentValue()) {
            int loaded = ((List)result.getValue()).size();
            this.maxLoaded = this.maxLoaded < loaded ? loaded : this.maxLoaded;
        }
        return result;
    }

    public BranchIndicator determineBranchIndicator(BranchId branchId) {
        if (this.branchSpecification.getBranchId().isSameBranch(branchId)) {
            return BranchIndicator.PUBLISHING_BRANCH;
        }
        if (this.branchSpecificationProductLine.getBranchId().isSameBranch(branchId)) {
            return BranchIndicator.PRODUCT_LINE_BRANCH;
        }
        throw new OseeCoreException(new Message().title((CharSequence)"PublishingArtifactLoader::determineBranchIndicator, artifact is from an invalid branch.").indentInc().segment((CharSequence)"BranchId", (Object)branchId).segment((CharSequence)"Publishing Branch", (Object)this.branchSpecification).segment((CharSequence)"Product Line Branch", (Object)this.branchSpecificationProductLine).toString(), new Object[0]);
    }

    private @NonNull BranchIndicator determineBranchIndicator(@NonNull PublishingArtifact artifact) {
        if (this.branchSpecification.getBranchId().isSameBranch(artifact.getBranch())) {
            return BranchIndicator.PUBLISHING_BRANCH;
        }
        if (this.branchSpecificationProductLine.getBranchId().isSameBranch(artifact.getBranch())) {
            return BranchIndicator.PRODUCT_LINE_BRANCH;
        }
        throw new OseeCoreException(new Message().title((CharSequence)"PublishingArtifactLoader::determineBranchIndicator, artifact is from an invalid branch.").indentInc().segment((CharSequence)"Artifact", (Object)artifact).segment((CharSequence)"Publishing Branch", (Object)this.branchSpecification).segment((CharSequence)"Product Line Branch", (Object)this.branchSpecificationProductLine).toString(), new Object[0]);
    }

    public FilterForView determineFilterForView(ArtifactId viewIdentifier) {
        int state = (this.branchSpecification.getViewId().isValid() ? 1 : 0) + (viewIdentifier.isValid() ? 2 : 0) + (this.branchSpecification.getViewId().getId().equals(viewIdentifier.getId()) ? 4 : 0);
        switch (state) {
            case 7: {
                return FilterForView.YES;
            }
            case 1: 
            case 4: {
                return FilterForView.NO;
            }
        }
        throw new OseeCoreException(new Message().title((CharSequence)"PublishingArtifactLoader::determineFilterForView, view identifier is invalid.").indentInc().segment((CharSequence)"View Identifier", (Object)viewIdentifier).segment((CharSequence)"Branch View", (Object)this.branchSpecification.getViewId().getIdString()).toString(), new Object[0]);
    }

    private Optional<DataAccessException> getAndCacheUnloadedArtifacts(BranchIndicator branchIndicator, IdentifierTypeIndicator identifierTypeIndicator, List<?> unloadedArtifactIdList, FilterForView filterForView, TransactionId transactionId, IncludeDeleted includeDeleted) {
        HashSet loadTracker = new HashSet(unloadedArtifactIdList);
        Result result = (identifierTypeIndicator.isArtifactId() ? this.dataAccessLoadPublishingArtifacts(branchIndicator, unloadedArtifactIdList, List.of(), filterForView, ArtifactTypeToken.SENTINEL, transactionId, includeDeleted) : this.dataAccessLoadPublishingArtifacts(branchIndicator, List.of(), unloadedArtifactIdList, filterForView, ArtifactTypeToken.SENTINEL, transactionId, includeDeleted)).peekValue(artifacts -> {
            artifacts.forEach(artifact -> {
                this.cacheIt(branchIndicator, ArtifactId.valueOf(artifact.getId()), (PublishingArtifact)artifact);
                loadTracker.remove(identifierTypeIndicator.isArtifactId() ? artifact.getArtifactId() : artifact.getGuid());
            });
            BranchSpecification branchSpecification = this.getBranchSpecification(branchIndicator, filterForView);
            loadTracker.forEach(artifactIdentifier -> this.cacheIt(branchIndicator, identifierTypeIndicator.isArtifactId() ? (ArtifactId)artifactIdentifier : ArtifactId.SENTINEL, identifierTypeIndicator.isArtifactId() ? new PublishingArtifact.PublishingArtifactNotFound(branchSpecification, (ArtifactId)artifactIdentifier) : new PublishingArtifact.PublishingArtifactNotFound(branchSpecification, (String)artifactIdentifier)));
        });
        return result.isPresentError() ? Optional.of((DataAccessException)result.getError()) : Optional.empty();
    }

    public Optional<ArtifactId> getArtifactIdFromAmbiguousIdentifier(Object ambiguousIdentifier) {
        Optional result = this.getPublishingArtifactByAmbiguousIdentifier(BranchIndicator.PUBLISHING_BRANCH, ambiguousIdentifier, FilterForView.NO, WhenNotFound.EMPTY, TransactionId.SENTINEL, IncludeDeleted.NO).mapValue(ArtifactReadable::getArtifactId).getAsOptionalOrElseThrow(dataAccessException -> new OseeCoreException(new Message().title((CharSequence)"PublishingArtifactLoader::getArtifactIdFromAmbiguousIdentifier, unable to determine ArtifactId of artifact.").indentInc().segment((CharSequence)"Ambiguous Identifier", (Object)ambiguousIdentifier.toString()).reasonFollows((Throwable)dataAccessException).toString(), (Throwable)dataAccessException));
        return result;
    }

    public BranchSpecification getBranchSpecification(BranchIndicator branchIndicator, FilterForView filterForView) {
        return (BranchSpecification)this.branchSpecificationMap.get((Enum)branchIndicator, (Enum)filterForView).orElseThrow();
    }

    private Triplet<CacheResult, Result<PublishingArtifact, DataAccessException>, IdentifierTypeIndicator> getCachedArtifact(BranchIndicator branchIndicator, IdentifierTypeIndicator identifierTypeIndicator, Object artifactIdentifier, FilterForView filterForView, WhenNotFound whenNotFound) {
        PublishingArtifact cachedArtifact;
        IdentifierTypeIndicator resolvedIdentifierTypeIndicator;
        IdentifierTypeIndicator identifierTypeIndicator2 = resolvedIdentifierTypeIndicator = identifierTypeIndicator.isAmbiguous() ? IdentifierTypeIndicator.determine(artifactIdentifier) : identifierTypeIndicator;
        if (resolvedIdentifierTypeIndicator.isUnknown()) {
            return new Triplet((Object)CacheResult.ERROR, (Object)Result.ofError((Object)new DataAccessException((CharSequence)new Message().title((CharSequence)"PublishingArtifactLoader::getCachedArtifact, cannot determine artifact identifier type.").indentInc().segment((CharSequence)"BranchIndicator", (Object)branchIndicator).segment((CharSequence)"Identifier Type Indicator", (Object)identifierTypeIndicator).segment((CharSequence)"Artifact Identifier", (Object)artifactIdentifier.toString()).segment((CharSequence)"Filter For View", (Object)filterForView).segment((CharSequence)"When Not Found", (Object)whenNotFound).toString(), Cause.ARTIFACT_IDENTIFIER_TYPE_ERROR)), (Object)resolvedIdentifierTypeIndicator);
        }
        try {
            switch (resolvedIdentifierTypeIndicator) {
                case ARTIFACT_ID: {
                    cachedArtifact = this.publishingArtifactByArtifactIdentifierMap.get((Object)branchIndicator, (Object)((ArtifactId)artifactIdentifier)).orElse(null);
                    break;
                }
                case ARTIFACT_ID_STRING: {
                    cachedArtifact = this.publishingArtifactByArtifactIdentifierMap.get((Object)branchIndicator, (Object)ArtifactId.valueOf((String)artifactIdentifier)).orElse(null);
                    break;
                }
                case GUID: {
                    cachedArtifact = this.publishingArtifactByGuidMap.get((Object)branchIndicator, (Object)((String)artifactIdentifier)).orElse(null);
                    break;
                }
                default: {
                    return new Triplet((Object)CacheResult.ERROR, (Object)Result.ofError((Object)new DataAccessException((CharSequence)new Message().title((CharSequence)"PublishingArtifactLoader::getCachedArtifact, unexpected resolved artifact identifier.").indentInc().segment((CharSequence)"Branch Indicator", (Object)branchIndicator).segment((CharSequence)"Identifier Type Indicator", (Object)identifierTypeIndicator).segment((CharSequence)"Resolved Identifier Type Indicator", (Object)resolvedIdentifierTypeIndicator).segment((CharSequence)"Artifact Identifier", (Object)artifactIdentifier.toString()).segment((CharSequence)"Filter For View", (Object)filterForView).segment((CharSequence)"When Not Found", (Object)whenNotFound).toString(), Cause.ARTIFACT_IDENTIFIER_TYPE_ERROR)), (Object)resolvedIdentifierTypeIndicator);
                }
            }
        }
        catch (ClassCastException e) {
            return new Triplet((Object)CacheResult.ERROR, (Object)Result.ofError((Object)new DataAccessException(new Message().title((CharSequence)"PublishingArtifactLoader::getCachedArtifact, artifact identifier type does not match indicator.").indentInc().segment((CharSequence)"Branch Indicator", (Object)branchIndicator).segment((CharSequence)"Identifier Type Indicator", (Object)identifierTypeIndicator).segment((CharSequence)"Resolved Identifier Type Indicator", (Object)resolvedIdentifierTypeIndicator).segment((CharSequence)"Artifact Identifier", (Object)artifactIdentifier.toString()).segment((CharSequence)"Filter For View", (Object)filterForView).segment((CharSequence)"When Not Found", (Object)whenNotFound).toString(), Cause.ARTIFACT_IDENTIFIER_TYPE_ERROR, e)), (Object)resolvedIdentifierTypeIndicator);
        }
        boolean branchHasView = this.getBranchSpecification(branchIndicator, filterForView).hasView();
        int state = (Objects.nonNull(cachedArtifact) && cachedArtifact.branchHasView() ? 1 : 0) + (Objects.nonNull(cachedArtifact) && !cachedArtifact.branchHasView() ? 2 : 0) + (Objects.nonNull(cachedArtifact) && cachedArtifact.isFound() ? 4 : 0) + (Objects.nonNull(cachedArtifact) && !cachedArtifact.isFound() ? 8 : 0) + (filterForView.no() || !branchHasView ? 16 : 0) + (filterForView.yes() && branchHasView ? 32 : 0) + (whenNotFound.error() ? 64 : 0) + (whenNotFound.empty() ? 128 : 0) + (whenNotFound.notFound() ? 256 : 0) + (whenNotFound.sentinel() ? 512 : 0);
        return this.getCachedArtifactProcessState(state, branchIndicator, resolvedIdentifierTypeIndicator, cachedArtifact, filterForView);
    }

    private Triplet<CacheResult, Result<PublishingArtifact, DataAccessException>, IdentifierTypeIndicator> getCachedArtifactProcessState(int state, BranchIndicator branchIndicator, IdentifierTypeIndicator identifierTypeIndicator, PublishingArtifact cachedArtifact, FilterForView filterForView) {
        switch (state) {
            case 80: 
            case 89: 
            case 96: 
            case 144: 
            case 153: 
            case 160: 
            case 272: 
            case 281: 
            case 288: 
            case 528: 
            case 537: 
            case 544: {
                ++this.cacheMiss;
                return new Triplet((Object)CacheResult.LOAD, (Object)Result.empty(), (Object)identifierTypeIndicator);
            }
            case 85: 
            case 86: 
            case 101: 
            case 149: 
            case 150: 
            case 165: 
            case 277: 
            case 278: 
            case 293: 
            case 533: 
            case 534: 
            case 549: {
                ++this.cacheHit;
                return new Triplet((Object)CacheResult.USE, (Object)Result.ofValue((Object)cachedArtifact), (Object)identifierTypeIndicator);
            }
            case 102: 
            case 166: 
            case 294: 
            case 550: {
                ++this.cacheTest;
                if (this.checkIsArtifactApplicable(branchIndicator, cachedArtifact)) {
                    cachedArtifact.setBranchView(this.getBranchSpecification(branchIndicator, filterForView));
                    cachedArtifact.setApplicable();
                    ++this.cacheHit;
                    return new Triplet((Object)CacheResult.USE, (Object)Result.ofValue((Object)cachedArtifact), (Object)identifierTypeIndicator);
                }
                cachedArtifact.clearApplicable();
                return this.getCachedArtifactProcessState(state += 3, branchIndicator, identifierTypeIndicator, cachedArtifact, filterForView);
            }
            case 90: 
            case 105: 
            case 106: {
                return new Triplet((Object)CacheResult.NO_LOAD, (Object)Result.ofError((Object)new DataAccessException((CharSequence)new Message().title((CharSequence)"Artifact is not found.").indentInc().segment((CharSequence)"Artifact Identifier", (Object)cachedArtifact.getIdString()).segment((CharSequence)"Artifact GUID", (Object)cachedArtifact.getGuid()).toString(), Cause.NOT_FOUND)), (Object)identifierTypeIndicator);
            }
            case 154: 
            case 169: 
            case 170: {
                return new Triplet((Object)CacheResult.NO_LOAD, (Object)Result.empty(), (Object)identifierTypeIndicator);
            }
            case 282: 
            case 297: 
            case 298: {
                return new Triplet((Object)CacheResult.NO_LOAD, (Object)Result.ofValue((Object)cachedArtifact), (Object)identifierTypeIndicator);
            }
            case 538: 
            case 553: 
            case 554: {
                return new Triplet((Object)CacheResult.NO_LOAD, (Object)Result.ofValue((Object)PublishingArtifact.SENTINEL), (Object)identifierTypeIndicator);
            }
        }
        throw new IllegalStateException(new Message().title((CharSequence)"PublishingArtifactLoader::getCachedArtifact, unexpected state.").indentInc().segment((CharSequence)"State", (Object)state).toString());
    }

    public List<PublishingArtifact> getChangedArtifactsList() {
        return Collections.unmodifiableList(this.changedArtifactsMap.listView());
    }

    public Result<List<PublishingArtifact>, DataAccessException> getChildren(@NonNull PublishingArtifact artifact, @NonNull FilterForView filterForView, @NonNull CacheReadMode cacheReadMode) {
        BranchSpecification branchSpecificationWithView;
        FilterForView cacheLoadFilterForView;
        ArtifactId artifactIdentifier;
        PublishingArtifact safeArtifact = (PublishingArtifact)Conditions.requireNonNull((Object)artifact, (String)"artifact");
        FilterForView safeFilterForView = (FilterForView)((Object)Conditions.requireNonNull((Object)((Object)filterForView), (String)"filterForView"));
        Optional<DataAccessException> validateResult = this.validateCached(artifact);
        if (validateResult.isPresent()) {
            return Result.ofError((Object)validateResult.get());
        }
        ++this.getChildrenCount;
        BranchIndicator branchIndicator = this.determineBranchIndicator(safeArtifact);
        Optional childrenOptional = this.childrenCacheMap.get(new Object[]{branchIndicator, artifactIdentifier = ArtifactId.valueOf(safeArtifact.getId()), cacheLoadFilterForView = (branchSpecificationWithView = (BranchSpecification)this.branchSpecificationMap.get((Enum)branchIndicator, (Enum)FilterForView.YES).get()).hasView() ? safeFilterForView : FilterForView.NO});
        if (childrenOptional.isPresent()) {
            ++this.cacheHit;
            ++this.childCacheHit;
            ArrayList children = new ArrayList((Collection)childrenOptional.get());
            return Result.ofValue(children);
        }
        if (cacheReadMode.isCacheOnly()) {
            return Result.ofValue(new ArrayList());
        }
        ++this.cacheMiss;
        ++this.childCacheMiss;
        LinkedList<PublishingArtifact> children = new LinkedList<PublishingArtifact>();
        try {
            List<PublishingArtifact> artifactChildren = artifact.getChildrenAsPublishingArtifacts();
            for (PublishingArtifact child2 : artifactChildren) {
                child2 = this.switchIfCached(child2);
                if (branchSpecificationWithView.hasView()) {
                    child2.setBranchView(branchSpecificationWithView);
                    if (this.checkIsArtifactApplicable(branchIndicator, child2)) {
                        child2.setApplicable();
                    } else {
                        child2.clearApplicable();
                    }
                } else {
                    child2.clearApplicable();
                }
                ArtifactId childIdentifier = ArtifactId.valueOf(child2.getId());
                this.cacheIt(branchIndicator, childIdentifier, child2);
                children.add(child2);
            }
        }
        catch (Throwable t) {
            return Result.ofError((Object)new DataAccessException(new Message().title((CharSequence)"PublishingArtifactLoader::getChildren, failed to get children identifiers of artifact.").indentInc().segment((CharSequence)"Artifact Identifier", (Object)artifact.getIdString()).reasonFollows(t).toString(), Cause.ERROR, t));
        }
        if (children.isEmpty()) {
            this.childrenCacheMap.associate(List.of(), new Object[]{branchIndicator, artifactIdentifier, FilterForView.YES});
            this.childrenCacheMap.associate(List.of(), new Object[]{branchIndicator, artifactIdentifier, FilterForView.NO});
            return Result.ofValue(new ArrayList());
        }
        LinkedList applicableChildren = new LinkedList();
        children.forEach(child -> {
            assert (!child.isApplicable().unknown()) : new Message().title((CharSequence)"PublishingArtifactLoader::getChildren, artifact has unknown applicability when unexpected.").indentInc().segmentToMessage((CharSequence)"Publishing Artifact", (ToMessage)child).toString();
            if (child.isApplicable().yes()) {
                applicableChildren.add(child);
            }
        });
        this.childrenCacheMap.associate(Collections.unmodifiableList(applicableChildren), new Object[]{branchIndicator, artifactIdentifier, FilterForView.YES});
        this.childrenCacheMap.associate(Collections.unmodifiableList(children), new Object[]{branchIndicator, artifactIdentifier, FilterForView.NO});
        safeArtifact.setChildrenLoadedAndCached();
        return cacheLoadFilterForView.yes() ? Result.ofValue(new ArrayList(applicableChildren)) : Result.ofValue(new ArrayList(children));
    }

    public Result<List<PublishingArtifact>, DataAccessException> getChildrenPublishingArtifacts(ArtifactId rootArtifact, ArtifactTypeToken childArtifactTypeToken, AttributeTypeId childAttributeTypeId, String attributeValue, FilterForView filterForView, ProcessRecursively processRecursively) {
        Result result = this.dataAccessLoadChildrenArtifactIdentifiers(rootArtifact, childArtifactTypeToken, childAttributeTypeId, attributeValue, filterForView, processRecursively).flatMapValue(artifactIdentifiers -> this.getPublishingArtifactsByArtifactIdentifiers(BranchIndicator.PUBLISHING_BRANCH, (Collection<? extends ArtifactId>)artifactIdentifiers, filterForView, WhenNotFound.EMPTY, TransactionId.SENTINEL, IncludeDeleted.NO), (artifactIdentifiers, throwable) -> (DataAccessException)throwable);
        return result;
    }

    public Collection<PublishingArtifact> getHyperLinkArtifactIdentifiers() {
        return this.publishingArtifactByArtifactIdentifierMap.values((Object)BranchIndicator.PUBLISHING_BRANCH).orElse(Set.of());
    }

    private PublishingArtifact getLocalHierarchyPosition(PublishingArtifact artifact, PublishingArtifact cursor) {
        PublishingArtifact parent = (PublishingArtifact)this.getParent(cursor, FilterForView.NO, WhenNotFound.ERROR).peekError(dataAccessException -> this.publishingErrorLog.error(cursor, new Message().title((CharSequence)"Failed to obtain parent of artifact during hierarchical sort.").indentInc().segment((CharSequence)"Artifact Identifier", (Object)cursor).reasonFollows((Throwable)dataAccessException).toString())).orElseGet((Object)PublishingArtifact.SENTINEL);
        if (!parent.isFound()) {
            artifact.pushHierarchyPosition(-1);
            artifact.setHierarchyPosition();
            return parent;
        }
        List siblings = (List)this.getChildren(parent, FilterForView.NO, CacheReadMode.LOAD_FROM_DATABASE).peekError(dataAccessException -> this.publishingErrorLog.error(cursor, new Message().title((CharSequence)"Failed to sibling artifacts during hierarchical sort.").indentInc().segment((CharSequence)"Artifact Identifier", (Object)cursor).segment((CharSequence)"Parent Artifact Identifier", (Object)parent).reasonFollows((Throwable)dataAccessException).toString())).orElseGet(List.of());
        int siblingPosition = siblings.indexOf(cursor);
        artifact.pushHierarchyPosition(siblingPosition);
        if (parent.isHierarchyPositionSet()) {
            artifact.setHierarchyPosition(parent.getHierarchyPosition());
        }
        return parent;
    }

    public Result<PublishingArtifact, DataAccessException> getParent(PublishingArtifact artifact, FilterForView filterForView, WhenNotFound whenNotFound) {
        List<ArtifactId> parentIdentifierList;
        ++this.getParentCount;
        BranchIndicator branchIndicator = this.determineBranchIndicator(artifact);
        try {
            parentIdentifierList = artifact.getRelatedIds(CoreRelationTypes.DefaultHierarchical_Parent);
        }
        catch (Exception e) {
            return Result.ofError((Object)new DataAccessException(new Message().title((CharSequence)"PublishingArtifactLoader::getParent, PublishingArtifact::getRelatedIds failed.").indentInc().segmentToMessage((CharSequence)"Artifact", (ToMessage)artifact).reasonFollows((Throwable)e).toString(), Cause.ERROR, e));
        }
        if (parentIdentifierList.size() > 1) {
            return Result.ofError((Object)new DataAccessException((CharSequence)new Message().title((CharSequence)"PublishingArtifactLoader::getParent, PublishingArtifact::getRelatedIds returned more than one parent identifier.").indentInc().segment((CharSequence)"Artifact", (Object)artifact.getIdString()).segmentIndexed((CharSequence)"Parent Identifiers", parentIdentifierList).toString(), Cause.ERROR));
        }
        if (parentIdentifierList.isEmpty()) {
            switch (whenNotFound) {
                case ERROR: {
                    return Result.ofError((Object)new DataAccessException((CharSequence)new Message().title((CharSequence)"PublishingArtifactLoader::getParent, artifact is not hierarchically connected.").indentInc().segment((CharSequence)"Artifact", (Object)artifact).toString(), Cause.NOT_FOUND));
                }
                case EMPTY: {
                    return Result.empty();
                }
                case SENTINEL: {
                    return Result.ofValue((Object)PublishingArtifact.SENTINEL);
                }
                case NOT_FOUND: {
                    return Result.ofValue((Object)new PublishingArtifact.PublishingArtifactNotFound(this.getBranchSpecification(branchIndicator, filterForView)));
                }
            }
            throw new IllegalStateException();
        }
        ArtifactId parentIdentifier = ArtifactId.valueOf(parentIdentifierList.get(0).getId());
        Result<PublishingArtifact, DataAccessException> result = this.getPublishingArtifactInternal(branchIndicator, IdentifierTypeIndicator.ARTIFACT_ID, parentIdentifier, filterForView, whenNotFound, TransactionId.SENTINEL, IncludeDeleted.NO);
        return result;
    }

    public Result<BranchSpecification, DataAccessException> getProductLineBranch() {
        Result result = Objects.nonNull(this.branchSpecificationProductLineWithoutView) ? Result.ofValue((Object)this.branchSpecificationProductLineWithoutView) : this.dataAccessLoadProductLineBranch().mapValue(BranchSpecification::new);
        return result;
    }

    public Result<Triplet<BranchId, ArtifactToken, Map<String, List<String>>>, DataAccessException> getProductLineViewApplicabilitesMap() {
        return this.dataAccessLoadProductLineViewApplicabilitiesMap();
    }

    public Result<PublishingArtifact, DataAccessException> getPublishingArtifactByAmbiguousIdentifier(BranchIndicator branchIndicator, Object ambiguousIdentifier, FilterForView filterForView, WhenNotFound whenNotFound, TransactionId transactionIdentifier, IncludeDeleted includeDeleted) {
        Result<PublishingArtifact, DataAccessException> result = this.getPublishingArtifactInternal(branchIndicator, IdentifierTypeIndicator.AMBIGUOUS, ambiguousIdentifier, filterForView, whenNotFound, transactionIdentifier, includeDeleted);
        return result;
    }

    public Result<PublishingArtifact, DataAccessException> getPublishingArtifactByArtifactIdentifier(BranchIndicator branchIndicator, ArtifactId artifactIdentifier, FilterForView filter, WhenNotFound whenNotFound, TransactionId transactionIdentifier, IncludeDeleted includeDeleted) {
        Result<PublishingArtifact, DataAccessException> result = this.getPublishingArtifactInternal(branchIndicator, IdentifierTypeIndicator.ARTIFACT_ID, artifactIdentifier, filter, whenNotFound, transactionIdentifier, includeDeleted);
        return result;
    }

    public Result<PublishingArtifact, DataAccessException> getPublishingArtifactByGuid(BranchIndicator branchIndicator, String guid, FilterForView filter, WhenNotFound whenNotFound, TransactionId transactionIdentifier, IncludeDeleted includeDeleted) {
        Result<PublishingArtifact, DataAccessException> result = this.getPublishingArtifactInternal(branchIndicator, IdentifierTypeIndicator.GUID, guid, filter, whenNotFound, transactionIdentifier, includeDeleted);
        return result;
    }

    private Result<PublishingArtifact, DataAccessException> getPublishingArtifactInternal(BranchIndicator branchIndicator, IdentifierTypeIndicator identifierTypeIndicator, Object ambiguousIdentifier, FilterForView filterForView, WhenNotFound whenNotFound, TransactionId transactionId, IncludeDeleted includeDeleted) {
        Triplet<CacheResult, Result<PublishingArtifact, DataAccessException>, IdentifierTypeIndicator> triplet = this.getCachedArtifact(branchIndicator, identifierTypeIndicator, ambiguousIdentifier, filterForView, whenNotFound);
        CacheResult cacheResult = (CacheResult)((Object)triplet.getFirst());
        Result resultFromCache = (Result)triplet.getSecond();
        IdentifierTypeIndicator resolvedIdentifierTypeIndicator = (IdentifierTypeIndicator)((Object)triplet.getThird());
        switch (cacheResult) {
            case ERROR: 
            case NO_LOAD: 
            case USE: {
                return resultFromCache;
            }
            case LOAD: {
                Supplier<Result> artifactLoader = resolvedIdentifierTypeIndicator.isArtifactId() ? () -> this.dataAccessLoadPublishingArtifacts(branchIndicator, List.of((ArtifactId)ambiguousIdentifier), List.of(), filterForView, ArtifactTypeToken.SENTINEL, transactionId, includeDeleted) : () -> this.dataAccessLoadPublishingArtifacts(branchIndicator, List.of(), List.of((String)ambiguousIdentifier), filterForView, ArtifactTypeToken.SENTINEL, transactionId, includeDeleted);
                Result result = artifactLoader.get().ifEmptyThrow(() -> new OseeCoreException("PublishingArtifactLoader::getPublishingArtifactInternal, the artifact loader result was empty.", new Object[0])).mapValue(loadedArtifacts -> (PublishingArtifact)loadedArtifacts.get(0), (loadedArtifact, throwable) -> new DataAccessException((CharSequence)new Message().title((CharSequence)"PublishingArtifactLoader::getPublishingArtifactInternal, artifact not found.").indentInc().segment((CharSequence)"Ambiguous Artifact Identifier", ambiguousIdentifier).toString(), Cause.NOT_FOUND)).peekValue(loadedArtifact -> this.cacheIt(branchIndicator, ArtifactId.create(loadedArtifact), (PublishingArtifact)loadedArtifact)).flatMapError(dataAccessException -> {
                    if (dataAccessException.isNotFound()) {
                        PublishingArtifact.PublishingArtifactNotFound notFoundArtifact = resolvedIdentifierTypeIndicator.isArtifactId() ? new PublishingArtifact.PublishingArtifactNotFound(this.getBranchSpecification(branchIndicator, filterForView), (ArtifactId)ambiguousIdentifier) : new PublishingArtifact.PublishingArtifactNotFound(this.getBranchSpecification(branchIndicator, filterForView), (String)ambiguousIdentifier);
                        this.cacheIt(branchIndicator, notFoundArtifact.getArtifactId(), notFoundArtifact);
                        switch (whenNotFound) {
                            case ERROR: {
                                return Result.ofError((Object)dataAccessException);
                            }
                            case EMPTY: {
                                return Result.empty();
                            }
                            case SENTINEL: {
                                return Result.ofValue((Object)PublishingArtifact.SENTINEL);
                            }
                            case NOT_FOUND: {
                                return Result.ofValue((Object)notFoundArtifact);
                            }
                        }
                    }
                    return Result.ofError((Object)dataAccessException);
                });
                return result;
            }
        }
        throw new IllegalStateException();
    }

    public Result<List<PublishingArtifact>, DataAccessException> getPublishingArtifacts(BranchIndicator branchIndicator, FilterForView filterForView, WhenNotFound whenNotFound, AttributeTypeId attributeTypeId, String attributeValue, TransactionId transactionId, IncludeDeleted includeDeleted) {
        Result result = this.dataAccessOperations.getArtifactIdentifiers((BranchSpecification)this.branchSpecificationMap.get((Enum)branchIndicator, (Enum)filterForView).get(), attributeTypeId, attributeValue, transactionId, includeDeleted).flatMapValue(artifactIdentifiers -> this.getPublishingArtifactsInternal(branchIndicator, IdentifierTypeIndicator.ARTIFACT_ID, (Collection<?>)artifactIdentifiers, filterForView, whenNotFound, transactionId, includeDeleted), (artifactIdentifier, dataAccessException) -> (DataAccessException)dataAccessException);
        return result;
    }

    public Result<List<PublishingArtifact>, DataAccessException> getPublishingArtifactsByAmbiguousIdentifiers(BranchIndicator branchIndicator, Collection<?> ambiguousIdentifiers, FilterForView filterForView, WhenNotFound whenNotFound, TransactionId transactionId, IncludeDeleted includeDeleted) {
        Result<List<PublishingArtifact>, DataAccessException> result = this.getPublishingArtifactsInternal(branchIndicator, IdentifierTypeIndicator.AMBIGUOUS, ambiguousIdentifiers, filterForView, whenNotFound, transactionId, includeDeleted);
        return result;
    }

    public Result<List<PublishingArtifact>, DataAccessException> getPublishingArtifactsByArtifactIdentifiers(BranchIndicator branchIndicator, Collection<? extends ArtifactId> artifactIdentifiers, FilterForView filterForView, WhenNotFound whenNotFound, TransactionId transactionId, IncludeDeleted includeDeleted) {
        Result<List<PublishingArtifact>, DataAccessException> result = this.getPublishingArtifactsInternal(branchIndicator, IdentifierTypeIndicator.ARTIFACT_ID, artifactIdentifiers, filterForView, whenNotFound, transactionId, includeDeleted);
        return result;
    }

    public Result<List<PublishingArtifact>, DataAccessException> getPublishingArtifactsByGuids(BranchIndicator branchIndicator, Collection<String> guids, FilterForView filterForView, WhenNotFound whenNotFound, TransactionId transactionId, IncludeDeleted includeDeleted) {
        Result<List<PublishingArtifact>, DataAccessException> result = this.getPublishingArtifactsInternal(branchIndicator, IdentifierTypeIndicator.GUID, guids, filterForView, whenNotFound, transactionId, includeDeleted);
        return result;
    }

    private Result<List<PublishingArtifact>, DataAccessException> getPublishingArtifactsInternal(BranchIndicator branchIndicator, IdentifierTypeIndicator identifierTypeIndicator, Collection<?> ambiguousIdentifiers, FilterForView filterForView, WhenNotFound whenNotFound, TransactionId transactionId, IncludeDeleted includeDeleted) {
        Optional<DataAccessException> dataAccessExceptionOptional;
        if (Objects.isNull(ambiguousIdentifiers)) {
            return Result.ofError((Object)new DataAccessException((CharSequence)"PublishingArtifactLoader::getPublishingArtifactsByArtifactIdentifiers, parameter \"ambiguousIdentifiers\" cannot be null.", Cause.ERROR));
        }
        assert (!ambiguousIdentifiers.stream().anyMatch(ambiguousIdentifier -> IdentifierTypeIndicator.determine(ambiguousIdentifier).isUnknown())) : new Message().title((CharSequence)"PublishingArtifactLoader::getPublishingArtifactsByArtifactIdentifiers, parameter \"artifactIdentifiers\" cannot contain null or sentinel artifact identifiers.").indentInc().segmentIndexed((CharSequence)"Artifact Identifiers", (Collection)ambiguousIdentifiers.stream().collect(Collectors.toList())).toString();
        if (ambiguousIdentifiers.isEmpty()) {
            return Result.empty();
        }
        int loadSize = ambiguousIdentifiers.size();
        int callLoadByIdCacheHitCount = 0;
        ArrayList<PublishingArtifact> loadedArtifacts = new ArrayList<PublishingArtifact>(loadSize);
        ArrayList<ArtifactId> unloadedArtifactIdList = new ArrayList<ArtifactId>(loadSize);
        ArrayList<String> unloadedGuidList = new ArrayList<String>(loadSize);
        for (Object ambiguousIdentifier2 : ambiguousIdentifiers) {
            Triplet<CacheResult, Result<PublishingArtifact, DataAccessException>, IdentifierTypeIndicator> triplet = this.getCachedArtifact(branchIndicator, identifierTypeIndicator, ambiguousIdentifier2, filterForView, WhenNotFound.NOT_FOUND);
            CacheResult cacheResult = (CacheResult)((Object)triplet.getFirst());
            Result resultFromCache = (Result)triplet.getSecond();
            IdentifierTypeIndicator resolvedIdentifierTypeIndicator = (IdentifierTypeIndicator)((Object)triplet.getThird());
            if (resultFromCache.isPresentError()) {
                return Result.ofError((Result)resultFromCache);
            }
            resultFromCache.ifValueActionElseAction(loadedArtifacts::add, () -> {
                switch (resolvedIdentifierTypeIndicator) {
                    case ARTIFACT_ID: {
                        loadedArtifacts.add(new PublishingArtifact.PublishingArtifactNotFound(this.branchSpecification, (ArtifactId)ambiguousIdentifier2));
                        break;
                    }
                    case ARTIFACT_ID_STRING: {
                        loadedArtifacts.add(new PublishingArtifact.PublishingArtifactNotFound(this.branchSpecification, ArtifactId.valueOf((String)ambiguousIdentifier2)));
                        break;
                    }
                    case GUID: {
                        loadedArtifacts.add(new PublishingArtifact.PublishingArtifactNotFound(this.branchSpecification, (String)ambiguousIdentifier2));
                    }
                }
            });
            block0 : switch (cacheResult) {
                case USE: {
                    ++callLoadByIdCacheHitCount;
                    ++this.loadByIdCacheHitCount;
                    break;
                }
                case LOAD: {
                    switch (resolvedIdentifierTypeIndicator) {
                        case ARTIFACT_ID: {
                            unloadedArtifactIdList.add((ArtifactId)ambiguousIdentifier2);
                            break block0;
                        }
                        case ARTIFACT_ID_STRING: {
                            unloadedArtifactIdList.add(ArtifactId.valueOf((String)ambiguousIdentifier2));
                            break block0;
                        }
                        case GUID: {
                            unloadedGuidList.add((String)ambiguousIdentifier2);
                        }
                    }
                }
            }
        }
        int n = this.maxLoadByIdCacheHitCount = callLoadByIdCacheHitCount > this.maxLoadByIdCacheHitCount ? callLoadByIdCacheHitCount : this.maxLoadByIdCacheHitCount;
        if (unloadedArtifactIdList.size() > 0 && (dataAccessExceptionOptional = this.getAndCacheUnloadedArtifacts(branchIndicator, IdentifierTypeIndicator.ARTIFACT_ID, unloadedArtifactIdList, filterForView, transactionId, includeDeleted)).isPresent()) {
            return Result.ofError((Object)dataAccessExceptionOptional.get());
        }
        if (unloadedGuidList.size() > 0 && (dataAccessExceptionOptional = this.getAndCacheUnloadedArtifacts(branchIndicator, IdentifierTypeIndicator.GUID, unloadedGuidList, filterForView, transactionId, includeDeleted)).isPresent()) {
            return Result.ofError((Object)dataAccessExceptionOptional.get());
        }
        Optional<List<PublishingArtifact>> unloadedArtifacts = this.mergeJustLoadedArtifacts(branchIndicator, loadedArtifacts, filterForView, WhenNotFound.EMPTY);
        if (whenNotFound.empty() && unloadedArtifacts.isPresent()) {
            loadedArtifacts.removeIf(Predicate.not(PublishingArtifact::isFound));
        }
        return Result.ofValue(loadedArtifacts);
    }

    public Result<List<PublishingArtifact>, DataAccessException> getRelated(PublishingArtifact publishingArtifact, RelationTypeSide relationTypeSide, FilterForView filterForView) {
        List<ArtifactId> relatedArtifactIdentifiers = publishingArtifact.getRelatedIds(relationTypeSide);
        if (relatedArtifactIdentifiers.isEmpty()) {
            return Result.ofValue(new ArrayList());
        }
        Result<List<PublishingArtifact>, DataAccessException> result = this.getPublishingArtifactsByArtifactIdentifiers(BranchIndicator.PUBLISHING_BRANCH, relatedArtifactIdentifiers, filterForView, WhenNotFound.EMPTY, TransactionId.SENTINEL, IncludeDeleted.NO);
        return result;
    }

    public Result<List<PublishingArtifact>, DataAccessException> getSiblings(PublishingArtifact publishingArtifact, FilterForView filterForView) {
        BranchSpecification branchSpecification = this.getBranchSpecification(BranchIndicator.PUBLISHING_BRANCH, filterForView);
        return (Result)this.dataAccessOperations.getParentArtifactIdentifiers(branchSpecification, publishingArtifact, ProcessRecursively.NO).flatMapValue(parentArtifactIdentifiers -> this.dataAccessOperations.getChildrenArtifactIdentifiers(branchSpecification, (ArtifactId)parentArtifactIdentifiers.get(0), ArtifactTypeToken.SENTINEL, AttributeTypeId.SENTINEL, "", ProcessRecursively.NO), (artifactId, dataAccessException) -> (DataAccessException)dataAccessException).mapValue(artifactIdentifiers -> this.getPublishingArtifactsByArtifactIdentifiers(BranchIndicator.PUBLISHING_BRANCH, (Collection<? extends ArtifactId>)artifactIdentifiers, filterForView, WhenNotFound.EMPTY, TransactionId.SENTINEL, IncludeDeleted.NO)).orElseThrow();
    }

    public Result<Set<String>, DataAccessException> getViewApplicabilityConfigurationGroups() {
        Result result = this.getProductLineBranch().flatMapValue(productLineBranchSpecification -> this.dataAccessOperations.getArtifactTokens((BranchSpecification)productLineBranchSpecification, (Collection<ArtifactId>)List.of(), CoreArtifactTypes.GroupArtifact, CoreRelationTypes.PlConfigurationGroup_Group), (productLineBranchSpecification, throwable) -> (DataAccessException)throwable).mapValue(artifactTokenList -> {
            HashSet set = new HashSet(artifactTokenList.size() * 8);
            artifactTokenList.forEach(artifactToken -> {
                boolean bl = set.add(artifactToken.getName().toUpperCase());
            });
            return set;
        });
        return result;
    }

    public Result<Set<String>, DataAccessException> getViewApplicabilityConfigurations() {
        Result result = this.getProductLineBranch().flatMapValue(productLineBranchSpecification -> this.dataAccessOperations.getArtifactTokens((BranchSpecification)productLineBranchSpecification, (Collection<ArtifactId>)List.of(), CoreArtifactTypes.BranchView, RelationTypeSide.SENTINEL), (productLineBranchSpecification, throwable) -> (DataAccessException)throwable).mapValue(artifactTokenList -> {
            HashSet set = new HashSet(artifactTokenList.size() * 8);
            artifactTokenList.forEach(artifactToken -> {
                boolean bl = set.add(artifactToken.getName().toUpperCase());
            });
            return set;
        });
        return result;
    }

    public boolean isChangedArtifact(ArtifactId artifactId) {
        return this.changedArtifactsMap.mapView().containsKey(artifactId);
    }

    public boolean isHeading(ArtifactId artifactIdentifier) {
        return (Boolean)this.getPublishingArtifactByArtifactIdentifier(BranchIndicator.PUBLISHING_BRANCH, artifactIdentifier, FilterForView.NO, WhenNotFound.EMPTY, TransactionId.SENTINEL, IncludeDeleted.NO).mapValue(artifact -> artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})).orElseGet((Object)false);
    }

    public boolean isProductLineBranchPublishingBranch() {
        return this.branchSpecification.getBranchId().isSameBranch(this.branchSpecificationProductLine.getBranchId());
    }

    public boolean isRecursivelyRelated(HashSet<PublishingArtifact> goodParents, PublishingArtifact artifact, FilterForView filterForView) {
        if (goodParents.contains(artifact)) {
            return true;
        }
        LinkedList<PublishingArtifact> maybeParents = new LinkedList<PublishingArtifact>();
        maybeParents.add(artifact);
        PublishingArtifact ancestor = (PublishingArtifact)this.getParent(artifact, filterForView, WhenNotFound.ERROR).orElseThrow();
        while (Objects.nonNull(ancestor)) {
            maybeParents.add(ancestor);
            if (goodParents.contains(ancestor)) {
                goodParents.addAll(maybeParents);
                return true;
            }
            ancestor = (PublishingArtifact)this.getParent(ancestor, filterForView, WhenNotFound.ERROR).orElseThrow();
        }
        return false;
    }

    public Result<List<PublishingArtifact>, DataAccessException> loadAncestors(PublishingArtifact publishingArtifact, FilterForView filterForView) {
        return this.dataAccessOperations.getParentArtifactIdentifiers(this.getBranchSpecification(BranchIndicator.PUBLISHING_BRANCH, filterForView), publishingArtifact, ProcessRecursively.YES).flatMapValue(artifactIdentifiers -> this.getPublishingArtifactsByArtifactIdentifiers(BranchIndicator.PUBLISHING_BRANCH, (Collection<? extends ArtifactId>)artifactIdentifiers, FilterForView.YES, WhenNotFound.EMPTY, TransactionId.SENTINEL, IncludeDeleted.NO), (artifactIdentifiers, throwable) -> (DataAccessException)throwable);
    }

    private void loadAndCacheChildren(PublishingArtifact publishingArtifact) {
        if (!publishingArtifact.areChildrenCached()) {
            this.getChildren(publishingArtifact, FilterForView.NO, CacheReadMode.LOAD_FROM_DATABASE);
        }
    }

    public void loadByAtsTeamWorkflow(Collection<? extends PublishingArtifact> headerArtifacts, ArtifactId artifactIdentifier) {
        if (this.changedArtifactsLoaded) {
            throw new IllegalStateException("PublishingArtifactLoader::loadByAtsTeamWorkflow, changed artifacts already loaded.");
        }
        this.atsTeamWorkflowLoader.load(headerArtifacts, artifactIdentifier, this, this.branchSpecification, this.changedArtifactsMap.mapView());
        this.changedArtifactsLoaded = true;
    }

    public void loadByTransactionComment(BranchSpecification branchSpecification) {
        if (this.changedArtifactsLoaded) {
            throw new IllegalStateException("PublishingArtifactLoader::loadByAtsTeamWorkflow, changed artifacts already loaded.");
        }
        Objects.requireNonNull(branchSpecification, "ChangedArtifactsTracker::loadByTransactionComment, parameter \"branchSpecification\" cannot be null.");
        this.streamChangedArtifactReadables(branchSpecification).collect(Collectors.toMap(ArtifactId::create, Function.identity(), (a, b) -> a, () -> this.changedArtifactsMap.mapView()));
        this.changedArtifactsLoaded = true;
    }

    private Optional<List<PublishingArtifact>> mergeJustLoadedArtifacts(BranchIndicator branchIndicator, ArrayList<PublishingArtifact> artifacts, FilterForView filterForView, WhenNotFound whenNotFound) {
        LinkedList<PublishingArtifact> notFoundArtifacts = null;
        int i = 0;
        while (i < artifacts.size()) {
            PublishingArtifact artifact = artifacts.get(i);
            if (!artifact.isFound()) {
                IdentifierTypeIndicator identifierTypeIndicator;
                Object artifactIdentifier;
                ArtifactId artifactId = artifact.getArtifactId();
                if (artifactId.isValid()) {
                    artifactIdentifier = artifactId;
                    identifierTypeIndicator = IdentifierTypeIndicator.ARTIFACT_ID;
                } else {
                    artifactIdentifier = artifact.getGuid();
                    identifierTypeIndicator = IdentifierTypeIndicator.GUID;
                }
                Triplet<CacheResult, Result<PublishingArtifact, DataAccessException>, IdentifierTypeIndicator> triplet = this.getCachedArtifact(branchIndicator, identifierTypeIndicator, artifactIdentifier, filterForView, WhenNotFound.NOT_FOUND);
                CacheResult cacheResult = (CacheResult)((Object)triplet.getFirst());
                PublishingArtifact artifactFromCache = (PublishingArtifact)((Result)triplet.getSecond()).getValue();
                if (cacheResult.isUse()) {
                    artifacts.set(i, artifactFromCache);
                } else {
                    notFoundArtifacts = Objects.isNull(notFoundArtifacts) ? new LinkedList<PublishingArtifact>() : notFoundArtifacts;
                    notFoundArtifacts.add(artifactFromCache);
                    switch (whenNotFound) {
                        case EMPTY: 
                        case ERROR: {
                            artifacts.remove(i);
                            --i;
                            break;
                        }
                        case SENTINEL: {
                            artifacts.set(i, PublishingArtifact.SENTINEL);
                        }
                    }
                }
            }
            ++i;
        }
        return Optional.ofNullable(notFoundArtifacts);
    }

    private void setHierarchyPosition(PublishingArtifact artifact) {
        PublishingArtifact cursor = artifact;
        while (!artifact.isHierarchyPositionSet() && cursor.isFound() && !cursor.getId().equals(CoreArtifactTokens.DefaultHierarchyRoot.getId())) {
            cursor = this.getLocalHierarchyPosition(artifact, cursor);
        }
        artifact.setHierarchyPosition();
        PublishingArtifact prior = artifact;
        cursor = (PublishingArtifact)this.getParent(artifact, FilterForView.NO, WhenNotFound.EMPTY).orElseGet(null);
        while (Objects.nonNull(cursor) && !cursor.isHierarchyPositionSet() && !cursor.getId().equals(CoreArtifactTokens.DefaultHierarchyRoot.getId())) {
            List<Integer> priorHierarchyPosition = prior.getHierarchyPosition();
            assert (priorHierarchyPosition.size() >= 2) : "bad index";
            cursor.setHierarchyPosition(priorHierarchyPosition.subList(0, priorHierarchyPosition.size() - 1));
            prior = cursor;
            cursor = (PublishingArtifact)this.getParent(cursor, FilterForView.NO, WhenNotFound.EMPTY).orElseGet(null);
        }
    }

    public void sort(@NonNull List<@NonNull PublishingArtifact> artifacts) {
        Conditions.require(artifacts, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"artifacts", (String)"cannot be null or contian null elements", (Predicate)Conditions.or((Predicate[])new Predicate[]{Objects::isNull, Conditions::collectionContainsNull}), NullPointerException::new);
        artifacts.stream().peek(this::loadAndCacheChildren).forEach(this::setHierarchyPosition);
        artifacts.sort(new HierarchyComparator());
    }

    private Stream<PublishingArtifact> streamChangedArtifactReadables(BranchSpecification branchSpecification) {
        return ((List)this.dataAccessOperations.getArtifactIdentifiersFilterByTxCommentForChange(branchSpecification).flatMapValue(artifactIdentifiers -> this.getPublishingArtifactsByArtifactIdentifiers(BranchIndicator.PUBLISHING_BRANCH, (Collection<? extends ArtifactId>)artifactIdentifiers, FilterForView.NO, WhenNotFound.EMPTY, TransactionId.SENTINEL, IncludeDeleted.NO), (artifactIdentifiers, dataAccessException) -> (DataAccessException)dataAccessException).orElseGet(dataAccessException -> Result.ofValue(List.of()), List::of)).stream().filter(PublishingArtifact::isFound).peek(PublishingArtifact::setChanged);
    }

    public Stream<Pair<PublishingArtifact, PublishingArtifact>> streamUnbookmarkedHyperLinkPairs() {
        return ((Collection)this.publishingArtifactByArtifactIdentifierMap.values((Object)BranchIndicator.PUBLISHING_BRANCH).orElseThrow()).stream().filter(PublishingArtifact::isFound).filter(Predicate.not(PublishingArtifact::isBookmarked)).flatMap(hyperlinkToUnbookmarkedArtifact -> hyperlinkToUnbookmarkedArtifact.streamHyperlinkedFrom().map(hyperlinkFromArtifact -> Pair.createNonNull((Object)hyperlinkFromArtifact, (Object)hyperlinkToUnbookmarkedArtifact)));
    }

    private @NonNull PublishingArtifact switchIfCached(@NonNull PublishingArtifact artifact) {
        ArtifactId artifactIdentifier;
        BranchIndicator branchIndicator = this.determineBranchIndicator(artifact);
        Triplet<CacheResult, Result<PublishingArtifact, DataAccessException>, IdentifierTypeIndicator> triplet = this.getCachedArtifact(branchIndicator, IdentifierTypeIndicator.ARTIFACT_ID, artifactIdentifier = ArtifactId.valueOf(artifact.getId()), FilterForView.NO, WhenNotFound.EMPTY);
        Result result = (Result)triplet.getSecondNonNull();
        if (result.isEmpty()) {
            return artifact;
        }
        PublishingArtifact cachedArtifact = (PublishingArtifact)result.getValue();
        return cachedArtifact;
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Publishing Artifact Loader").indentInc().segment((CharSequence)"Cached By ArtifactId", (Object)this.publishingArtifactByArtifactIdentifierMap.size()).segment((CharSequence)"Cached By GUID", (Object)this.publishingArtifactByGuidMap.size()).segment((CharSequence)"Cache Hit Count", (Object)this.cacheHit).segment((CharSequence)"Cache Miss Count", (Object)this.cacheMiss).segment((CharSequence)"Child Cache Hit Count", (Object)this.childCacheHit).segment((CharSequence)"Child Cache Miss COunt", (Object)this.childCacheMiss).segment((CharSequence)"Get Parent Requests", (Object)this.getParentCount).segment((CharSequence)"Get Children Requests", (Object)this.getChildrenCount).segment((CharSequence)"Cache Applicibility Test Count", (Object)this.cacheTest).segment((CharSequence)"Clear Branch View Count", (Object)this.cacheClearBranchView).segment((CharSequence)"Drop Count", (Object)this.dropCount).segment((CharSequence)"Set Applicable Count", (Object)this.cacheSetApplicable).segment((CharSequence)"Load By Id Cache Hit Count", (Object)this.loadByIdCacheHitCount).segment((CharSequence)"Maximum Single Load By Id Cache Hit Count", (Object)this.maxLoadByIdCacheHitCount).segment((CharSequence)"Maximum Load Request", (Object)this.maxLoadRequest).segment((CharSequence)"Maximum Loaded", (Object)this.maxLoaded).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }

    private Optional<DataAccessException> validateCached(@NonNull PublishingArtifact artifact) {
        ArtifactId artifactIdentifier;
        BranchIndicator branchIndicator = this.determineBranchIndicator(artifact);
        Triplet<CacheResult, Result<PublishingArtifact, DataAccessException>, IdentifierTypeIndicator> triplet = this.getCachedArtifact(branchIndicator, IdentifierTypeIndicator.ARTIFACT_ID, artifactIdentifier = ArtifactId.valueOf(artifact.getId()), FilterForView.NO, WhenNotFound.EMPTY);
        Result result = (Result)triplet.getSecondNonNull();
        if (result.isEmpty()) {
            return Optional.of(new DataAccessException((CharSequence)"artifact is not in cache", Cause.NOT_FOUND));
        }
        PublishingArtifact cachedArtifact = (PublishingArtifact)result.getValue();
        if (cachedArtifact != artifact) {
            return Optional.of(new DataAccessException((CharSequence)"artifact is not the cached artifact", Cause.ERROR));
        }
        return Optional.empty();
    }

    @FunctionalInterface
    public static interface AtsTeamWorkflowLoader {
        public void load(Collection<? extends PublishingArtifact> var1, ArtifactId var2, PublishingArtifactLoader var3, BranchSpecification var4, Map<ArtifactId, PublishingArtifact> var5);
    }

    public static enum BranchIndicator {
        PRODUCT_LINE_BRANCH,
        PUBLISHING_BRANCH;


        boolean isProductLineBranch() {
            return this == PRODUCT_LINE_BRANCH;
        }

        boolean isPublishingBranch() {
            return this == PUBLISHING_BRANCH;
        }
    }

    public static enum CacheReadMode {
        CACHE_ONLY,
        LOAD_FROM_DATABASE;


        boolean isCacheOnly() {
            return this == CACHE_ONLY;
        }

        boolean isLoadFromDatabase() {
            return this == LOAD_FROM_DATABASE;
        }
    }

    private static enum CacheResult {
        ERROR,
        LOAD,
        NO_LOAD,
        USE;


        boolean isUse() {
            return this == USE;
        }
    }

    private class HierarchyComparator
    implements Comparator<PublishingArtifact> {
        @Override
        public int compare(PublishingArtifact lhsArtifact, PublishingArtifact rhsArtifact) {
            List<Integer> lhsHierarchyPosition = lhsArtifact.getHierarchyPosition();
            int lhsSize = lhsHierarchyPosition.size();
            List<Integer> rhsHierarchyPosition = rhsArtifact.getHierarchyPosition();
            int rhsSize = rhsHierarchyPosition.size();
            int i = 0;
            while (i < lhsSize) {
                if (i >= rhsSize) {
                    return 1;
                }
                Integer lhsPosition = lhsHierarchyPosition.get(i);
                Integer rhsPosition = rhsHierarchyPosition.get(i);
                if (rhsPosition < lhsPosition) {
                    return 1;
                }
                if (rhsPosition > lhsPosition) {
                    return -1;
                }
                ++i;
            }
            if (rhsSize > lhsSize) {
                return -1;
            }
            return 0;
        }
    }

    @FunctionalInterface
    public static interface PublishingArtifactFactoryWithView {
        public PublishingArtifact apply(Object var1, BranchSpecification var2);
    }

    @FunctionalInterface
    public static interface PublishingArtifactFactoryWithoutView {
        public PublishingArtifact apply(Object var1);
    }

    public static enum WhenNotFound {
        EMPTY,
        ERROR,
        NOT_FOUND,
        SENTINEL;


        boolean empty() {
            return this == EMPTY;
        }

        boolean error() {
            return this == ERROR;
        }

        boolean notFound() {
            return this == NOT_FOUND;
        }

        boolean sentinel() {
            return this == SENTINEL;
        }
    }
}

