/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.event;

import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.event.AbstractTopicEvent;
import org.eclipse.osee.framework.core.event.EventType;
import org.eclipse.osee.framework.core.event.TopicEvent;
import org.eclipse.osee.framework.core.exception.OseeWrappedException;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.osgi.service.event.Event;

public final class EventUtil {
    private EventUtil() {
    }

    public static String getObjectSafeName(Object object) {
        try {
            return object.toString();
        }
        catch (Exception ex) {
            return String.valueOf(object.getClass().getSimpleName()) + " - exception on toString: " + ex.getLocalizedMessage();
        }
    }

    public static void eventLog(String message, Throwable ex) {
        EventUtil.eventLog(ex, message, new Object[0]);
    }

    public static void eventLog(Throwable ex, String message, Object ... args) {
        try {
            if (EventUtil.isEventDebugConsole()) {
                StringBuilder builder = new StringBuilder();
                builder.append(EventUtil.formatMessage(message, args));
                if (ex != null) {
                    builder.append(" <<ERROR>> ");
                    builder.append(ex.toString());
                }
            }
            if (ex != null) {
                OseeLog.log(EventUtil.class, (Level)Level.SEVERE, (String)EventUtil.formatMessage(message, args), (Throwable)ex);
            } else {
                OseeLog.log(EventUtil.class, (Level)Level.FINE, (String)EventUtil.formatMessage(message, args));
            }
        }
        catch (Throwable th) {
            OseeLog.log(EventUtil.class, (Level)Level.SEVERE, (Throwable)th);
        }
    }

    public static void eventLog(String output, Object ... args) {
        EventUtil.eventLog(null, output, args);
    }

    private static String formatMessage(String message, Object ... args) {
        try {
            return String.format(message, args);
        }
        catch (RuntimeException ex) {
            return String.format("Exception message could not be formatted: [%s] with the following arguments [%s].  Cause [%s]", message, Collections.toString((String)",", (Object[])args), ex.toString());
        }
    }

    private static boolean isEventDebugConsole() {
        String debugConsole = System.getProperty("eventDebug", "");
        return "console".equals(debugConsole);
    }

    public static <T> T getTopicJson(Event event, Class<T> class1) {
        return JsonUtil.readValue((String)event.getProperty("json"), class1);
    }

    public static TopicEvent createTopic(AbstractTopicEvent topic, TransactionId transaction, Object event) {
        return EventUtil.createTopic(topic.getTopic(), event, transaction, topic.getEventType());
    }

    public static TopicEvent createTopic(String topic, Object event, TransactionId transaction, EventType eventType) {
        try {
            return new TopicEvent(topic, "json", JsonUtil.toJson(event), transaction, eventType);
        }
        catch (Exception ex) {
            throw new OseeWrappedException(ex, "Error reading topic json [%s]", event.toString());
        }
    }

    public static TransactionId getTransaction(Event event) {
        TransactionId transaction = TransactionId.SENTINEL;
        String transId = (String)event.getProperty("transactionId");
        if (Strings.isNumeric((String)transId)) {
            transaction = TransactionId.valueOf(transId);
        }
        return transaction;
    }
}

