/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactWithRelationsAttribute;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.MaterialIcon;
import org.eclipse.osee.framework.core.data.OperationTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;

public class ArtifactWithRelations {
    private final ArtifactReadable artReadable;
    private final OrcsTokenService tokenService;
    private final List<ArtifactWithRelationsAttribute> attributes = new ArrayList<ArtifactWithRelationsAttribute>();
    private List<ArtifactRelation> relations = Collections.emptyList();

    public ArtifactWithRelations(ArtifactReadable artReadable, OrcsTokenService tokenService, boolean includeRelations) {
        this.artReadable = artReadable;
        this.tokenService = tokenService;
        List attrs = artReadable.getAttributesHashCollection().getValues();
        List pojoAttributes = attrs.stream().filter(attr -> attr != null).map(attr -> new ArtifactWithRelationsAttribute((IAttribute<?>)attr, artReadable.getArtifactType(), tokenService)).collect(Collectors.toList());
        this.attributes.addAll(pojoAttributes);
        if (includeRelations) {
            this.relations = this.loadRelations();
        }
    }

    public List<ArtifactWithRelationsAttribute> getAttributes() {
        return this.attributes;
    }

    public String getId() {
        return this.artReadable.getIdString();
    }

    public String getName() {
        return this.artReadable.getName();
    }

    public String getTypeId() {
        return this.artReadable.getArtifactType().getIdString();
    }

    public String getTypeName() {
        return this.artReadable.getArtifactType().getName();
    }

    public MaterialIcon getIcon() {
        return this.artReadable.getArtifactType().getIcon();
    }

    public Set<OperationTypeToken> getOperationTypes() {
        return this.artReadable.getArtifactType().getOperationTypes();
    }

    @JsonIgnore
    public String getBranchId() {
        return this.artReadable.getBranchIdString();
    }

    public List<ArtifactRelation> getRelations() {
        return this.relations;
    }

    private List<ArtifactRelation> loadRelations() {
        ArrayList<ArtifactRelation> relations = new ArrayList<ArtifactRelation>();
        List<RelationTypeToken> validRelationTypes = this.tokenService.getValidRelationTypes(this.artReadable.getArtifactType());
        for (RelationTypeToken rel : validRelationTypes) {
            ArtifactRelation pojoRelation = new ArtifactRelation(rel);
            this.artReadable.getRelated(new RelationTypeSide(rel, RelationSide.SIDE_A)).forEach(artReadA -> pojoRelation.addArtifactSideA(new ArtifactWithRelations((ArtifactReadable)artReadA, this.tokenService, false)));
            this.artReadable.getRelated(new RelationTypeSide(rel, RelationSide.SIDE_B)).forEach(artReadB -> pojoRelation.addArtifactSideB(new ArtifactWithRelations((ArtifactReadable)artReadB, this.tokenService, false)));
            relations.add(pojoRelation);
        }
        return relations;
    }

    public class ArtifactRelation {
        private RelationTypeToken relationTypeToken = null;
        private ArtifactRelationSide sideA = null;
        private ArtifactRelationSide sideB = null;
        private final List<ArtifactRelationSide> relationSides = new ArrayList<ArtifactRelationSide>();

        public ArtifactRelation(RelationTypeToken rel) {
            this.relationTypeToken = rel;
            this.sideA = new ArtifactRelationSide(this.relationTypeToken.getSideName(RelationSide.SIDE_A), true, false);
            this.sideB = new ArtifactRelationSide(this.relationTypeToken.getSideName(RelationSide.SIDE_B), false, true);
        }

        public List<ArtifactRelationSide> getRelationSides() {
            this.relationSides.add(this.sideA);
            this.relationSides.add(this.sideB);
            return this.relationSides;
        }

        public void addArtifactSideA(ArtifactWithRelations art) {
            this.sideA.addArtifact(art);
        }

        public void addArtifactSideB(ArtifactWithRelations art) {
            this.sideB.addArtifact(art);
        }

        public RelationTypeToken getRelationTypeToken() {
            return this.relationTypeToken;
        }
    }

    public class ArtifactRelationSide {
        private String name = "";
        private final List<ArtifactWithRelations> artifacts = new ArrayList<ArtifactWithRelations>();
        private Boolean isSideA = false;
        private Boolean isSideB = false;

        public ArtifactRelationSide(String name, Boolean isSideA, Boolean isSideB) {
            this.name = name;
            this.isSideA = isSideA;
            this.isSideB = isSideB;
        }

        public Boolean getIsSideA() {
            return this.isSideA;
        }

        public Boolean getIsSideB() {
            return this.isSideB;
        }

        public String getName() {
            return this.name;
        }

        public List<ArtifactWithRelations> getArtifacts() {
            return this.artifacts;
        }

        public void addArtifact(ArtifactWithRelations art) {
            this.artifacts.add(art);
        }
    }
}

