/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTokenDeserializer;
import org.eclipse.osee.framework.core.data.ArtifactTokenSerializer;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.HasArtifactType;
import org.eclipse.osee.framework.core.data.HasBranch;
import org.eclipse.osee.framework.jdk.core.type.Identity;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.logging.OseeLog;

@JsonSerialize(using=ArtifactTokenSerializer.class)
@JsonDeserialize(using=ArtifactTokenDeserializer.class)
public interface ArtifactToken
extends ArtifactId,
HasBranch,
NamedId,
HasArtifactType,
Identity<String> {
    public static final ArtifactToken SENTINEL = ArtifactToken.valueOf(ArtifactId.SENTINEL, BranchToken.SENTINEL);
    public static final String USE_LONG_IDS_KEY = "use.long.ids";
    public static final boolean USE_LONG_IDS = Boolean.valueOf(System.getProperty("use.long.ids", "false"));
    public static final ArtifactToken CLEAR_SELECTION = ArtifactToken.valueOf(ArtifactId.SENTINEL, "<Clear View Selection>");
    public static final /* synthetic */ boolean $assertionsDisabled;

    default public String getGuid() {
        throw new UnsupportedOperationException("getGuid() is not supported");
    }

    default public boolean isAttributeTypeValid(AttributeTypeId attributeType) {
        return this.getArtifactType().isValidAttributeType(attributeType);
    }

    public static ArtifactToken valueOf(ArtifactId id, String name) {
        return ArtifactToken.valueOf(id.getId(), GUID.create(), name, BranchToken.SENTINEL, ArtifactTypeToken.SENTINEL);
    }

    public static ArtifactToken valueOf(ArtifactId id, BranchToken branch) {
        if (id instanceof ArtifactToken) {
            return ArtifactToken.valueOf((ArtifactToken)id, branch);
        }
        return ArtifactToken.valueOf(id.getId(), GUID.create(), "", branch, ArtifactTypeToken.SENTINEL);
    }

    public static ArtifactToken valueOf(ArtifactToken token, BranchToken branch) {
        String useGuid = null;
        try {
            useGuid = token.getGuid();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        return ArtifactToken.valueOf(token.getId(), useGuid, token.getName(), branch, token.getArtifactType());
    }

    public static ArtifactToken valueOf(long id, BranchId branch) {
        return ArtifactToken.valueOf(id, GUID.create(), "", branch, ArtifactTypeToken.SENTINEL);
    }

    public static ArtifactToken valueOf(long id, String name, BranchToken branch) {
        return ArtifactToken.valueOf(id, GUID.create(), name, branch, ArtifactTypeToken.SENTINEL);
    }

    public static @NonNull ArtifactToken valueOf(long id, String name) {
        return ArtifactToken.valueOf(id, GUID.create(), name, BranchToken.SENTINEL, ArtifactTypeToken.SENTINEL);
    }

    public static ArtifactToken valueOf(long id, String name, ArtifactTypeToken artifactType) {
        return ArtifactToken.valueOf(id, GUID.create(), name, BranchToken.SENTINEL, artifactType);
    }

    public static ArtifactToken valueOf(long id, String name, BranchToken branch, ArtifactTypeToken artifactType) {
        return ArtifactToken.valueOf(id, GUID.create(), name, branch, artifactType);
    }

    public static @NonNull ArtifactToken valueOf(long id, String guid, String name, BranchId branch, ArtifactTypeToken artifactType) {
        return new ArtifactTokenImpl(id, guid, name, branch, artifactType);
    }

    public static @NonNull ArtifactToken valueOf(@NonNull ArtifactReadable artifactReadable) {
        assert (artifactReadable != null) : Conditions.assertMessageNonNull((String)"artifactReadable");
        BranchToken branch = artifactReadable.getBranch();
        ArtifactId viewId = branch.getViewId();
        viewId = Objects.nonNull(viewId) && viewId.isValid() ? ArtifactId.valueOf(viewId.getId()) : ArtifactId.SENTINEL;
        BranchId branchId = BranchId.create(branch.getId(), viewId);
        return new ArtifactTokenImpl(artifactReadable.getId(), artifactReadable.getGuid(), artifactReadable.getName(), branchId, artifactReadable.getArtifactType());
    }

    default public ArtifactToken getToken() {
        return ArtifactToken.valueOf(this.getId(), this.getName(), this.getBranch(), this.getArtifactType());
    }

    public static class ArtifactTokenImpl
    extends NamedIdBase
    implements ArtifactToken {
        private final BranchId branch;
        private final ArtifactTypeToken artifactType;
        private final String guid;

        public ArtifactTokenImpl(Long id, String guid, String name, BranchId branch, ArtifactTypeToken artifactType) {
            super(id, name);
            int idInt;
            if (!USE_LONG_IDS && (idInt = Long.valueOf(id).intValue()) <= 0 && idInt != -1) {
                String msg = String.format("Token id (as int) must be > 0 or SENTINAL, not int [%s] for long id [%s] name [%s] and type [%s])", idInt, id, name, artifactType.getName());
                OseeLog.log(ArtifactToken.class, (Level)Level.SEVERE, (String)msg);
                throw new OseeArgumentException(msg, new Object[0]);
            }
            this.branch = branch;
            this.artifactType = artifactType;
            this.guid = guid;
        }

        public ArtifactTokenImpl(Long id, String name, BranchToken common, ArtifactTypeToken artifactType) {
            this(id, GUID.create(), name, common, artifactType);
        }

        @Override
        public ArtifactTypeToken getArtifactType() {
            return this.artifactType;
        }

        @Override
        public BranchToken getBranch() {
            return BranchToken.valueOf(this.branch);
        }

        @Override
        public String getGuid() {
            return this.guid;
        }

        public boolean equals(Object obj) {
            boolean equal = super.equals(obj);
            if (equal && obj instanceof HasBranch) {
                return this.isOnSameBranch((HasBranch)obj);
            }
            return equal;
        }

        @Override
        public ArtifactToken getToken() {
            return ArtifactToken.valueOf((long)this.getId(), this.getName(), this.getBranch());
        }
    }
}

