/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access.context;

import java.util.Collection;
import org.eclipse.osee.framework.core.access.AccessTypeMatch;
import org.eclipse.osee.framework.core.access.context.AccessType;
import org.eclipse.osee.framework.core.access.context.AllowDeny;
import org.eclipse.osee.framework.core.access.context.IParentProvider;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class ArtifactTypeAccessType
implements AccessType {
    private AllowDeny allowDeny;
    private Collection<ArtifactTypeToken> artifactTypes;

    public ArtifactTypeAccessType(AllowDeny allowDeny, ArtifactTypeToken ... artifactTypes) {
        this.allowDeny = allowDeny;
        this.artifactTypes = Collections.asHashSet((Object[])artifactTypes);
    }

    public AllowDeny getAllowDeny() {
        return this.allowDeny;
    }

    public void setAllowDeny(AllowDeny allowDeny) {
        this.allowDeny = allowDeny;
    }

    public Collection<ArtifactTypeToken> getArtifactTypes() {
        return this.artifactTypes;
    }

    public void setArtifactTypes(Collection<ArtifactTypeToken> artifactTypes) {
        this.artifactTypes = artifactTypes;
    }

    @Override
    public boolean isArtifactType() {
        return true;
    }

    public String toString() {
        return "ArtType [allow=" + (Object)((Object)this.allowDeny) + ", artTypes=" + this.artifactTypes + "]";
    }

    @Override
    public AccessTypeMatch computeMatch(ArtifactToken otherArt, AttributeTypeToken attrType, RelationTypeToken relType, IParentProvider parentProvider) {
        boolean match = false;
        for (ArtifactTypeToken artType : this.artifactTypes) {
            if (!otherArt.getArtifactType().inheritsFrom(artType)) continue;
            match = true;
            break;
        }
        if (match) {
            if (this.allowDeny == AllowDeny.Allow) {
                return AccessTypeMatch.Allow;
            }
            if (this.allowDeny == AllowDeny.Deny) {
                return AccessTypeMatch.Deny;
            }
        }
        return AccessTypeMatch.NoMatch;
    }
}

