/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access;

import org.eclipse.osee.framework.core.access.object.AccessObject;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.enums.PermissionEnum;

public class AccessControlData
implements Comparable<AccessControlData> {
    private boolean dirty = false;
    private boolean birth = false;
    private final ArtifactToken subject;
    private final AccessObject object;
    private PermissionEnum permission;
    private PermissionEnum branchPermission = null;
    private PermissionEnum artifactTypePermission = null;
    private PermissionEnum artifactPermission = null;

    public AccessControlData(ArtifactToken subject, AccessObject object, PermissionEnum permission, boolean birth) {
        this(subject, object, permission, birth, true);
    }

    public AccessControlData(ArtifactToken subject, AccessObject object, PermissionEnum permission, boolean birth, boolean dirty) {
        this.subject = subject;
        this.permission = permission;
        this.dirty = dirty;
        this.birth = birth;
        this.object = object;
    }

    public ArtifactToken getSubject() {
        return this.subject;
    }

    public void setPermission(PermissionEnum permission) {
        if (this.permission == permission) {
            return;
        }
        this.permission = permission;
        this.dirty = true;
    }

    public PermissionEnum getBranchPermission() {
        return this.branchPermission;
    }

    public PermissionEnum getArtifactPermission() {
        return this.artifactPermission;
    }

    public PermissionEnum getArtifactTypePermission() {
        return this.artifactTypePermission;
    }

    public PermissionEnum getPermission() {
        return this.permission;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setNotDirty() {
        this.dirty = false;
    }

    public AccessObject getObject() {
        return this.object;
    }

    public boolean isBirth() {
        return this.birth;
    }

    @Override
    public int compareTo(AccessControlData data) {
        return this.subject.getName().compareTo(data.subject.getName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccessControlData)) {
            return false;
        }
        return this.subject.getName().equals(((AccessControlData)obj).subject.getName());
    }

    public int hashCode() {
        return this.subject.getName().hashCode();
    }

    public void setBranchPermission(PermissionEnum branchPermission) {
        this.branchPermission = branchPermission;
    }

    public void setArtifactTypePermission(PermissionEnum artifactTypePermission) {
        this.artifactTypePermission = artifactTypePermission;
    }

    public void setArtifactPermission(PermissionEnum artifactPermission) {
        this.artifactPermission = artifactPermission;
    }
}

