/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.access.AccessControlData;
import org.eclipse.osee.framework.core.access.AccessControlUtil;
import org.eclipse.osee.framework.core.access.AccessResult;
import org.eclipse.osee.framework.core.access.ArtifactCheck;
import org.eclipse.osee.framework.core.access.IAccessControlService;
import org.eclipse.osee.framework.core.access.IOseeAccessProvider;
import org.eclipse.osee.framework.core.access.object.AccessObject;
import org.eclipse.osee.framework.core.access.object.ArtifactAccessObject;
import org.eclipse.osee.framework.core.access.object.BranchAccessObject;
import org.eclipse.osee.framework.core.access.operation.AccessCache;
import org.eclipse.osee.framework.core.access.operation.AccessRankOperations;
import org.eclipse.osee.framework.core.access.operation.ArtifactAclOperations;
import org.eclipse.osee.framework.core.access.operation.BranchAclOperations;
import org.eclipse.osee.framework.core.access.operation.ContextIdOperations;
import org.eclipse.osee.framework.core.access.operation.IAccessStoreOperations;
import org.eclipse.osee.framework.core.access.operation.UserGroupOperations;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;

public abstract class AbstractAccessControlService
implements IAccessControlService {
    protected static final Collection<IOseeAccessProvider> oseeAccessProviders = new HashSet<IOseeAccessProvider>();
    protected final BranchAclOperations brchAclOps;
    protected UserGroupOperations userGrpOps;
    protected final ContextIdOperations contextIdOps;
    protected ArtifactAclOperations artAclOps;
    protected AccessCache cache;
    protected IAccessStoreOperations storeOps;
    private final AccessRankOperations rankOps;
    private final AtomicBoolean ensurePopulated = new AtomicBoolean(false);
    private final List<ArtifactCheck> artifactChecks = new ArrayList<ArtifactCheck>();
    private UserService userService;

    public AbstractAccessControlService() {
        this.cache = new AccessCache(this);
        this.rankOps = new AccessRankOperations(this.cache);
        this.contextIdOps = new ContextIdOperations(this);
        this.cache.setUserGrpOps(this.userGrpOps);
        this.cache.setArtAclOps(this.artAclOps);
        this.brchAclOps = new BranchAclOperations(this.cache, this.rankOps, this);
        this.cache.setBrchAclOps(this.brchAclOps);
    }

    public void setStoreOperations(IAccessStoreOperations storeOps) {
        this.storeOps = storeOps;
        this.artAclOps = new ArtifactAclOperations(this.cache, storeOps, this, this.rankOps);
    }

    public synchronized void addArtifactCheck(ArtifactCheck artifactCheck) {
        this.artifactChecks.add(artifactCheck);
    }

    public void bindUserService(UserService userService) {
        this.userService = userService;
        this.userGrpOps = new UserGroupOperations(this.cache, this, userService);
    }

    public synchronized void addOseeAccessProvider(IOseeAccessProvider provider) {
        AccessControlUtil.errorf("%s - Register: %s", this.getClass().getSimpleName(), provider.getClass().getSimpleName());
        oseeAccessProviders.add(provider);
        this.artifactChecks.clear();
    }

    @Override
    public void persistPermission(AccessControlData data) {
        this.ensurePopulated();
        this.storeOps.persistPermission(data);
    }

    @Override
    public void persistPermission(AccessControlData data, boolean recurse) {
        this.ensurePopulated();
        this.storeOps.persistPermission(data, recurse);
    }

    @Override
    public void setPermission(ArtifactToken subject, ArtifactToken artifact, PermissionEnum permission) {
        this.ensurePopulated();
        this.storeOps.setPermission(subject, artifact, permission);
    }

    @Override
    public void removeAccessControlDataIf(boolean removeFromDb, AccessControlData data) {
        this.ensurePopulated();
        this.storeOps.removeAccessControlDataIf(removeFromDb, data);
    }

    @Override
    public XResultData isModifyAccessEnabled(ArtifactToken subject, BranchToken branch, XResultData rd) {
        if (rd == null) {
            rd = new XResultData();
        }
        try {
            IUserGroup oseeAccessGroup = this.userService.getUserGroup(CoreUserGroups.OseeAccessAdmin);
            boolean isOseeAccessAdmin = oseeAccessGroup.isMember(subject.getId());
            if (isOseeAccessAdmin) {
                rd.logf("User %s DOES have Access Modify rights for Branch %s: Reason [%s]", new Object[]{subject.getName(), branch.toStringWithId(), CoreUserGroups.OseeAccessAdmin.getName()});
            } else {
                boolean objectHasAccessSet;
                boolean bl = objectHasAccessSet = !this.getAccessControlList(branch).isEmpty();
                if (objectHasAccessSet) {
                    XResultData rd2 = this.hasBranchPermission(subject, branch, PermissionEnum.FULLACCESS, null);
                    if (rd2.isErrors()) {
                        rd.errorf("User %s DOES NOT have Access Modify rights for Branch %s: Reason [No FULL_ACCESS]", new Object[]{subject.getName(), branch.toStringWithId()});
                    } else {
                        rd.logf("User %s DOES have Access Modify rights for Branch %s: Reason [Branch FULL_ACCESS]", new Object[]{subject.getName(), branch.toStringWithId()});
                    }
                } else {
                    rd.errorf("User %s DOES NOT have Access Modify rights for Branch %s: Reason [Access Not Set]", new Object[]{subject.getName(), branch.toStringWithId()});
                }
            }
        }
        catch (OseeCoreException ex) {
            rd.errorf("User %s DOES NOT have Access Modify rights for Branch %s: Reason Exception [%s]", new Object[]{subject.getName(), branch.toStringWithId(), Lib.exceptionToString((Exception)((Object)ex))});
        }
        return rd;
    }

    @Override
    public PermissionEnum getPermission(BranchToken branch) {
        this.ensurePopulated();
        return this.brchAclOps.getBranchPermission(this.getUser(), branch);
    }

    @Override
    public void removePermissions(BranchId branch) {
        this.ensurePopulated();
        this.storeOps.removePermissions(branch);
    }

    @Override
    public void setPermission(ArtifactToken subject, BranchId branch, PermissionEnum permission) {
        this.ensurePopulated();
        this.storeOps.setPermission(subject, branch, permission);
    }

    @Override
    public XResultData hasBranchPermission(BranchToken branch, PermissionEnum permission, XResultData rd) {
        return this.hasBranchPermission(this.getUser(), branch, permission, rd);
    }

    @Override
    public XResultData hasBranchPermission(ArtifactToken subject, BranchToken branch, PermissionEnum permission, XResultData rd) {
        this.ensurePopulated();
        if (rd == null) {
            rd = new XResultData();
        }
        if (branch.isInvalid()) {
            rd.errorf("Branch %s is InValid\n", new Object[]{branch.toStringWithId()});
            return rd;
        }
        XResultData fullAccessRd = this.brchAclOps.hasBranchAclPermission(subject, branch, PermissionEnum.FULLACCESS, new XResultData());
        boolean baselineBranch = this.isBaselineBranch(branch);
        if (baselineBranch && fullAccessRd.isSuccess()) {
            rd.merge(fullAccessRd);
            return rd;
        }
        this.brchAclOps.hasBranchAclPermission(subject, branch, permission, rd);
        if (rd.isErrors()) {
            return rd;
        }
        return rd;
    }

    @Override
    public abstract boolean isBaselineBranch(BranchToken var1);

    @Override
    public XResultData isModifyAccessEnabled(ArtifactToken subject, ArtifactToken artifact, XResultData rd) {
        if (rd == null) {
            rd = new XResultData();
        }
        try {
            IUserGroup oseeAccessGroup = this.userService.getUserGroup(CoreUserGroups.OseeAccessAdmin);
            boolean isOseeAccessAdmin = oseeAccessGroup.isMember(subject.getId());
            if (isOseeAccessAdmin) {
                rd.logf("User %s DOES have Access Modify rights for Artifact %s: Reason [%s]", new Object[]{subject.getName(), artifact.toStringWithId(), CoreUserGroups.OseeAccessAdmin.getName()});
            } else {
                boolean objectHasAccessSet;
                boolean artifactAccess = true;
                boolean bl = objectHasAccessSet = !this.getAccessControlList(artifact).isEmpty();
                if (!objectHasAccessSet) {
                    objectHasAccessSet = !this.getAccessControlList(artifact.getBranch()).isEmpty();
                    artifactAccess = false;
                }
                if (objectHasAccessSet) {
                    XResultData rd2 = this.hasArtifactPermission(subject, Collections.singleton(artifact), PermissionEnum.FULLACCESS, null);
                    if (rd2.isErrors()) {
                        rd.errorf("User %s DOES NOT have Access Modify rights for Artifact %s: Reason [No FULL_ACCESS]", new Object[]{subject.getName(), artifact.toStringWithId()});
                    } else {
                        rd.logf("User %s DOES have Access Modify rights for Artifact %s: Reason [%s FULL_ACCESS]", new Object[]{subject.getName(), artifact.toStringWithId(), artifactAccess ? "Artifact" : "Branch"});
                    }
                } else {
                    rd.errorf("User %s DOES NOT have Access Modify rights for Artifact %s: Reason [Access Not Set]", new Object[]{subject.getName(), artifact.toStringWithId()});
                }
            }
        }
        catch (OseeCoreException ex) {
            rd.errorf("User %s DOES NOT have Access Modify rights for Artifact %s: Reason Exception [%s]", new Object[]{subject.getName(), artifact.toStringWithId(), Lib.exceptionToString((Exception)((Object)ex))});
        }
        return rd;
    }

    @Override
    public PermissionEnum getPermission(ArtifactToken artifact) {
        this.ensurePopulated();
        return this.artAclOps.getArtifactPermission(this.getUser(), artifact);
    }

    @Override
    public XResultData hasArtifactPermission(ArtifactToken artifact, PermissionEnum permission, XResultData rd) {
        return this.hasArtifactPermission(this.getUser(), Collections.singleton(artifact), permission, rd);
    }

    @Override
    public XResultData hasArtifactPermission(Collection<? extends ArtifactToken> artifacts, PermissionEnum permission, XResultData rd) {
        return this.hasArtifactPermission(this.getUser(), artifacts, permission, rd);
    }

    @Override
    public XResultData hasArtifactPermission(ArtifactToken subject, Collection<? extends ArtifactToken> artifacts, PermissionEnum permission, XResultData rd) {
        this.ensurePopulated();
        if (rd == null) {
            rd = new XResultData();
        }
        for (ArtifactToken artifactToken : artifacts) {
            AccessResult ard = this.checkBaseBranchAndArtAcl(subject, permission, rd, artifactToken);
            if (!rd.isErrors() && !ard.isFullAccess()) continue;
            return rd;
        }
        if (permission.matches(PermissionEnum.WRITE) || permission.matches(PermissionEnum.FULLACCESS)) {
            this.contextIdOps.hasArtifactContextWriteAccess(subject, artifacts, rd);
        } else {
            rd.logf("Context Id: Subject [%s] DOES have [%s] access for artifacts with permission [%s]\n", new Object[]{subject.getName(), permission, "Context Id: Only Checked for Write or Full Access"});
        }
        return rd;
    }

    @Override
    public ArtifactToken getSubjectFromLockedObject(ArtifactToken artifact) {
        this.ensurePopulated();
        return this.artAclOps.getSubjectFromLockedObject(artifact);
    }

    @Override
    public boolean canUnlockObject(ArtifactToken subject, ArtifactToken artifact) {
        this.ensurePopulated();
        return this.artAclOps.canUnlockObject(subject, artifact);
    }

    @Override
    public boolean hasLock(ArtifactToken artifact) {
        this.ensurePopulated();
        return this.artAclOps.hasLock(artifact);
    }

    @Override
    public void lockArtifacts(ArtifactToken subject, Collection<? extends ArtifactToken> artifacts) {
        this.ensurePopulated();
        this.artAclOps.lockArtifacts(subject, artifacts);
    }

    @Override
    public void unLockArtifacts(ArtifactToken subject, Collection<? extends ArtifactToken> artifacts) {
        this.ensurePopulated();
        this.artAclOps.unLockArtifacts(subject, artifacts);
    }

    @Override
    public XResultData hasAttributeTypePermission(Collection<? extends ArtifactToken> artifacts, AttributeTypeToken attributeType, PermissionEnum permission, XResultData rd) {
        ArtifactToken currentUser = this.getUser();
        return this.hasAttributeTypePermission(currentUser, artifacts, attributeType, permission, rd);
    }

    @Override
    public XResultData hasAttributeTypePermission(ArtifactToken subject, Collection<? extends ArtifactToken> artifacts, AttributeTypeToken attributeType, PermissionEnum permission, XResultData rd) {
        this.ensurePopulated();
        if (this.isInDbInit()) {
            rd.log("In DB Init; All permission enabled");
        } else {
            if (subject.isInvalid()) {
                rd.errorf("Subject [%s] is InValid\n", new Object[]{subject.getIdString()});
                return rd;
            }
            if (artifacts != null) {
                for (ArtifactToken artifactToken : artifacts) {
                    AccessResult ard = this.checkBaseBranchAndArtAcl(subject, permission, rd, artifactToken);
                    if (!rd.isErrors() && !ard.isFullAccess()) continue;
                    return rd;
                }
                if (permission.matches(PermissionEnum.WRITE) || permission.matches(PermissionEnum.FULLACCESS)) {
                    this.contextIdOps.hasAttributeTypeContextWriteAccess(subject, artifacts, attributeType, rd);
                } else {
                    rd.logf("Context Id: Subject [%s] DOES have [%s] access for artifacts with permission [%s]\n", new Object[]{subject.getName(), permission, "Context Id: Only Checked for Write or Full Access"});
                }
            }
        }
        return rd;
    }

    protected abstract boolean isInDbInit();

    private AccessResult checkBaseBranchAndArtAcl(ArtifactToken subject, PermissionEnum permission, XResultData rd, ArtifactToken artifact) {
        this.ensurePopulated();
        AccessResult result = new AccessResult(rd);
        if (artifact.isInvalid()) {
            rd.errorf("Artifact [%s] is InValid\n", new Object[]{artifact.getIdString()});
            return result;
        }
        XResultData fullAccessRd = this.brchAclOps.hasBranchAclPermission(subject, artifact.getBranch(), PermissionEnum.FULLACCESS, new XResultData());
        boolean baselineBranch = this.isBaselineBranch(artifact.getBranch());
        if (baselineBranch && fullAccessRd.isSuccess()) {
            rd.merge(fullAccessRd);
            result.setFullAccess(true);
            return result;
        }
        this.brchAclOps.hasBranchAclPermission(subject, artifact.getBranch(), permission, rd);
        if (rd.isErrors()) {
            return result;
        }
        this.artAclOps.hasArtifactAclPermission(subject, artifact, permission, rd);
        if (rd.isErrors()) {
            return result;
        }
        return result;
    }

    @Override
    public XResultData hasRelationTypePermission(ArtifactToken artifact, RelationTypeToken relationType, Collection<? extends ArtifactToken> related, PermissionEnum permission, XResultData rd) {
        return this.hasRelationTypePermission(this.getUser(), artifact, relationType, related, permission, rd);
    }

    @Override
    public XResultData hasRelationTypePermission(ArtifactToken subject, ArtifactToken artifact, RelationTypeToken relationType, Collection<? extends ArtifactToken> related, PermissionEnum permission, XResultData rd) {
        BranchToken branch;
        Conditions.assertNotNull(related, (String)"Related should be collection or empty collection, not null", (Object[])new Object[0]);
        this.ensurePopulated();
        if (rd == null) {
            rd = new XResultData();
        }
        if ((branch = artifact.getBranch()) == null || branch.isInvalid()) {
            rd.errorf("Invalid branch for artifact %s", new Object[]{artifact.toStringWithId()});
            return rd;
        }
        AccessResult ard = this.checkBaseBranchAndArtAcl(subject, permission, rd, artifact);
        if (rd.isErrors() || ard.isFullAccess()) {
            return rd;
        }
        this.artAclOps.hasArtifactAclPermission(artifact, permission, rd);
        for (ArtifactToken artifactToken : related) {
            this.artAclOps.hasArtifactAclPermission(artifactToken, permission, rd);
        }
        if (permission.matches(PermissionEnum.WRITE) || permission.matches(PermissionEnum.FULLACCESS)) {
            this.contextIdOps.hasRelationContextWriteAccess(subject, artifact, relationType, related, rd);
        } else {
            rd.logf("Context Id: Subject [%s] DOES have [%s] access for artifacts with permission [%s]\n", new Object[]{subject.getName(), permission, "Context Id: Only Checked for Write or Full Access"});
        }
        return rd;
    }

    @Override
    public abstract boolean isInDb(ArtifactToken var1);

    @Override
    public abstract ArtifactToken getUser();

    @Override
    public void reloadCache() {
        this.ensurePopulated.set(false);
    }

    @Override
    public synchronized void ensurePopulated() {
        if (this.ensurePopulated.compareAndSet(false, true)) {
            this.cache.initializeCaches();
            this.populateArtifactAccessControlList();
            this.populateBranchAccessControlList();
        }
    }

    public abstract void populateBranchAccessControlList();

    public abstract void populateArtifactAccessControlList();

    @Override
    public abstract void populateGroupMembers(ArtifactId var1);

    @Override
    public void clearCaches() {
        this.cache.initializeCaches();
        this.ensurePopulated.set(false);
    }

    @Override
    public List<AccessControlData> getAccessControlList(Object object) {
        List<AccessControlData> datas = new LinkedList<AccessControlData>();
        AccessObject accessObject = null;
        try {
            accessObject = AccessObject.valueOf(object);
            if (accessObject == null) {
                return datas;
            }
            datas = this.generateAccessControlList(accessObject);
        }
        catch (Exception ex) {
            OseeLog.log(AbstractAccessControlService.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return datas;
    }

    public List<AccessControlData> generateAccessControlList(AccessObject accessObject) {
        this.ensurePopulated();
        LinkedList<AccessControlData> datas = new LinkedList<AccessControlData>();
        Collection subjects = this.cache.objectToSubjectCache.getValues((Object)accessObject);
        if (subjects == null) {
            return datas;
        }
        for (ArtifactId subjectId : subjects) {
            ArtifactToken subject = this.getArtifactFromId(subjectId, CoreBranches.COMMON);
            PermissionEnum permissionEnum = (PermissionEnum)((Object)this.cache.accessControlListCache.get((Object)subjectId.getId(), (Object)accessObject));
            AccessControlData accessControlData = new AccessControlData(subject, accessObject, permissionEnum, false, false);
            if (accessObject instanceof ArtifactAccessObject) {
                accessControlData.setArtifactPermission(permissionEnum);
                accessControlData.setBranchPermission(this.brchAclOps.getBranchPermission(subject, accessObject.getBranch()));
            } else if (accessObject instanceof BranchAccessObject) {
                accessControlData.setBranchPermission(this.brchAclOps.getBranchPermission(subject, accessObject.getBranch()));
            }
            datas.add(accessControlData);
        }
        return datas;
    }

    public abstract ArtifactToken getArtifactFromId(ArtifactId var1, BranchToken var2);

    public Collection<ArtifactCheck> getArtifactChecks() {
        if (this.artifactChecks.isEmpty()) {
            for (IOseeAccessProvider provider : oseeAccessProviders) {
                this.artifactChecks.addAll(provider.getArtifactChecks());
            }
        }
        return this.artifactChecks;
    }

    @Override
    public XResultData isDeleteable(Collection<? extends ArtifactToken> artifacts, XResultData results) {
        for (ArtifactCheck check : this.getArtifactChecks()) {
            check.isDeleteable(artifacts, results);
        }
        return results;
    }

    @Override
    public XResultData isRenamable(Collection<? extends ArtifactToken> artifacts, XResultData results) {
        for (ArtifactCheck check : this.getArtifactChecks()) {
            check.isRenamable(artifacts, results);
        }
        return results;
    }

    @Override
    public XResultData isAddableRelationUI(ArtifactToken artifact, RelationTypeToken relationType, XResultData results) {
        for (ArtifactCheck check : this.getArtifactChecks()) {
            check.isAddableRelationUI(artifact, relationType, results);
        }
        return results;
    }

    @Override
    public XResultData isDeleteableRelationUI(ArtifactToken artifact, RelationTypeToken relationType, XResultData results) {
        for (ArtifactCheck check : this.getArtifactChecks()) {
            check.isDeleteableRelationUI(artifact, relationType, results);
        }
        return results;
    }

    @Override
    public Collection<IOseeAccessProvider> getOseeAccessProviders() {
        return oseeAccessProviders;
    }
}

