/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.util;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.OrcsApi;

public class ComponentUtil {
    private final BranchId branchId;
    private final OrcsApi orcsApi;
    private ArtifactReadable mpCsci;
    private Collection<ArtifactReadable> mpComponents;
    private final AtomicBoolean wasLoaded;

    public ComponentUtil(BranchId branchId, OrcsApi providedOrcs) {
        this.branchId = branchId;
        this.mpComponents = null;
        this.wasLoaded = new AtomicBoolean(false);
        this.mpCsci = null;
        this.orcsApi = providedOrcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureLoaded() {
        if (this.wasLoaded.get()) {
            return;
        }
        ComponentUtil componentUtil = this;
        synchronized (componentUtil) {
            if (this.wasLoaded.get()) {
                return;
            }
            this.wasLoaded.set(true);
            this.mpCsci = (ArtifactReadable)this.orcsApi.getQueryFactory().fromBranch(this.branchId).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.Component}).andNameEquals("MP CSCI").getResults().getExactlyOne();
            this.mpComponents = this.mpCsci.getDescendants();
        }
    }

    public String getQualifiedComponentName(ArtifactReadable component) {
        this.ensureLoaded();
        if (component.getParent().equals(this.mpCsci)) {
            return component.getName();
        }
        return String.valueOf(component.getParent().getName()) + "." + component.getName();
    }

    public String getQualifiedComponentNames(ArtifactReadable requirement) {
        this.ensureLoaded();
        ResultSet components = requirement.getRelated(CoreRelationTypes.Allocation_Component);
        StringBuilder strB = new StringBuilder(20);
        for (ArtifactReadable component : components) {
            if (!this.mpComponents.contains(component)) continue;
            strB.append(this.getQualifiedComponentName(component));
            strB.append(", ");
        }
        return strB.length() == 0 ? null : strB.substring(0, strB.length() - 2);
    }

    public Collection<ArtifactReadable> getComponents() {
        this.ensureLoaded();
        return this.mpComponents;
    }
}

