/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.publishing.templatemanager;

import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.define.operations.api.DefineOperations;
import org.eclipse.osee.define.operations.api.publisher.templatemanager.TemplateManagerOperations;
import org.eclipse.osee.define.operations.publisher.publishing.PublishingPermissions;
import org.eclipse.osee.define.operations.publisher.publishing.UserNotAuthorizedForPublishingException;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateKeyGroups;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.TemplateManagerEndpoint;
import org.eclipse.osee.framework.core.publishing.PublishingTemplate;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class TemplateManagerEndpointImpl
implements TemplateManagerEndpoint {
    private final @NonNull TemplateManagerOperations templateManagerOperations;

    public TemplateManagerEndpointImpl(@NonNull DefineOperations defineOperations) {
        try {
            this.templateManagerOperations = defineOperations.getPublisherOperations().getTemplateManagerOperations();
        }
        catch (NullPointerException e) {
            NullPointerException npe = new NullPointerException("TemplateManagerEndpointImpl::new, unable to obtian the \"TemplateManagerOperations\".");
            npe.initCause(e);
            throw npe;
        }
        catch (Exception e) {
            throw new OseeCoreException("TemplateManagerEndpointImpl::new, unable to obtian the \"TemplateManagerOperations\".", (Throwable)e);
        }
    }

    public void deleteCache() {
        try {
            PublishingPermissions.verify();
            this.templateManagerOperations.deleteCache();
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public PublishingTemplate getPublishingTemplate(PublishingTemplateRequest publishingTemplateRequest) {
        try {
            PublishingPermissions.verifyNonGroup();
            PublishingTemplate publishingTemplate = this.templateManagerOperations.getPublishingTemplate(publishingTemplateRequest);
            return publishingTemplate;
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public String getPublishingTemplateStatus(PublishingTemplateRequest publishingTemplateRequest) {
        try {
            PublishingPermissions.verifyNonGroup();
            return this.templateManagerOperations.getPublishingTemplateStatus(publishingTemplateRequest);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public PublishingTemplateKeyGroups getPublishingTemplateKeyGroups(@NonNull String filterBySafeName) {
        try {
            PublishingPermissions.verifyNonGroup();
            return this.templateManagerOperations.getPublishingTemplateKeyGroups(filterBySafeName);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }
}

