/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.publishing;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.eclipse.osee.define.operations.api.DefineOperations;
import org.eclipse.osee.define.operations.markdown.MarkdownConverter;
import org.eclipse.osee.define.operations.publisher.publishing.PublishingPermissions;
import org.eclipse.osee.define.operations.publisher.publishing.UserNotAuthorizedForPublishingException;
import org.eclipse.osee.define.rest.api.publisher.publishing.LinkHandlerResult;
import org.eclipse.osee.define.rest.api.publisher.publishing.PublishingEndpoint;
import org.eclipse.osee.define.rest.api.publisher.publishing.PublishingRequestData;
import org.eclipse.osee.define.rest.api.publisher.publishing.WordUpdateChange;
import org.eclipse.osee.define.rest.api.publisher.publishing.WordUpdateData;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.exception.OseeNotFoundException;
import org.eclipse.osee.framework.core.publishing.FormatIndicator;
import org.eclipse.osee.framework.core.publishing.RendererMap;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.core.publishing.WordTemplateContentData;
import org.eclipse.osee.framework.core.util.LinkType;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public class PublishingEndpointImpl
implements PublishingEndpoint {
    private final DefineOperations defineOperations;

    public PublishingEndpointImpl(DefineOperations defineOperations) {
        this.defineOperations = Objects.requireNonNull(defineOperations, "PublishingEndpointImpl::new, parameter \"defineOperations\" cannot be null.");
    }

    public List<ArtifactToken> getSharedPublishingArtifacts(BranchId branch, ArtifactId view, ArtifactId sharedFolder, ArtifactTypeToken artifactType, AttributeTypeToken attributeType, String attributeValue) {
        try {
            PublishingPermissions.verify();
            return this.defineOperations.getPublisherOperations().getPublishingOperations().getSharedPublishingArtifacts(branch, view, sharedFolder, artifactType, attributeType, attributeValue).stream().map(ArtifactToken::valueOf).collect(Collectors.toList());
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (OseeNotFoundException onfe) {
            throw new NotFoundException(onfe.getMessage(), Response.status((Response.Status)Response.Status.NOT_FOUND).build(), (Throwable)onfe);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public LinkHandlerResult link(BranchId branchId, ArtifactId viewId, ArtifactId artifactId, TransactionId transactionId, LinkType linkType, PresentationType presentationType) {
        try {
            PublishingPermissions.verifyNonGroup();
            return this.defineOperations.getPublisherOperations().getPublishingOperations().link(branchId, viewId, artifactId, transactionId, linkType, presentationType);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (OseeNotFoundException onfe) {
            throw new NotFoundException(onfe.getMessage(), Response.status((Response.Status)Response.Status.NOT_FOUND).build(), (Throwable)onfe);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    @Deprecated
    public Attachment msWordPreview(BranchId branch, ArtifactId template, ArtifactId headArtifact, ArtifactId view) {
        try {
            PublishingPermissions.verifyNonGroup();
            BranchSpecification branchSpecification = new BranchSpecification(branch, view);
            PublishingTemplateRequest publishingTemplateRequest = new PublishingTemplateRequest("AT-" + template.getIdString(), FormatIndicator.WORD_ML);
            RendererMap publishingRendererOptions = RendererMap.of((Object[])new Object[]{RendererOption.PUBLISH_IDENTIFIER, "Publish Preview With Folders", RendererOption.LINK_TYPE, LinkType.INTERNAL_DOC_REFERENCE_USE_NAME, RendererOption.MAX_OUTLINE_DEPTH, 9, RendererOption.PUBLISHING_FORMAT, FormatIndicator.WORD_ML, RendererOption.BRANCH, branchSpecification.getBranchIdWithOutViewId(), RendererOption.VIEW, branchSpecification.getViewId()});
            PublishingRequestData msWordPreviewRequestData = new PublishingRequestData(publishingTemplateRequest, publishingRendererOptions, List.of(headArtifact));
            return this.defineOperations.getPublisherOperations().getPublishingOperations().msWordPreview(msWordPreviewRequestData);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    @Deprecated
    public Attachment msWordPreview(BranchId branch, ArtifactId template, List<ArtifactId> artifacts, ArtifactId view) {
        try {
            PublishingPermissions.verifyNonGroup();
            BranchSpecification branchSpecification = new BranchSpecification(branch, view);
            PublishingTemplateRequest publishingTemplateRequest = new PublishingTemplateRequest("AT-" + template.getIdString(), FormatIndicator.WORD_ML);
            RendererMap publishingRendererOptions = RendererMap.of((Object[])new Object[]{RendererOption.PUBLISH_IDENTIFIER, "Publish Preview With Folders", RendererOption.LINK_TYPE, LinkType.INTERNAL_DOC_REFERENCE_USE_NAME, RendererOption.MAX_OUTLINE_DEPTH, 9, RendererOption.PUBLISHING_FORMAT, FormatIndicator.WORD_ML, RendererOption.BRANCH, branchSpecification.getBranchIdWithOutViewId(), RendererOption.VIEW, branchSpecification.getViewId()});
            PublishingRequestData msWordPreviewRequestData = new PublishingRequestData(publishingTemplateRequest, publishingRendererOptions, artifacts);
            return this.defineOperations.getPublisherOperations().getPublishingOperations().msWordPreview(msWordPreviewRequestData);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public Attachment msWordPreview(PublishingRequestData msWordPreviewRequestData) {
        Thread thread = Thread.currentThread();
        String origThreadName = thread.getName();
        thread.setName("PublishingEndpointImpl::msWordPreviewRequestData");
        try {
            PublishingPermissions.verifyNonGroup();
            Attachment attachment = this.defineOperations.getPublisherOperations().getPublishingOperations().msWordPreview(msWordPreviewRequestData);
            return attachment;
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
        finally {
            thread.setName(origThreadName);
        }
    }

    @Deprecated
    public Attachment msWordTemplatePublish(BranchId branch, ArtifactId template, ArtifactId headArtifact, ArtifactId view) {
        try {
            PublishingPermissions.verifyNonGroup();
            BranchSpecification branchSpecification = new BranchSpecification(branch, view);
            PublishingTemplateRequest publishingTemplateRequest = new PublishingTemplateRequest("AT-" + template.getIdString(), FormatIndicator.WORD_ML);
            RendererMap publishingRendererOptions = RendererMap.of((Object[])new Object[]{RendererOption.PUBLISH_IDENTIFIER, "Publish Preview Without Folders", RendererOption.OUTLINING_OPTION_OVERRIDE_EXCLUDE_ARTIFACT_TYPES, List.of(CoreArtifactTypes.Folder), RendererOption.LINK_TYPE, LinkType.INTERNAL_DOC_REFERENCE_USE_NAME, RendererOption.MAX_OUTLINE_DEPTH, 9, RendererOption.PUBLISHING_FORMAT, FormatIndicator.WORD_ML, RendererOption.BRANCH, branchSpecification.getBranchIdWithOutViewId(), RendererOption.VIEW, branchSpecification.getViewId()});
            PublishingRequestData msWordPreviewRequestData = new PublishingRequestData(publishingTemplateRequest, publishingRendererOptions, List.of(headArtifact));
            return this.defineOperations.getPublisherOperations().getPublishingOperations().msWordPreview(msWordPreviewRequestData);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public Attachment msWordWholeWordContentPublish(BranchId branchId, ArtifactId viewId, ArtifactId artifactId, TransactionId transactionId, LinkType linkType, PresentationType presentationType, boolean includeErrorLog) {
        try {
            PublishingPermissions.verifyNonGroup();
            return this.defineOperations.getPublisherOperations().getPublishingOperations().msWordWholeWordContentPublish(branchId, viewId, artifactId, transactionId, linkType, presentationType, includeErrorLog);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (OseeNotFoundException onfe) {
            throw new NotFoundException(onfe.getMessage(), Response.status((Response.Status)Response.Status.NOT_FOUND).build(), (Throwable)onfe);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public Pair<String, Set<String>> renderWordTemplateContent(WordTemplateContentData wordTemplateContentData) {
        try {
            PublishingPermissions.verifyNonGroup();
            return this.defineOperations.getPublisherOperations().getPublishingOperations().renderWordTemplateContent(wordTemplateContentData);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public LinkHandlerResult unlink(BranchId branchId, ArtifactId viewId, ArtifactId artifactId, TransactionId transactionId, LinkType linkType) {
        try {
            PublishingPermissions.verifyNonGroup();
            return this.defineOperations.getPublisherOperations().getPublishingOperations().unlink(branchId, viewId, artifactId, transactionId, linkType);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (OseeNotFoundException onfe) {
            throw new NotFoundException(onfe.getMessage(), Response.status((Response.Status)Response.Status.NOT_FOUND).build(), (Throwable)onfe);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public String updateLinks(BranchId branchId) {
        try {
            PublishingPermissions.verifyNonGroup();
            return this.defineOperations.getPublisherOperations().getPublishingOperations().updateLinks(branchId);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public WordUpdateChange updateWordArtifacts(WordUpdateData wordUpdateData) {
        try {
            PublishingPermissions.verifyNonGroup();
            return this.defineOperations.getPublisherOperations().getPublishingOperations().updateWordArtifacts(wordUpdateData);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public Response convertMarkdownToHtml(String markdownContent) {
        try {
            PublishingPermissions.verifyNonGroup();
            if (markdownContent == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Markdown content is null").build();
            }
            MarkdownConverter mdConverter = new MarkdownConverter();
            String html = mdConverter.convertToHtmlString(markdownContent);
            ByteArrayInputStream stream = new ByteArrayInputStream(html.getBytes(StandardCharsets.UTF_8));
            return Response.ok((Object)stream).header("Content-Disposition", (Object)"attachment; filename=markdownToHtml.html").build();
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public Attachment publishMarkdownAsHtml(PublishingRequestData publishMarkdownAsHtmlRequestData) {
        Thread thread = Thread.currentThread();
        String origThreadName = thread.getName();
        thread.setName("PublishingEndpointImpl::msWordPreviewRequestData");
        try {
            PublishingPermissions.verifyNonGroup();
            Attachment attachment = this.defineOperations.getPublisherOperations().getPublishingOperations().publishMarkdownAsHtml(publishMarkdownAsHtmlRequestData);
            return attachment;
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
        finally {
            thread.setName(origThreadName);
        }
    }

    public String cleanAllMarkdownArtifactsForBranch(BranchId branchId) {
        try {
            PublishingPermissions.verify();
            return this.defineOperations.getPublisherOperations().getPublishingOperations().cleanAllMarkdownArtifactsForBranch(branchId);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public String removeMarkdownBoldSymbolsFromAllMarkdownArtifactsForBranch(BranchId branchId) {
        try {
            PublishingPermissions.verify();
            return this.defineOperations.getPublisherOperations().getPublishingOperations().removeMarkdownBoldSymbolsFromAllMarkdownArtifactsForBranch(branchId);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }
}

