/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal.wordupdate;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.osee.define.operations.publisher.publishing.WordCoreUtilServer;
import org.eclipse.osee.define.rest.api.publisher.publishing.WordArtifactChange;
import org.eclipse.osee.define.rest.api.publisher.publishing.WordUpdateChange;
import org.eclipse.osee.define.rest.api.publisher.publishing.WordUpdateData;
import org.eclipse.osee.define.rest.internal.wordupdate.IElementExtractor;
import org.eclipse.osee.define.rest.internal.wordupdate.MergeEditArtifactElementExtractor;
import org.eclipse.osee.define.rest.internal.wordupdate.WordExtractorData;
import org.eclipse.osee.define.rest.internal.wordupdate.WordImageArtifactElementExtractor;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMLApplicabilityHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMlLinkHandler;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.core.util.LinkType;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.xml.Jaxp;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;
import org.osgi.service.event.EventAdmin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WordUpdateArtifact {
    private final OrcsApi orcsApi;
    private final QueryFactory queryFactory;
    private final Log logger;

    public WordUpdateArtifact(Log logger, OrcsApi orcsApi, EventAdmin eventAdmin) {
        this.orcsApi = orcsApi;
        this.queryFactory = orcsApi.getQueryFactory();
        this.logger = logger;
    }

    public WordUpdateChange updateArtifacts(WordUpdateData data) {
        Element oleDataElement;
        Collection<WordExtractorData> extractorDatas;
        try {
            IElementExtractor elementExtractor;
            Document document = this.extractJaxpDocument(data);
            if (data.isThreeWayMerge()) {
                String guid = ((ArtifactReadable)this.orcsApi.getQueryFactory().fromBranch(data.getBranch()).andUuid(((Long)data.getArtifacts().iterator().next()).longValue()).getResults().getExactlyOne()).getGuid();
                elementExtractor = new MergeEditArtifactElementExtractor(guid, document);
            } else {
                elementExtractor = new WordImageArtifactElementExtractor(document);
            }
            extractorDatas = elementExtractor.extractElements();
            oleDataElement = elementExtractor.getOleDataElement();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        return this.wordArtifactUpdate(data, extractorDatas, oleDataElement);
    }

    public ArtifactReadable getArtifact(BranchId branch, String guid) {
        return (ArtifactReadable)this.queryFactory.fromBranch(branch).andGuid(guid).getResults().getExactlyOne();
    }

    private Document extractJaxpDocument(WordUpdateData data) throws ParserConfigurationException, SAXException, IOException {
        Document document;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(data.getWordData());){
            document = Jaxp.nonDeferredReadXmlDocument((InputStream)stream, (String)"UTF-8");
        }
        return document;
    }

    private WordUpdateChange wordArtifactUpdate(WordUpdateData data, Collection<WordExtractorData> extractorDatas, Element oleDataElement) {
        ArrayList deletedArtifacts = Lists.newArrayList();
        WordUpdateChange updateChange = new WordUpdateChange();
        try {
            TransactionFactory txFactory = this.orcsApi.getTransactionFactory();
            boolean singleArtifact = extractorDatas.size() == 1;
            boolean containsOleData = false;
            boolean containsWordData = false;
            TransactionBuilder txBuilder = txFactory.createTransaction(data.getBranch(), data.getUserArtId(), data.getComment());
            for (WordExtractorData extractorData : extractorDatas) {
                boolean multiSave;
                ArtifactReadable artifact = this.getArtifact(data.getBranch(), extractorData.getGuid());
                WordArtifactChange artChange = new WordArtifactChange();
                artChange.setArtId(artifact.getId().longValue());
                if (artifact.isDeleted()) {
                    deletedArtifacts.add(artifact.getName());
                    continue;
                }
                containsOleData = artifact.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.WordOleData) > 0;
                boolean bl = containsWordData = artifact.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.WordTemplateContent) > 0;
                if (oleDataElement == null && containsOleData) {
                    txBuilder.setSoleAttributeFromString((ArtifactId)artifact, (AttributeTypeToken)CoreAttributeTypes.WordOleData, "");
                    artChange.setChanged(true);
                    artChange.addChangedAttributeType((AttributeTypeId)CoreAttributeTypes.WordOleData);
                } else if (oleDataElement != null && singleArtifact) {
                    txBuilder.setSoleAttributeFromStream((ArtifactId)artifact, (AttributeTypeToken)CoreAttributeTypes.WordOleData, (InputStream)new ByteArrayInputStream(WordCoreUtilServer.getFormattedContent(oleDataElement)));
                    artChange.setChanged(true);
                    if (!containsOleData) {
                        artChange.setCreated(true);
                    }
                    artChange.addChangedAttributeType((AttributeTypeId)CoreAttributeTypes.WordOleData);
                }
                String content = Lib.inputStreamToString((InputStream)new ByteArrayInputStream(WordCoreUtilServer.getFormattedContent(extractorData.getParentEelement())));
                boolean hasTrackedChanges = WordCoreUtil.containsWordAnnotations((CharSequence)content);
                QueryFactory query = this.orcsApi.getQueryFactory();
                BranchId plBranch = WordMLApplicabilityHandler.getProductLineBranch(query, data.getBranch());
                HashCollection<String, String> validFeatureValues = this.getValidFeatureValuesForBranch(query, plBranch);
                HashSet<String> validConfigurations = WordMLApplicabilityHandler.getValidConfigurations(query, plBranch);
                HashSet<String> validConfigurationGroups = WordMLApplicabilityHandler.getValidConfigurationGroups(query, plBranch);
                boolean hasInvalidApplicabilityTags = WordCoreUtil.areApplicabilityTagsInvalid((String)content, (BranchId)plBranch, validFeatureValues, validConfigurations, validConfigurationGroups);
                boolean bl2 = multiSave = data.isMultiEdit() || this.hasChangedContent(artifact, content);
                if (singleArtifact || multiSave) {
                    if (!hasTrackedChanges) {
                        if (extractorData.getParentEelement().getNodeName().endsWith("body")) {
                            content = content.replace("<w:pPr><w:rPr><w:vanish/></w:rPr></w:pPr>", "");
                        }
                        LinkType linkType = LinkType.OSEE_SERVER_LINK;
                        content = WordMlLinkHandler.unlink(this.queryFactory, linkType, artifact, content);
                        txBuilder.setSoleAttributeValue((ArtifactId)artifact, (AttributeTypeToken)CoreAttributeTypes.WordTemplateContent, (Object)content);
                        artChange.setChanged(true);
                        if (!containsWordData) {
                            artChange.setCreated(true);
                        }
                        artChange.addChangedAttributeType((AttributeTypeId)CoreAttributeTypes.WordTemplateContent);
                        if (hasInvalidApplicabilityTags) {
                            updateChange.setInvalidApplicabilityTagArts(artifact.getId(), artifact.getName());
                        }
                    } else {
                        if (hasTrackedChanges) {
                            updateChange.setTrackedChangeArts(artifact.getId(), artifact.getName());
                        }
                        if (hasInvalidApplicabilityTags) {
                            updateChange.setInvalidApplicabilityTagArts(artifact.getId(), artifact.getName());
                        }
                    }
                }
                if (!artChange.isChanged()) continue;
                artChange.setSafetyRelated(this.checkIfSafetyRelated(artifact, (AttributeTypeToken)CoreAttributeTypes.LegacyDal) || this.checkIfSafetyRelated(artifact, (AttributeTypeToken)CoreAttributeTypes.IDAL));
                updateChange.addChangedArt(artChange);
                artChange.addChangedAttributeType((AttributeTypeId)CoreAttributeTypes.WordTemplateContent);
            }
            TransactionToken tx = txBuilder.commit();
            if (tx.isValid()) {
                this.postProcessChange(tx, updateChange, (ArtifactId)data.getUserArtId());
            }
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        if (!deletedArtifacts.isEmpty()) {
            throw new OseeStateException("The following deleted artifacts could not be saved [%s]", new Object[]{Collections.toString((String)",", (Iterable)deletedArtifacts)});
        }
        return updateChange;
    }

    private void postProcessChange(TransactionToken tx, WordUpdateChange updateChange, ArtifactId account) {
        updateChange.setTx((TransactionId)tx);
        updateChange.setBranch(tx.getBranch());
        if (updateChange.hasSafetyRelatedArtifactChange()) {
            // empty if block
        }
    }

    private boolean hasChangedContent(ArtifactReadable artifact, String content) {
        String originalContent = artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.WordTemplateContent, "");
        return !WordCoreUtil.textOnly((String)originalContent).equals(WordCoreUtil.textOnly((String)content)) || !WordCoreUtilServer.referencesOnly(originalContent).equals(WordCoreUtilServer.referencesOnly(content));
    }

    private boolean checkIfSafetyRelated(ArtifactReadable artifact, AttributeTypeToken dalAttrType) {
        String dal = artifact.getSoleAttributeAsString(dalAttrType, "");
        return "A".equals(dal) || "B".equals(dal) || "C".equals(dal);
    }

    private HashCollection<String, String> getValidFeatureValuesForBranch(QueryFactory query, BranchId branch) {
        List featureDefinitionData = query.applicabilityQuery().getFeatureDefinitionData(branch);
        HashCollection validFeatureValues = new HashCollection();
        for (FeatureDefinition feat : featureDefinitionData) {
            validFeatureValues.put((Object)feat.getName().toUpperCase(), (Collection)feat.getValues());
        }
        return validFeatureValues;
    }
}

