/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.define.rest.internal.TraceAccumulator;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public class TraceMatch {
    private Matcher primaryMatcher = null;
    private Matcher secondaryMatcher = null;

    public TraceMatch(String primaryRegex, String secondaryRegex) {
        if (primaryRegex == null || primaryRegex.isEmpty()) {
            throw new OseeArgumentException("invalid Primary Regular Expression", new Object[0]);
        }
        this.primaryMatcher = Pattern.compile(primaryRegex).matcher("");
        if (secondaryRegex != null && !secondaryRegex.isEmpty()) {
            this.secondaryMatcher = Pattern.compile(secondaryRegex).matcher("");
        }
    }

    public int processLine(String inProcessing, TraceAccumulator accumulator) {
        int count = 0;
        this.primaryMatcher.reset(inProcessing);
        while (this.primaryMatcher.find()) {
            String primaryMatch = this.getMatchResult(this.primaryMatcher);
            if (this.secondaryMatcher == null) {
                accumulator.addValidTrace(primaryMatch);
                ++count;
                continue;
            }
            int numFound = this.processSecondary(primaryMatch, accumulator);
            if (numFound == 0) {
                accumulator.addInvalidTrace(primaryMatch);
            }
            count += numFound;
        }
        return count;
    }

    private String getMatchResult(Matcher matcher) {
        String match;
        int groupCount = matcher.groupCount();
        if (groupCount == 0) {
            match = matcher.group(0);
        } else if (groupCount == 1) {
            match = matcher.group(1);
        } else {
            StringBuilder strB = new StringBuilder();
            int i = 1;
            while (i <= groupCount) {
                String subMatch = matcher.group(i);
                if (subMatch != null) {
                    strB.append(subMatch);
                }
                ++i;
            }
            match = strB.toString();
        }
        return match;
    }

    private int processSecondary(String primaryMatch, TraceAccumulator accumulator) {
        int count = 0;
        this.secondaryMatcher.reset(primaryMatch);
        while (this.secondaryMatcher.find()) {
            String secondaryMatch = this.getMatchResult(this.secondaryMatcher);
            accumulator.addValidTrace(secondaryMatch);
            ++count;
        }
        return count;
    }

    public String toString() {
        String primary = this.primaryMatcher.pattern().toString();
        String secondary = this.secondaryMatcher == null ? "" : this.secondaryMatcher.pattern().toString();
        return String.format("primary=[%s]  secondary=[%s]", primary, secondary);
    }
}

