/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.resolvers;

import java.util.List;
import org.eclipse.osee.define.rest.api.importing.RoughArtifact;
import org.eclipse.osee.define.rest.importing.resolvers.IRoughArtifactTranslator;
import org.eclipse.osee.define.rest.importing.resolvers.NewArtifactImportResolver;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class GuidBasedArtifactResolver
extends NewArtifactImportResolver {
    private final boolean createNewIfNotExist;

    public GuidBasedArtifactResolver(TransactionBuilder transaction, IRoughArtifactTranslator translator, ArtifactTypeToken primaryArtifactType, ArtifactTypeToken secondaryArtifactType, boolean createNewIfNotExist, boolean deleteUnmatchedArtifacts) {
        super(transaction, translator, primaryArtifactType, secondaryArtifactType);
        this.createNewIfNotExist = createNewIfNotExist;
    }

    private boolean guidsMatch(RoughArtifact roughArt, ArtifactReadable realArt) {
        String roughGuid = roughArt.getGuid();
        String realGuid = realArt.getGuid();
        return realGuid.equals(roughGuid);
    }

    @Override
    public ArtifactId resolve(RoughArtifact roughArtifact, BranchId branch, ArtifactId realParentId, ArtifactId rootId) {
        ArtifactReadable root = roughArtifact.getOrcsApi().getQueryFactory().fromBranch(branch).andId(rootId).getArtifact();
        List descendants = root.getDescendants();
        ArtifactId realArtifact = null;
        if (roughArtifact.getGuid() == null) {
            roughArtifact.getResults().warningf("Guid based resolver is comparing a null GUID. roughArtifactifact: [%s]. Attributes: [%s]", new Object[]{roughArtifact, roughArtifact.getAttributes()});
        }
        for (ArtifactReadable artifact : descendants) {
            if (!this.guidsMatch(roughArtifact, artifact)) continue;
            this.getTranslator().translate(this.transaction, roughArtifact, (ArtifactId)artifact);
            return artifact;
        }
        if (this.createNewIfNotExist) {
            realArtifact = super.resolve(roughArtifact, branch, null, rootId);
        }
        return realArtifact;
    }
}

