/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Readers;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class WordTemplateAttributeUpdater {
    public XResultData replaceAttribute(OrcsApi orcsApi, BranchId branch, XResultData results, String source, ArtifactId artToUpdate) {
        ArtifactReadable art = orcsApi.getQueryFactory().fromBranch(branch).andId(artToUpdate).asArtifact();
        AttributeId attrId = art.getSoleAttributeId((AttributeTypeToken)CoreAttributeTypes.WordTemplateContent);
        if (art.isValid()) {
            String newWordTemplateContent = this.parseContentFromFile(source, results);
            if (results.isErrors()) {
                return results;
            }
            TransactionBuilder transaction = orcsApi.getTransactionFactory().createTransaction(branch, "Replace word graphic");
            transaction.setAttributeById((ArtifactId)art, attrId, newWordTemplateContent);
            transaction.commit();
        } else {
            results.errorf("Invalid artifact id provided: %s", new Object[]{artToUpdate});
        }
        return results;
    }

    private String parseContentFromFile(String source, XResultData results) {
        StringBuilder content = new StringBuilder(2000);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader reader = Files.newBufferedReader(Paths.get(source, new String[0]));){
                if (Readers.forward((Reader)reader, (CharSequence[])new CharSequence[]{"<w:body>"}) == null) {
                    results.errorf("no start of body tag for file %s", new Object[]{source.toString()});
                }
                Readers.xmlForward((Reader)reader, (Appendable)content, (CharSequence)"w:body");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            results.errorf("exception in xml reader: %s", new Object[]{ex.toString()});
            return "";
        }
        return content.substring(0, content.length() - 9);
    }
}

