/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.util.Collection;
import org.eclipse.osee.define.rest.api.importing.IArtifactExtractor;
import org.eclipse.osee.define.rest.api.importing.IArtifactExtractorDelegate;
import org.eclipse.osee.define.rest.api.importing.RoughArtifactCollector;
import org.eclipse.osee.define.rest.api.importing.RoughRelation;
import org.eclipse.osee.define.rest.importing.parsers.RequirementTraceTableParser;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.orcs.OrcsApi;

public final class RequirementTraceTableDelegate
implements IArtifactExtractorDelegate {
    RequirementTraceTableParser parser = null;
    XResultData results = new XResultData();
    private final String relTypeName;

    public RequirementTraceTableDelegate(String relTypeName) {
        this.relTypeName = relTypeName;
    }

    public boolean isApplicable(IArtifactExtractor parser) {
        return false;
    }

    public void initialize() {
        this.parser = new RequirementTraceTableParser(2, this.results);
    }

    public void dispose() {
    }

    public String getName() {
        return "Requirement Trace Table Delegate";
    }

    public XResultData processContent(OrcsApi orcsApi, XResultData results, RoughArtifactCollector collector, boolean forceBody, boolean forcePrimaryType, String headerNumber, String listIdentifier, String paragraphStyle, String content, boolean isParagraph) {
        this.parser.handleAppendixATable(content);
        Collection<Pair<String, String>> output = this.parser.getTraces();
        if (output.size() > 0) {
            for (Pair<String, String> item : output) {
                collector.addRoughRelation(new RoughRelation(this.relTypeName, (String)item.getFirst(), (String)item.getSecond(), String.format("Add %s relation", this.relTypeName)));
            }
        }
        return results;
    }

    public void finish(OrcsApi orcsApi, XResultData results, RoughArtifactCollector collector) {
    }

    public void finish() {
    }
}

