/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.osee.define.rest.HistoryImportStrategy;
import org.eclipse.osee.define.rest.api.DefineTupleTypes;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TupleQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class FullHistoryTolerant
implements HistoryImportStrategy {
    protected final Map<String, ArtifactId> pathToCodeunitMap = new HashMap<String, ArtifactId>(10000);
    protected final Map<String, ArtifactId> pathToCodeunitReferenceMap;
    private final TupleQuery tupleQuery;
    protected final ArtifactReadable repoArtifact;
    protected final BranchId branch;
    protected final QueryFactory queryFactory;
    private final Map<String, ArtifactId> existingCodeUnitPath = new ConcurrentHashMap<String, ArtifactId>();

    public FullHistoryTolerant(ArtifactReadable repoArtifact, OrcsApi orcsApi, Map<String, ArtifactId> pathToCodeunitReferenceMap) {
        this.repoArtifact = repoArtifact;
        this.branch = repoArtifact.getBranch();
        this.queryFactory = orcsApi.getQueryFactory();
        this.tupleQuery = this.queryFactory.tupleQuery();
        this.pathToCodeunitReferenceMap = pathToCodeunitReferenceMap;
        this.initExistingCodeUnitPath();
    }

    @Override
    public ArtifactId getCodeUnit(BranchId branch, TransactionBuilder tx, String commitSHA, DiffEntry.ChangeType changeType, String path, String newPath) {
        ArtifactId codeUnit = ArtifactId.SENTINEL;
        if (changeType == DiffEntry.ChangeType.MODIFY) {
            codeUnit = this.findCodeUnit((ArtifactId)this.repoArtifact, path);
        } else if (changeType == DiffEntry.ChangeType.ADD || changeType == DiffEntry.ChangeType.COPY) {
            codeUnit = this.findCodeUnit((ArtifactId)this.repoArtifact, newPath);
            if (codeUnit.isValid()) {
                System.out.printf("commit [%s] adds code unit [%s] but found existing code unit [%s]\n", commitSHA, newPath, codeUnit);
                return ArtifactId.SENTINEL;
            }
            codeUnit = this.createCodeUnit(tx, newPath);
            this.pathToCodeunitMap.put(newPath, codeUnit);
        } else if (changeType == DiffEntry.ChangeType.DELETE) {
            codeUnit = this.findCodeUnit((ArtifactId)this.repoArtifact, path);
            if (codeUnit.isValid()) {
                tx.deleteArtifact(codeUnit);
                this.pathToCodeunitReferenceMap.remove(path);
                this.pathToCodeunitMap.remove(path);
            } else {
                System.out.printf("didn't find %s for deletion in commit %s\n", path, commitSHA);
            }
        } else if (changeType == DiffEntry.ChangeType.RENAME) {
            ArtifactId newerCodeUnit = this.findCodeUnit((ArtifactId)this.repoArtifact, newPath);
            codeUnit = this.findCodeUnit((ArtifactId)this.repoArtifact, path);
            if (newerCodeUnit.isValid()) {
                if (codeUnit.isValid()) {
                    tx.deleteArtifact(codeUnit);
                    this.pathToCodeunitReferenceMap.remove(path);
                    this.pathToCodeunitMap.remove(path);
                }
                System.out.printf("commit [%s] renames code unit [%s] to [%s] but already found existing code unit [%s]\n", commitSHA, path, newPath, newerCodeUnit);
                return ArtifactId.SENTINEL;
            }
            if (codeUnit.isValid()) {
                if (Strings.isValid((String)newPath)) {
                    tx.setName(codeUnit, this.getCodeUnitName(newPath));
                    tx.setSoleAttributeValue(codeUnit, (AttributeTypeToken)CoreAttributeTypes.FileSystemPath, (Object)newPath);
                    if (this.isPathRenamed(path, newPath)) {
                        ArtifactId location = this.editCodeUnitPath(tx, newPath, false);
                        tx.unrelateFromAll(CoreRelationTypes.DefaultHierarchical_Child, codeUnit);
                        tx.relate(location, (RelationTypeToken)CoreRelationTypes.DefaultHierarchical_Parent, codeUnit);
                    }
                    this.pathToCodeunitReferenceMap.remove(path);
                    this.pathToCodeunitMap.remove(path);
                    this.pathToCodeunitMap.put(newPath, codeUnit);
                }
            } else {
                System.out.printf("didn't find in commit [%s] for rename from [%s] to [%s]\n", commitSHA, path, newPath);
                if (Strings.isValid((String)newPath)) {
                    codeUnit = this.createCodeUnit(tx, newPath);
                    this.pathToCodeunitMap.put(newPath, codeUnit);
                }
            }
        } else {
            System.out.printf("unexpected change type [%s] on path [%s]\n", changeType, path);
        }
        return codeUnit;
    }

    @Override
    public ArtifactId findCodeUnit(ArtifactId repository, String path) {
        ArtifactId codeUnit = ArtifactId.SENTINEL;
        if (this.pathToCodeunitMap.containsKey(path)) {
            codeUnit = this.pathToCodeunitMap.get(path);
        } else if (this.pathToCodeunitReferenceMap.containsKey(path)) {
            codeUnit = this.pathToCodeunitReferenceMap.get(path);
        }
        if (codeUnit == null) {
            return ArtifactId.SENTINEL;
        }
        return codeUnit;
    }

    private void initExistingCodeUnitPath() {
        List existingFolders = this.queryFactory.fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Folder}).andRelatedRecursive(CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)this.repoArtifact).asArtifacts();
        for (ArtifactReadable art : existingFolders) {
            String wholePath = art.getName();
            ArtifactReadable parentArt = art;
            while (!parentArt.getParent().equals(this.repoArtifact) && parentArt.isValid()) {
                parentArt = parentArt.getParent();
                wholePath = String.valueOf(parentArt.getName()) + "/" + wholePath;
            }
            if (this.existingCodeUnitPath.containsKey(wholePath)) continue;
            this.existingCodeUnitPath.put(wholePath, (ArtifactId)art);
        }
    }

    private ArtifactId createCodeUnit(TransactionBuilder tx, String newPath) {
        return this.editCodeUnitPath(tx, newPath, true);
    }

    private ArtifactId editCodeUnitPath(TransactionBuilder tx, String newPath, boolean newCodeUnit) {
        ArtifactReadable folder = this.repoArtifact;
        String codeUnitName = "";
        String wholePath = "";
        ArrayList path = Lists.newArrayList((Iterable)Splitter.on((String)"/").split((CharSequence)newPath));
        if (path.size() <= 0) {
            return ArtifactId.SENTINEL;
        }
        codeUnitName = this.getCodeUnitName(newPath);
        path.remove(path.size() - 1);
        for (String newFolder : path) {
            if (!this.existingCodeUnitPath.containsKey(wholePath = String.valueOf(wholePath) + newFolder)) {
                folder = tx.createArtifact((ArtifactId)folder, CoreArtifactTypes.Folder, newFolder);
                this.existingCodeUnitPath.put(wholePath, (ArtifactId)folder);
            } else {
                folder = this.existingCodeUnitPath.get(wholePath);
            }
            wholePath = String.valueOf(wholePath) + "/";
        }
        if (newCodeUnit) {
            ArtifactToken codeUnit = tx.createArtifact((ArtifactId)folder, CoreArtifactTypes.CodeUnit, codeUnitName);
            tx.setSoleAttributeFromString((ArtifactId)codeUnit, (AttributeTypeToken)CoreAttributeTypes.FileSystemPath, newPath);
            return codeUnit;
        }
        return folder;
    }

    private boolean isPathRenamed(String path, String newPath) {
        return path.contains("/") && newPath.contains("/") && !path.substring(0, path.lastIndexOf("/")).equals(newPath.substring(0, newPath.lastIndexOf("/")));
    }

    private String getCodeUnitName(String newPath) {
        String codeUnitName = "";
        ArrayList path = Lists.newArrayList((Iterable)Splitter.on((String)"/").split((CharSequence)newPath));
        codeUnitName = (String)path.get(path.size() - 1);
        return codeUnitName;
    }

    @Override
    public void handleCodeUnit(BranchId branch, ArtifactId codeUnit, TransactionBuilder tx, ArtifactId repository, ArtifactId commit, DiffEntry.ChangeType changeType, String path) {
        tx.addTuple4(DefineTupleTypes.GitCommitFile, (Object)repository, (Object)codeUnit, (Object)commit, (Object)changeType);
        ArtifactId[] commitWraper = new ArtifactId[]{ArtifactId.SENTINEL};
        this.tupleQuery.getTuple4E3E4FromE1E2(DefineTupleTypes.GitLatest, branch, (Object)repository, (Object)codeUnit, (ignore, baselineCommit) -> {
            ArtifactId artifactId = baselineCommit;
        });
        tx.deleteTuple4ByE1E2(DefineTupleTypes.GitLatest, (Object)repository, (Object)codeUnit);
        tx.addTuple4(DefineTupleTypes.GitLatest, (Object)repository, (Object)codeUnit, (Object)commit, (Object)commitWraper[0]);
    }

    @Override
    public TransactionBuilder getTransactionBuilder(OrcsApi orcsApi, BranchId branch) {
        return orcsApi.getTransactionFactory().createTransaction(branch, "TraceabilityOperationsImpl.parseGitHistory repo [" + this.repoArtifact.getIdString() + "]");
    }

    @Override
    public void finishGitCommit(TransactionBuilder tx) {
        tx.commit();
    }

    @Override
    public TransactionToken finishImport() {
        return TransactionToken.SENTINEL;
    }

    @Override
    public boolean hasChangeIdAlredyImported(String changeId) {
        return this.queryFactory.fromBranch(this.branch).and((AttributeTypeToken)CoreAttributeTypes.GitChangeId, changeId, new QueryOption[0]).exists();
    }
}

