/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.define.operations.synchronization.BadDocumentRootException;
import org.eclipse.osee.define.operations.synchronization.Direction;
import org.eclipse.osee.define.operations.synchronization.SynchronizationArtifactBuilder;
import org.eclipse.osee.define.rest.api.synchronization.Root;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.MultipleItemsExist;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.eclipse.osee.orcs.OrcsApi;

public class RootList
implements Iterable<ArtifactReadable>,
ToMessage {
    private List<ArtifactReadable> artifactReadableRoots;
    private final Direction direction;
    private final OrcsApi orcsApi;
    private final OrcsTokenService orcsTokenService;
    private final List<Root> rootsList;
    private final SynchronizationArtifactBuilder synchronizationArtifactBuilder;

    private RootList(OrcsApi orcsApi, Direction direction, SynchronizationArtifactBuilder synchronizationArtifactBuilder) {
        this.orcsApi = orcsApi;
        this.orcsTokenService = orcsApi.tokenService();
        this.direction = direction;
        this.synchronizationArtifactBuilder = synchronizationArtifactBuilder;
        this.rootsList = new ArrayList<Root>();
        this.artifactReadableRoots = null;
    }

    public static RootList create(OrcsApi orcsApi, Direction direction, SynchronizationArtifactBuilder synchronizationArtifactBuilder) {
        Objects.requireNonNull(orcsApi, "RootList::create, parameter \"orcsApi\" is null.");
        Objects.requireNonNull(orcsApi.tokenService(), "SynchronizationArtifact::create, Failed to initialize ORCS Token Service is null.");
        Objects.requireNonNull(direction, "RootList::create, parameter \"direction\" is null.");
        Objects.requireNonNull(synchronizationArtifactBuilder, "RootList::create, parameter \"synchronizationArtifactBuilder\" is null.");
        return new RootList(orcsApi, direction, synchronizationArtifactBuilder);
    }

    public void add(Root root) {
        if (Objects.nonNull(this.artifactReadableRoots)) {
            throw new IllegalStateException("Attempt to add an additional document root after the list has been validated.\n");
        }
        this.rootsList.add(root);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    public OrcsTokenService getOrcsTokenService() {
        return this.orcsTokenService;
    }

    public SynchronizationArtifactBuilder getSynchronizationArtifactBuilder() {
        return this.synchronizationArtifactBuilder;
    }

    @Override
    public Iterator<ArtifactReadable> iterator() {
        if (Objects.isNull(this.artifactReadableRoots)) {
            throw new IllegalStateException("Attempt to iterate the RootList before Conditions.\n");
        }
        return this.artifactReadableRoots.iterator();
    }

    public Stream<ArtifactReadable> stream() {
        if (Objects.isNull(this.artifactReadableRoots)) {
            throw new IllegalStateException("Attempt to iterate the RootList before Conditions.\n");
        }
        return this.artifactReadableRoots.stream();
    }

    private ArtifactReadable validateRoot(Root root, Message message) {
        try {
            ResultSet artifactReadableSet = this.orcsApi.getQueryFactory().fromBranch(root.getBranchId()).andId(root.getArtifactId()).getResults();
            return (ArtifactReadable)artifactReadableSet.getExactlyOne();
        }
        catch (ItemDoesNotExist | MultipleItemsExist e) {
            message.title((CharSequence)"The document root is not a valid OSEE Artifact.").blank();
            root.toMessage(1, message);
            message.blank().title((CharSequence)"Reason").indentInc().block((CharSequence)e.getMessage()).indentDec();
            return null;
        }
        catch (Exception e) {
            Message eMessage = new Message().title((CharSequence)"RootList::validateRoot, Failed to build ORCS query for document root.").blank();
            root.toMessage(1, eMessage);
            throw new Error(eMessage.toString(), e);
        }
    }

    public void validate() {
        if (Objects.nonNull(this.artifactReadableRoots)) {
            throw new IllegalStateException("Attempt to validate a RootList that has already been validated.\n");
        }
        Message message = null;
        Conditions.requireNonNull(message, (Object)this.orcsApi, (Conditions.ValueType)Conditions.ValueType.MEMBER, (String)"orcsApi");
        Conditions.requireNonNull(message, (Object)this.orcsTokenService, (Conditions.ValueType)Conditions.ValueType.MEMBER, (String)"orcsTokenService");
        Conditions.requireNonNull(message, (Object)((Object)this.direction), (Conditions.ValueType)Conditions.ValueType.MEMBER, (String)"direction");
        Conditions.requireNonNull(message, (Object)this.synchronizationArtifactBuilder, (Conditions.ValueType)Conditions.ValueType.MEMBER, (String)"synchronizationArtifactBuilder");
        if (Objects.nonNull(message)) {
            throw new IllegalArgumentException(Conditions.buildIllegalArgumentExceptionMessage((String)this.getClass().getSimpleName(), (String)"validate", message));
        }
        Message validationMessage = new Message();
        this.artifactReadableRoots = this.rootsList.stream().map(root -> this.validateRoot((Root)root, validationMessage)).filter(Objects::nonNull).collect(Collectors.toList());
        if (!validationMessage.isEmpty()) {
            throw new BadDocumentRootException(this.direction, validationMessage.toString());
        }
    }

    public StringBuilder toText(StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        boolean first = true;
        this.rootsList.stream().forEach(root -> {
            if (!first) {
                outMessage.append(", ");
            }
            root.toText(outMessage);
        });
        return outMessage;
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = message != null ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Root List").indentInc().segmentIndexed((CharSequence)"Roots List", this.rootsList).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

