/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publisher.templatemanager;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.define.operations.publisher.templatemanager.PublishingTemplate;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateKeyGroups;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateKeyType;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateScalarKey;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateVectorKey;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.publishing.Cause;
import org.eclipse.osee.framework.core.publishing.DataAccessOperations;
import org.eclipse.osee.framework.core.publishing.IncludeDeleted;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.RankHashMap;
import org.eclipse.osee.framework.jdk.core.util.RankMap;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.eclipse.osee.logger.Log;

class PublishingTemplateCache {
    private static PublishingTemplateCache publishingTemplateCache = null;
    private final DataAccessOperations dataAccessOperations;
    protected RankMap<List<PublishingTemplate>> keyMap;
    private List<PublishingTemplate> list;
    protected Log logger;
    private final OrcsTokenService orcsTokenService;

    static synchronized PublishingTemplateCache create(Log logger, DataAccessOperations dataAccessOperations, OrcsTokenService orcsTokenService) {
        return Objects.isNull(publishingTemplateCache) ? (publishingTemplateCache = new PublishingTemplateCache(Objects.requireNonNull(logger), Objects.requireNonNull(dataAccessOperations), Objects.requireNonNull(orcsTokenService))) : publishingTemplateCache;
    }

    static synchronized void free() {
        publishingTemplateCache = null;
    }

    private PublishingTemplateCache(Log logger, DataAccessOperations dataAccessOperations, OrcsTokenService orcsTokenService) {
        this.logger = logger;
        this.dataAccessOperations = dataAccessOperations;
        this.orcsTokenService = orcsTokenService;
        this.deleteCache();
    }

    private void addToKeyMap(PublishingTemplate publishingTemplateInternal) {
        PublishingTemplateKeyType[] publishingTemplateKeyTypeArray = PublishingTemplateKeyType.values();
        int n = publishingTemplateKeyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PublishingTemplateKeyType primaryKey = publishingTemplateKeyTypeArray[n2];
            Iterable<PublishingTemplateScalarKey> secondaryKeyIterable = publishingTemplateInternal.getKeyIterable(primaryKey);
            for (PublishingTemplateScalarKey secondaryKey : secondaryKeyIterable) {
                this.keyMap.get(new Object[]{primaryKey, secondaryKey}).ifPresentOrElse(publishingTemplateInternalList -> {
                    boolean bl = publishingTemplateInternalList.add(publishingTemplateInternal);
                }, () -> {
                    ArrayList<PublishingTemplate> publishingTemplateInternalList = new ArrayList<PublishingTemplate>();
                    publishingTemplateInternalList.add(publishingTemplateInternal);
                    this.keyMap.associate(publishingTemplateInternalList, new Object[]{primaryKey, secondaryKey});
                });
            }
            ++n2;
        }
    }

    private synchronized void cacheTemplates() {
        RankHashMap keyMap;
        if (this.isCacheLoaded()) {
            return;
        }
        this.list = this.loadTemplates();
        this.keyMap = keyMap = new RankHashMap("KeyMap", 2, 256, 0.75f, new Predicate[]{o -> o instanceof PublishingTemplateKeyType, o -> o instanceof PublishingTemplateScalarKey || o instanceof PublishingTemplateVectorKey});
        this.list.stream().forEach(this::addToKeyMap);
        this.sortMatchCritera();
        this.logDuplicates();
    }

    Optional<PublishingTemplate> createPublishingTemplate(@NonNull ArtifactReadable artifactReadable) {
        PublishingTemplate publishingTemplate = (PublishingTemplate)PublishingTemplate.create(this.orcsTokenService, artifactReadable).getFirstIfPresentOthers(string -> this.logger.error(string, new Object[0]));
        return Optional.ofNullable(publishingTemplate);
    }

    public void deleteCache() {
        this.keyMap = null;
        this.list = null;
    }

    public Optional<PublishingTemplate> findFirstTemplate(PublishingTemplateKeyType key, String identifier) {
        this.loadCacheIfNeeded();
        if (Objects.isNull(key) || Objects.isNull(identifier)) {
            return Optional.empty();
        }
        Optional<PublishingTemplate> firstTemplate = this.keyMap.get(new Object[]{key, new PublishingTemplateScalarKey(identifier, key)}).map(templateList -> templateList.size() > 0 ? (PublishingTemplate)templateList.get(0) : null);
        return firstTemplate;
    }

    public Optional<PublishingTemplate> findFirstTemplateByMatchCriteria(List<String> matchCriteria) {
        this.loadCacheIfNeeded();
        Optional<PublishingTemplate> firstTemplate = matchCriteria.stream().map(matchCriterionString -> new PublishingTemplateScalarKey(matchCriterionString, PublishingTemplateKeyType.MATCH_CRITERIA)).map(matchCriterionKey -> this.keyMap.get(new Object[]{PublishingTemplateKeyType.MATCH_CRITERIA, matchCriterionKey})).filter(Optional::isPresent).map(Optional::get).findFirst().map(publishingTemplateInternalList -> publishingTemplateInternalList.isEmpty() ? null : (PublishingTemplate)publishingTemplateInternalList.get(0));
        return firstTemplate;
    }

    public PublishingTemplateKeyGroups getPublishingTemplateKeyGroups() {
        this.loadCacheIfNeeded();
        List publishingTemplateKeyGroupList = this.list.stream().map(PublishingTemplate::getPublishingTemplateKeyGroup).collect(Collectors.toUnmodifiableList());
        return new PublishingTemplateKeyGroups(publishingTemplateKeyGroupList);
    }

    protected boolean isCacheLoaded() {
        return Objects.nonNull(this.keyMap);
    }

    protected void loadCacheIfNeeded() {
        if (!this.isCacheLoaded()) {
            this.cacheTemplates();
        }
    }

    public synchronized List<PublishingTemplate> loadTemplates() {
        return ((List)this.dataAccessOperations.getArtifactReadables(new BranchSpecification((BranchId)CoreBranches.COMMON), List.of(), List.of(), "", CoreArtifactTypes.RendererTemplateWholeWord, TransactionId.SENTINEL, IncludeDeleted.NO).orElseThrow(exception -> {
            Cause cause = exception.getPublishingUtilCause();
            String message = new Message().title((CharSequence)"PublishingTemplateCache::loadTemplates, no Publishing Templates found.").indentInc().segment((CharSequence)"Query Result", (Object)cause).reasonFollows((Throwable)exception).toString();
            return new OseeCoreException(message, (Throwable)exception);
        })).stream().map(artifactReadable -> (Optional)Conditions.applyWhenNonNull((Object)artifactReadable, a -> this.createPublishingTemplate((ArtifactReadable)a))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toUnmodifiableList());
    }

    private void logDuplicates() {
        this.keyMap.streamEntries(new Object[0]).filter(entry -> ((List)entry.getValue()).size() > 1).forEach(entry -> {
            if (!this.logger.isInfoEnabled()) {
                return;
            }
            PublishingTemplateKeyType primaryKey = (PublishingTemplateKeyType)entry.getKey(0);
            Object secondaryKey = entry.getKey(1);
            List publishingTemplateInternalList = (List)entry.getValue();
            PublishingTemplateScalarKey primaryTemplateName = ((PublishingTemplate)publishingTemplateInternalList.get(0)).getName();
            PublishingTemplateScalarKey primaryTemplateIdentifier = ((PublishingTemplate)publishingTemplateInternalList.get(0)).getIdentifier();
            Message message = new Message().blank().title((CharSequence)"PublishingTemplateProvider has detected a conflict.").indentInc().segment((CharSequence)"Key Type", (Object)primaryKey).segment((CharSequence)"Publishing Template Key", secondaryKey).title((CharSequence)"The Publishing Template That Will Be Used").indentInc().segment((CharSequence)"Name", (Object)primaryTemplateName).segment((CharSequence)"Identifier", (Object)primaryTemplateIdentifier).indentDec().title((CharSequence)"All Matching Templates").indentInc();
            publishingTemplateInternalList.forEach(publishingTemplate -> {
                Message message2 = message.title((CharSequence)publishingTemplate.getName().toString()).indentInc().segment((CharSequence)"Identifier", (Object)publishingTemplate.getIdentifier()).segmentToMessage((CharSequence)"Match Criteria", (ToMessage)publishingTemplate.getMatchCriteria()).indentDec();
            });
            this.logger.infoNoFormat(null, (CharSequence)message.toString());
        });
    }

    private void sortMatchCritera() {
        this.keyMap.stream(new Object[0]).filter(publishingTemplateInternalList -> publishingTemplateInternalList.size() > 1).forEach(publishingTemplateInternalList -> publishingTemplateInternalList.sort(new Comparator<PublishingTemplate>(){

            @Override
            public int compare(PublishingTemplate o1, PublishingTemplate o2) {
                return o1.getName().compareTo(o2.getName());
            }
        }));
    }
}

