/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publisher.templatemanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateKeyGroup;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateKeyType;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateScalarKey;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateVectorKey;
import org.eclipse.osee.define.util.AttributeUtils;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.framework.core.exception.MultipleAttributesExist;
import org.eclipse.osee.framework.core.publishing.FormatIndicator;
import org.eclipse.osee.framework.core.publishing.InvalidPublishOptionsException;
import org.eclipse.osee.framework.core.publishing.OutliningOptions;
import org.eclipse.osee.framework.core.publishing.PublishOptions;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.core.publishing.relation.table.RelationTableOptions;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Collectors;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

class PublishingTemplate
implements ToMessage {
    private final @NonNull ArtifactReadable artifactReadable;
    private final @NonNull PublishingTemplateScalarKey identifier;
    private final @NonNull EnumMap<PublishingTemplateKeyType, Iterable<PublishingTemplateScalarKey>> keyExtractors;
    private final @NonNull PublishingTemplateVectorKey matchCriteria;
    private final @NonNull PublishingTemplateScalarKey name;
    private final @NonNull PublishOptions publishOptions;
    private final @NonNull PublishingTemplateScalarKey safeName;
    private final @Nullable String status;
    private final @NonNull Map<FormatIndicator, String> templateContentMap;
    private final @NonNull RelationTableOptions relationTableOptions;

    private static @NonNull Pair<@NonNull PublishingTemplateVectorKey, @Nullable Message> buildTemplateMatchCriteriaList(@NonNull ArtifactReadable artifactReadable) {
        try {
            List matchCriteriaObjectList = artifactReadable.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria);
            List matchCriteriaList = matchCriteriaObjectList.stream().map(matchCriteria -> new PublishingTemplateScalarKey(matchCriteria.toString(), PublishingTemplateKeyType.MATCH_CRITERIA)).collect(java.util.stream.Collectors.toUnmodifiableList());
            PublishingTemplateVectorKey vectorKey = new PublishingTemplateVectorKey(matchCriteriaList);
            return Pair.createNullableImmutable((Object)vectorKey, null);
        }
        catch (Exception e) {
            Message message = new Message().title((CharSequence)"Failed to build the Match Criteria list.").reasonFollows((Throwable)e);
            PublishingTemplateVectorKey vectorKey = new PublishingTemplateVectorKey(List.of());
            return Pair.createNullableImmutable((Object)vectorKey, (Object)message);
        }
    }

    static @NonNull Pair<@NonNull PublishingTemplate, @Nullable String> create(OrcsTokenService orcsTokenService, @NonNull ArtifactReadable artifactReadable) {
        String templateContent;
        Conditions.requireNonNull((Object)artifactReadable, (String)"artifactReadable");
        Message message = new Message();
        PublishingTemplateScalarKey identifier = new PublishingTemplateScalarKey("AT-" + artifactReadable.getIdString(), PublishingTemplateKeyType.IDENTIFIER);
        PublishingTemplateVectorKey matchCriteria = (PublishingTemplateVectorKey)PublishingTemplate.buildTemplateMatchCriteriaList(artifactReadable).getFirstNonNullIfPresentOthers(arg_0 -> ((Message)message).copy(arg_0));
        PublishingTemplateScalarKey name = new PublishingTemplateScalarKey(artifactReadable.getName(), PublishingTemplateKeyType.NAME);
        PublishingTemplateScalarKey safeName = new PublishingTemplateScalarKey(artifactReadable.getSafeName(), PublishingTemplateKeyType.SAFE_NAME);
        PublishOptions publishOptions = (PublishOptions)PublishingTemplate.loadPublishOptions(orcsTokenService, artifactReadable, identifier.getKey(), name.getKey()).getFirstNonNullIfPresentOthers(arg_0 -> ((Message)message).copy(arg_0));
        Map templateContentMap = (Map)PublishingTemplate.loadTemplateContentMap(artifactReadable).getFirstNonNullIfPresentOthers(arg_0 -> ((Message)message).copy(arg_0));
        if (!templateContentMap.containsKey(FormatIndicator.WORD_ML)) {
            PublishingTemplate.loadLegacyWordMlTemplateContent(artifactReadable).ifPresent(content -> {
                String string = templateContentMap.put(FormatIndicator.WORD_ML, content);
            }, arg_0 -> ((Message)message).copy(arg_0));
        }
        if ((templateContent = (String)templateContentMap.get(FormatIndicator.WORD_ML)) != null) {
            PublishingTemplate.updateWithAlternateStyles(artifactReadable, templateContent).ifPresent(templateContentWithAlternateStyles -> {
                String string = templateContentMap.put(FormatIndicator.WORD_ML, templateContentWithAlternateStyles.toString());
            }, arg_0 -> ((Message)message).copy(arg_0));
        }
        if (templateContentMap.isEmpty()) {
            message.title((CharSequence)"PublishingTemplate::create, publishing template does not have content for any format. Add/fill a content map attribute on the template artifact.").indentInc().segment((CharSequence)"Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Artifact Name", (Object)artifactReadable.getName());
        }
        List relationTableArtTypeNamesAndOrIds = (List)PublishingTemplate.loadRelationTableArtifactTypeNamesAndOrIds(artifactReadable, orcsTokenService).getFirstNonNullIfPresentOthers(arg_0 -> ((Message)message).copy(arg_0));
        List relationTableColumns = (List)PublishingTemplate.loadRelationTableColumns(artifactReadable, orcsTokenService).getFirstNonNullIfPresentOthers(arg_0 -> ((Message)message).copy(arg_0));
        List relationTableRelationSides = (List)PublishingTemplate.loadRelationTableRelationTypeSides(artifactReadable, orcsTokenService).getFirstNonNullIfPresentOthers(arg_0 -> ((Message)message).copy(arg_0));
        RelationTableOptions relationTableOptions = new RelationTableOptions(relationTableArtTypeNamesAndOrIds, relationTableColumns, relationTableRelationSides);
        String messageString = message.isEmpty() ? null : message.toString();
        PublishingTemplate publishingTemplate = new PublishingTemplate(artifactReadable, identifier, matchCriteria, name, publishOptions, safeName, templateContentMap, messageString, relationTableOptions);
        return new Pair((Object)publishingTemplate, (Object)messageString);
    }

    private static @NonNull Pair<@Nullable String, @Nullable Message> loadLegacyWordMlTemplateContent(ArtifactReadable artifactReadable) {
        try {
            String wholeWordContent = artifactReadable.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.WholeWordContent);
            if (wholeWordContent == null) {
                return Pair.empty();
            }
            Message message = FormatIndicator.WORD_ML.validatePublishingTemplateContent(wholeWordContent);
            return Objects.isNull(message) ? Pair.createNullableImmutable((Object)wholeWordContent, null) : Pair.createNullableImmutable(null, (Object)message);
        }
        catch (MultipleAttributesExist e) {
            Message message = new Message().title((CharSequence)"PublishingTemplate::create, failed to obtain publish options from the publishing template artifact.").indentInc().segment((CharSequence)"Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Artifact Name", (Object)artifactReadable.getName()).indentDec().reasonFollows((Throwable)e);
            return Pair.createNullableImmutable(null, (Object)message);
        }
        catch (AttributeDoesNotExist attributeDoesNotExist) {
            return Pair.empty();
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @NonNull Pair<@NonNull PublishOptions, @Nullable Message> loadPublishOptions(OrcsTokenService orcsTokenService, ArtifactReadable artifactReadable, String templateIdentifier, String templateName) {
        try {
            String headingAttributeTypeTokenName;
            String headingArtifactTypeTokenName;
            PublishOptions publishOptions = PublishOptions.create((String)artifactReadable.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.RendererOptions));
            publishOptions.defaults();
            OutliningOptions[] outliningOptionsArray = publishOptions.getOutliningOptions();
            if (outliningOptionsArray.length != 1) {
                if (outliningOptionsArray.length <= 1) return Pair.createNullableImmutable((Object)publishOptions, null);
                Message message = new Message().title((CharSequence)"PublishingTemplate::create, publish options array should not contain more than one entry.").indentInc().segment((CharSequence)"Publish Options", (Object)publishOptions);
                return Pair.createNullableImmutable((Object)new PublishOptions().defaults(), (Object)message);
            }
            OutliningOptions outliningOptions = outliningOptionsArray[0];
            switch (headingArtifactTypeTokenName = outliningOptions.getHeadingArtifactType()) {
                default: {
                    try {
                        orcsTokenService.getArtifactType(headingArtifactTypeTokenName);
                        break;
                    }
                    catch (Exception e) {
                        Message message = new Message().title((CharSequence)"PublishingTemplate::create, outlining options heading artifact type name not found.").indentInc().segment((CharSequence)"Heading Artifact Type Name", (Object)headingArtifactTypeTokenName).indentDec().reasonFollowsWithTrace((Throwable)e);
                        return Pair.createNullableImmutable((Object)new PublishOptions().defaults(), (Object)message);
                    }
                }
                case "<format-heading-artifact-type>": 
                case "<folders-only-heading-artifact-type>": 
                case "<headers-only-heading-artifact-type>": 
                case "<any-heading-artifact-type>": 
                case "<folders-and-headers-only-heading-artifact-type>": 
            }
            switch (headingAttributeTypeTokenName = outliningOptions.getHeadingAttributeType()) {
                default: {
                    try {
                        orcsTokenService.getAttributeType(headingAttributeTypeTokenName);
                        return Pair.createNullableImmutable((Object)publishOptions, null);
                    }
                    catch (Exception e) {
                        Message message = new Message().title((CharSequence)"PublishingTemplate::create, outlining options heading content attribute type name not found.").indentInc().segment((CharSequence)"Heading Arttribute Type Name", (Object)headingAttributeTypeTokenName).indentDec().reasonFollowsWithTrace((Throwable)e);
                        return Pair.createNullableImmutable((Object)new PublishOptions().defaults(), (Object)message);
                    }
                }
                case "<format-heading-attribute-type>": 
            }
            return Pair.createNullableImmutable((Object)publishOptions, null);
        }
        catch (InvalidPublishOptionsException e) {
            e.setPublishingTemplateInformation(artifactReadable.getIdString(), artifactReadable.getName());
            Throwable cause = e.getCause();
            Message message = new Message().block((CharSequence)e.getMessage()).reasonFollowsIfNonNull(cause);
            return Pair.createNullableImmutable((Object)new PublishOptions().defaults(), (Object)message);
        }
        catch (MultipleAttributesExist e) {
            Message message = new Message().title((CharSequence)"PublishingTemplate::create, failed to obtain publish options from the publishing template artifact.").indentInc().segment((CharSequence)"Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Artifact Name", (Object)artifactReadable.getName()).indentDec().reasonFollows((Throwable)e);
            return Pair.createNullableImmutable((Object)new PublishOptions().defaults(), (Object)message);
        }
        catch (AttributeDoesNotExist attributeDoesNotExist) {
            return Pair.createNullableImmutable((Object)new PublishOptions().defaults(), null);
        }
    }

    private static Pair<@NonNull Map<FormatIndicator, String>, @Nullable Message> loadTemplateContentMap(@NonNull ArtifactReadable artifactReadable) {
        Message outMessage = new Message();
        Map templateContentMap = (Map)AttributeUtils.getMapEntryAttributeValues(artifactReadable, (AttributeTypeToken)CoreAttributeTypes.PublishingTemplateContentByFormatMapEntry).stream().filter(mapEntry -> {
            String key = (String)mapEntry.getKey();
            return Objects.nonNull(key) && !key.isBlank();
        }).collect(Collectors.toMap(() -> new EnumMap(FormatIndicator.class), formatName -> (FormatIndicator)Conditions.requireNonNull((Object)((FormatIndicator)FormatIndicator.ofFormatName((String)formatName).get())), (Function)((Function)Conditions.requireNonNull(Function.identity())), (format, content) -> {
            if (content == null) {
                return false;
            }
            Message message2 = format.validatePublishingTemplateContent(content);
            if (Objects.nonNull(message2)) {
                outMessage.copy(message2);
                return false;
            }
            return true;
        }));
        return Pair.createNullableImmutable((Object)templateContentMap, (Object)(outMessage.isModified() ? outMessage : null));
    }

    private static Pair<@NonNull List<String>, @Nullable Message> loadRelationTableRelationTypeSides(@NonNull ArtifactReadable artifactReadable, OrcsTokenService orcsTokenService) {
        Message outMessage = new Message();
        ArrayList<String> relationTableRelationTypeSides = new ArrayList<String>();
        try {
            List relationTypeSides = artifactReadable.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.PublishingRelationTableRelationTypeSide);
            for (String relationTypeSide : relationTypeSides) {
                String[] parts = relationTypeSide.split("\\|", 2);
                if (parts.length != 2) {
                    outMessage.title((CharSequence)("PublishingTemplate::create, invalid format in relation table relation type side list entry: \"" + relationTypeSide + "\". Entry does not contain exactly one delimiter (\"|\").")).indentInc().segment((CharSequence)"Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Artifact Name", (Object)artifactReadable.getName()).indentDec();
                    return Pair.createNullableImmutable(Collections.emptyList(), (Object)outMessage);
                }
                String relationTypeNameOrId = parts[0].trim();
                String relationTypeSideName = parts[1].trim();
                if (Objects.nonNull(relationTypeNameOrId) && !relationTypeNameOrId.isBlank()) {
                    if (Objects.isNull(relationTypeSideName) || relationTypeSideName.isBlank()) {
                        outMessage.title((CharSequence)("PublishingTemplate::create, relation table relation type side name is null or blank. Please populate the relation type side name for: \"" + relationTypeNameOrId + "\" (the right side of the \"" + relationTypeNameOrId + "|\").")).indentInc().segment((CharSequence)"Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Artifact Name", (Object)artifactReadable.getName());
                        return Pair.createNullableImmutable(Collections.emptyList(), (Object)outMessage);
                    }
                    try {
                        if (Strings.isLong((String)relationTypeNameOrId)) {
                            Long relTypeId = Long.parseLong(relationTypeNameOrId);
                            orcsTokenService.getRelationType(relTypeId);
                        } else {
                            orcsTokenService.getRelationType(relationTypeNameOrId);
                        }
                        relationTableRelationTypeSides.add(relationTypeSide);
                        continue;
                    }
                    catch (Exception e) {
                        outMessage.title((CharSequence)("PublishingTemplate::create, failed for checking whether relation type exists. Error for relationTypeNameOrId (the left side of \"|\"): \"" + relationTypeNameOrId + "\"")).indentInc().segment((CharSequence)"Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Artifact Name", (Object)artifactReadable.getName()).indentDec().reasonFollows((Throwable)e);
                        return Pair.createNullableImmutable(Collections.emptyList(), (Object)outMessage);
                    }
                }
                outMessage.title((CharSequence)"PublishingTemplate::create, relation table relation type name or id is null or blank. Please populate the relation type name or id (the left side of the \"|\").").indentInc().segment((CharSequence)"Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Artifact Name", (Object)artifactReadable.getName());
                return Pair.createNullableImmutable(Collections.emptyList(), (Object)outMessage);
            }
        }
        catch (Exception e) {
            outMessage.title((CharSequence)"PublishingTemplate::create, failed to process relation table relation type-side list.").indentInc().segment((CharSequence)"Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Artifact Name", (Object)artifactReadable.getName()).indentDec().reasonFollows((Throwable)e);
            return Pair.createNullableImmutable(Collections.emptyList(), (Object)outMessage);
        }
        return Pair.createNullableImmutable(relationTableRelationTypeSides, (Object)(outMessage.isModified() ? outMessage : null));
    }

    private static @NonNull Pair<@NonNull List<String>, @Nullable Message> loadRelationTableArtifactTypeNamesAndOrIds(@NonNull ArtifactReadable artifactReadable, OrcsTokenService orcsTokenService) {
        ArrayList<String> validArtifactTypeNamesOrIds = new ArrayList<String>();
        Message outMessage = new Message();
        List tempRelationTableArtTypeNamesAndOrIds = artifactReadable.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.PublishingRelationTableArtifactTypeNameOrId);
        if (tempRelationTableArtTypeNamesAndOrIds != null) {
            for (String nameOrId : tempRelationTableArtTypeNamesAndOrIds) {
                try {
                    if (Strings.isLong((String)nameOrId)) {
                        Long artTypeId = Long.parseLong(nameOrId);
                        orcsTokenService.getArtifactType(artTypeId);
                    } else {
                        orcsTokenService.getArtifactType(nameOrId);
                    }
                    validArtifactTypeNamesOrIds.add(nameOrId);
                }
                catch (Exception e) {
                    outMessage.title((CharSequence)("PublishingTemplate::create, failed for checking whether relation table artifact type exists. Error for artifactTypeNameOrID: \"" + nameOrId + "\"")).indentInc().segment((CharSequence)"Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Artifact Name", (Object)artifactReadable.getName()).indentDec().reasonFollows((Throwable)e);
                    return Pair.createNullableImmutable(new ArrayList(), (Object)outMessage);
                }
            }
        }
        return Pair.createNullableImmutable(validArtifactTypeNamesOrIds, (Object)(outMessage.isModified() ? outMessage : null));
    }

    private static @NonNull Pair<@NonNull List<String>, @Nullable Message> loadRelationTableColumns(@NonNull ArtifactReadable artifactReadable, OrcsTokenService orcsTokenService) {
        ArrayList<String> validColumns = new ArrayList<String>();
        Message outMessage = new Message();
        List tempRelationTableColumns = artifactReadable.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.PublishingRelationTableColumn);
        if (tempRelationTableColumns != null) {
            for (String relTabColumnOrAttributeType : tempRelationTableColumns) {
                try {
                    if (RelationTableOptions.isDefinedColumn((String)relTabColumnOrAttributeType)) {
                        validColumns.add(relTabColumnOrAttributeType);
                        continue;
                    }
                    if (Strings.isLong((String)relTabColumnOrAttributeType)) {
                        Long attrTypeId = Long.parseLong(relTabColumnOrAttributeType);
                        orcsTokenService.getAttributeType(attrTypeId);
                    } else {
                        orcsTokenService.getAttributeType(relTabColumnOrAttributeType);
                    }
                    validColumns.add(relTabColumnOrAttributeType);
                }
                catch (Exception e) {
                    outMessage.title((CharSequence)("PublishingTemplate::create, failed for checking whether relation table column exists. Error for column name: \"" + relTabColumnOrAttributeType + "\"")).indentInc().segment((CharSequence)"Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Artifact Name", (Object)artifactReadable.getName()).indentDec().reasonFollows((Throwable)e);
                    return Pair.createNullableImmutable(new ArrayList(), (Object)outMessage);
                }
            }
        }
        return Pair.createNullableImmutable(validColumns, (Object)(outMessage.isModified() ? outMessage : null));
    }

    private static Pair<CharSequence, Message> updateWithAlternateStyles(@NonNull ArtifactReadable artifactReadable, @NonNull CharSequence templateContentWordMl) {
        String styles;
        List templateRelatedArtifacts;
        try {
            templateRelatedArtifacts = artifactReadable.getRelated(CoreRelationTypes.SupportingInfo_SupportingInfo).getList();
        }
        catch (Exception e) {
            Message message = new Message().title((CharSequence)"PublishingTemplate::updateWithAlternateStyles, failed to follow supporting info relationship.").indentInc().segment((CharSequence)"Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Artifact Name", (Object)artifactReadable.getName()).indentDec().reasonFollows((Throwable)e);
            return Pair.createNullableImmutable(null, (Object)message);
        }
        if (templateRelatedArtifacts.isEmpty()) {
            return Pair.empty();
        }
        if (templateRelatedArtifacts.size() > 1) {
            Message message = new Message().title((CharSequence)"PublishingTemplate::updateWithAlternateStyles, only one supporting info relationship is allowed.").indentInc().segment((CharSequence)"Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Artifact Name", (Object)artifactReadable.getName());
            return Pair.createNullableImmutable(null, (Object)message);
        }
        ArtifactReadable stylesArtifactReadable = (ArtifactReadable)templateRelatedArtifacts.get(0);
        try {
            styles = stylesArtifactReadable.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.WholeWordContent);
        }
        catch (MultipleAttributesExist e) {
            Message message = new Message().title((CharSequence)"PublishingTemplate::updateWithAlternateStyles, only one WholeWordContent attribute value is allowed in the alternate styles artifact.").indentInc().segment((CharSequence)"Template Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Template Artifact Name", (Object)artifactReadable.getName()).segment((CharSequence)"Alternate Styles Artifact Identifier", (Object)stylesArtifactReadable.getIdString()).segment((CharSequence)"Alternate Styles Artifact Name", (Object)stylesArtifactReadable.getName()).indentDec().reasonFollows((Throwable)e);
            return Pair.createNullableImmutable(null, (Object)message);
        }
        catch (AttributeDoesNotExist e) {
            Message message = new Message().title((CharSequence)"PublishingTemplate::updateWithAlternateStyles, the alternate styles artifact does not contain any WholeWordContent.").indentInc().segment((CharSequence)"Template Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Template Artifact Name", (Object)artifactReadable.getName()).segment((CharSequence)"Alternate Styles Artifact Identifier", (Object)stylesArtifactReadable.getIdString()).segment((CharSequence)"Alternate Styles Artifact Name", (Object)stylesArtifactReadable.getName()).indentDec().reasonFollows((Throwable)e);
            return Pair.createNullableImmutable(null, (Object)message);
        }
        if (Strings.isInvalidOrBlank((String)styles)) {
            Message message = new Message().title((CharSequence)"PublishingTemplate::updateWithAlternateStyles, the alternate styles artifact WholeWordContent is invalid.").indentInc().segment((CharSequence)"Template Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Template Artifact Name", (Object)artifactReadable.getName()).segment((CharSequence)"Alternate Styles Artifact Identifier", (Object)stylesArtifactReadable.getIdString()).segment((CharSequence)"Alternate Styles Artifact Name", (Object)stylesArtifactReadable.getName());
            return Pair.createNullableImmutable(null, (Object)message);
        }
        String replacedStylesTemplateContentWordMl = (String)Conditions.requireNonNull((Object)WordCoreUtil.replaceStyles((CharSequence)templateContentWordMl, (CharSequence)styles).toString());
        Message validationMessage = FormatIndicator.WORD_ML.validatePublishingTemplateContent(replacedStylesTemplateContentWordMl);
        if (Objects.nonNull(validationMessage)) {
            Message message = new Message().title((CharSequence)"PublishingTemplate::updateWithAlternateStyles, template content with styles replaced is not valid Word Markup Language.").indentInc().segment((CharSequence)"Template Artifact Identifier", (Object)artifactReadable.getIdString()).segment((CharSequence)"Template Artifact Name", (Object)artifactReadable.getName()).segment((CharSequence)"Alternate Styles Artifact Identifier", (Object)stylesArtifactReadable.getIdString()).segment((CharSequence)"Alternate Styles Artifact Name", (Object)stylesArtifactReadable.getName()).indentDec().title((CharSequence)"Reason Follows:").blank().copy(validationMessage);
            return Pair.createNullableImmutable(null, (Object)message);
        }
        return Pair.createNullableImmutable((Object)templateContentWordMl, null);
    }

    private PublishingTemplate(@NonNull ArtifactReadable artifactReadable, @NonNull PublishingTemplateScalarKey identifier, @NonNull PublishingTemplateVectorKey matchCriteria, @NonNull PublishingTemplateScalarKey name, @NonNull PublishOptions publishOptions, @NonNull PublishingTemplateScalarKey safeName, @NonNull Map<FormatIndicator, String> templateContentMap, @Nullable String status, @NonNull RelationTableOptions relationTableOptions) {
        this.artifactReadable = artifactReadable;
        this.identifier = identifier;
        this.matchCriteria = matchCriteria;
        this.name = name;
        this.publishOptions = publishOptions;
        this.safeName = safeName;
        this.templateContentMap = templateContentMap;
        this.status = status;
        this.relationTableOptions = relationTableOptions;
        this.keyExtractors = new EnumMap(PublishingTemplateKeyType.class);
        this.keyExtractors.put(PublishingTemplateKeyType.IDENTIFIER, this.getIdentifierKeyExtractor());
        this.keyExtractors.put(PublishingTemplateKeyType.MATCH_CRITERIA, this.getMatchCriteriaKeyExtractor());
        this.keyExtractors.put(PublishingTemplateKeyType.NAME, this.getNameKeyExtractor());
        this.keyExtractors.put(PublishingTemplateKeyType.SAFE_NAME, this.getSafeNameKeyExtractor());
    }

    public org.eclipse.osee.framework.core.publishing.PublishingTemplate getBean(@NonNull FormatIndicator formatIndicator) {
        return new org.eclipse.osee.framework.core.publishing.PublishingTemplate((String)Conditions.requireNonNull((Object)this.identifier.getKey()), (String)Conditions.requireNonNull((Object)this.name.getKey()), this.publishOptions, this.templateContentMap.get(formatIndicator), this.relationTableOptions);
    }

    public PublishingTemplateScalarKey getIdentifier() {
        return this.identifier;
    }

    Iterable<PublishingTemplateScalarKey> getIdentifierKeyExtractor() {
        return this.makeScalarKeyIterable(this::getIdentifier);
    }

    public Iterable<PublishingTemplateScalarKey> getKeyIterable(PublishingTemplateKeyType keyType) {
        return this.keyExtractors.get(keyType);
    }

    public PublishingTemplateVectorKey getMatchCriteria() {
        return this.matchCriteria;
    }

    Iterable<PublishingTemplateScalarKey> getMatchCriteriaKeyExtractor() {
        return this.makeVectorKeyIterable(this::getMatchCriteria);
    }

    public PublishingTemplateScalarKey getName() {
        return this.name;
    }

    public Iterable<PublishingTemplateScalarKey> getNameKeyExtractor() {
        return this.makeScalarKeyIterable(this::getName);
    }

    PublishingTemplateKeyGroup getPublishingTemplateKeyGroup() {
        return new PublishingTemplateKeyGroup(this.getIdentifier(), this.getMatchCriteria(), this.getName(), this.getSafeName());
    }

    public PublishOptions getPublishOptions() {
        return this.publishOptions;
    }

    public RelationTableOptions getRelationTableOptions() {
        return this.relationTableOptions;
    }

    public PublishingTemplateScalarKey getSafeName() {
        return this.safeName;
    }

    Iterable<PublishingTemplateScalarKey> getSafeNameKeyExtractor() {
        return this.makeScalarKeyIterable(this::getSafeName);
    }

    public String getStatus() {
        Message message = new Message().title((CharSequence)"Publishing Template Status").indentInc().segment((CharSequence)"Identifier", (Object)this.identifier).segment((CharSequence)"Name", (Object)this.name).segment((CharSequence)"Safe Name", (Object)this.safeName).segment((CharSequence)"Artifact Name", (Object)this.artifactReadable.getName()).segment((CharSequence)"Artifact Identifier", (Object)this.artifactReadable.getIdString()).segment((CharSequence)"Artifact Branch Identifier", (Object)this.artifactReadable.getBranchIdString()).segmentIndexed((CharSequence)"Formats", this.templateContentMap.keySet(), FormatIndicator::getFormatName).segment((CharSequence)"Match Criteria", (Object)this.matchCriteria).segment((CharSequence)"Publish Options", (Object)this.publishOptions);
        if (Strings.isValidAndNonBlank((String)this.status)) {
            message.indentDec().title((CharSequence)"Publishing Template Errors").indentInc().block((CharSequence)this.status);
        }
        return message.toString();
    }

    Iterable<PublishingTemplateScalarKey> makeScalarKeyIterable(final Supplier<PublishingTemplateScalarKey> scalarKeySupplier) {
        return new Iterable<PublishingTemplateScalarKey>(){

            @Override
            public Iterator<PublishingTemplateScalarKey> iterator() {
                return new Iterator<PublishingTemplateScalarKey>(scalarKeySupplier){
                    boolean first = true;
                    Supplier<PublishingTemplateScalarKey> iteratorKeySupplier;
                    {
                        this.iteratorKeySupplier = supplier;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.first;
                    }

                    @Override
                    public PublishingTemplateScalarKey next() {
                        this.first = false;
                        return this.iteratorKeySupplier.get();
                    }
                };
            }
        };
    }

    Iterable<PublishingTemplateScalarKey> makeVectorKeyIterable(final Supplier<PublishingTemplateVectorKey> vectorKeySupplier) {
        return new Iterable<PublishingTemplateScalarKey>(){

            @Override
            public Iterator<PublishingTemplateScalarKey> iterator() {
                return ((PublishingTemplateVectorKey)vectorKeySupplier.get()).getKey().iterator();
            }
        };
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"PublishingTemplate").indentInc().segment((CharSequence)"Class", (Object)this.getClass().getSimpleName()).segment((CharSequence)"Artifact Readable", (Object)this.artifactReadable).segment((CharSequence)"Identifier", (Object)this.identifier).segment((CharSequence)"Name", (Object)this.name).segment((CharSequence)"Template Match Criteria", (Object)this.matchCriteria).toMessage((ToMessage)this.publishOptions).segmentMap((CharSequence)"Template Content Map", this.templateContentMap);
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

