/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publisher.publishing;

import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.define.operations.api.publisher.datarights.DataRightsOperations;
import org.eclipse.osee.define.operations.publisher.publishing.ChangedArtifactsTracker;
import org.eclipse.osee.define.operations.publisher.publishing.WordCoreUtilServer;
import org.eclipse.osee.define.operations.publisher.publishing.WordRenderArtifactWrapperServerImpl;
import org.eclipse.osee.define.operations.publisher.publishing.WordTemplateContentRendererHandler;
import org.eclipse.osee.define.rest.api.AttributeAlphabeticalComparator;
import org.eclipse.osee.define.rest.api.OseeHierarchyComparator;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactSpecification;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DataRightsClassification;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.publishing.AllowedOutlineTypes;
import org.eclipse.osee.framework.core.publishing.AttributeOptions;
import org.eclipse.osee.framework.core.publishing.DataAccessOperations;
import org.eclipse.osee.framework.core.publishing.DataRightContentBuilder;
import org.eclipse.osee.framework.core.publishing.FilterForView;
import org.eclipse.osee.framework.core.publishing.FormatIndicator;
import org.eclipse.osee.framework.core.publishing.IncludeBookmark;
import org.eclipse.osee.framework.core.publishing.IncludeDeleted;
import org.eclipse.osee.framework.core.publishing.IncludeHeadings;
import org.eclipse.osee.framework.core.publishing.IncludeMainContentForHeadings;
import org.eclipse.osee.framework.core.publishing.IncludeMetadataAttributes;
import org.eclipse.osee.framework.core.publishing.MetadataOptions;
import org.eclipse.osee.framework.core.publishing.OutlineNumber;
import org.eclipse.osee.framework.core.publishing.OutliningOptions;
import org.eclipse.osee.framework.core.publishing.ProcessedArtifactTracker;
import org.eclipse.osee.framework.core.publishing.PublishOptions;
import org.eclipse.osee.framework.core.publishing.PublishingAppender;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;
import org.eclipse.osee.framework.core.publishing.PublishingArtifactLoader;
import org.eclipse.osee.framework.core.publishing.PublishingErrorLog;
import org.eclipse.osee.framework.core.publishing.PublishingTemplate;
import org.eclipse.osee.framework.core.publishing.RendererMap;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.core.publishing.SectionNumberWhenMaximumOutlineLevelExceeded;
import org.eclipse.osee.framework.core.publishing.TrailingDot;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.core.publishing.WordRenderApplicabilityChecker;
import org.eclipse.osee.framework.core.publishing.WordRenderUtil;
import org.eclipse.osee.framework.core.publishing.WordTemplateContentData;
import org.eclipse.osee.framework.core.publishing.artifactacceptor.ArtifactAcceptor;
import org.eclipse.osee.framework.core.publishing.relation.table.RelationTableOptions;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class WordTemplateProcessorServer
implements ToMessage {
    protected static final String APPLICABILITY = "Applicability";
    protected static final String ARTIFACT = "Artifact";
    protected static final Object ARTIFACT_ID = "Artifact Id";
    protected static final String ARTIFACT_TYPE = "Artifact Type";
    protected static final String FONT = "Times New Roman";
    private static final int initialMapSize = 2048;
    protected final ActivityLog activityLog;
    protected boolean allAttributes;
    protected AllowedOutlineTypes allowedOutlineTypes;
    protected final Map<ApplicabilityId, Boolean> applicabilityMap = new HashMap<ApplicabilityId, Boolean>();
    protected Map<ApplicabilityId, ApplicabilityToken> applicabilityTokens;
    protected List<AttributeOptions> attributeOptionsList;
    protected final Map<ArtifactReadable, CharSequence> artParagraphNumbers = new HashMap<ArtifactReadable, CharSequence>();
    protected final AtsApi atsApi;
    protected BranchSpecification branchSpecification;
    protected final ArtifactTypeToken contentArtifactType;
    protected AttributeTypeToken contentAttributeType;
    protected ChangedArtifactsTracker changedArtifactsTracker;
    protected final DataAccessOperations dataAccessOperations;
    protected DataRightsOperations dataRightsOperations;
    private String elementType;
    protected ArtifactAcceptor emptyFoldersArtifactAcceptor;
    protected ArtifactAcceptor excludedArtifactTypeArtifactAcceptor;
    protected FormatIndicator formatIndicator;
    protected final Set<PublishingArtifact> headerArtifacts;
    protected final Set<String> headerGuids = new HashSet<String>();
    protected ArtifactTypeToken headingArtifactTypeToken;
    protected AttributeTypeToken headingAttributeTypeToken;
    protected final OseeHierarchyComparator hierarchyComparator;
    protected HashMap<String, ArtifactReadable> hyperlinkedIds = new HashMap();
    protected IncludeHeadings includeHeadings;
    protected IncludeMainContentForHeadings includeMainContentForHeadings;
    protected boolean includeErrorLog;
    protected IncludeMetadataAttributes includeMetadataAttributes;
    protected String initialOutlineNumber;
    protected final Log logger;
    private Integer maximumOutlineDepth;
    protected final OrcsApi orcsApi;
    protected final Map<ArtifactTypeToken, List<PublishingArtifact>> oseeLinkedArtifactMap = new HashMap<ArtifactTypeToken, List<PublishingArtifact>>();
    protected OutlineNumber outlineNumber;
    protected String overrideClassification;
    protected boolean overrideOutlineNumber;
    protected String desktopClientLoopbackUrl;
    protected ProcessedArtifactTracker processedArtifactTracker;
    protected final PublishingArtifactLoader publishingArtifactLoader;
    protected final PublishingErrorLog publishingErrorLog;
    protected PublishingTemplate publishingTemplate;
    protected Boolean recurseChildren;
    protected RendererMap renderer;
    long startTime = System.currentTimeMillis();
    boolean templateFooter;
    protected WordRenderApplicabilityChecker wordRenderApplicabilityChecker;
    protected WordTemplateContentRendererHandler wordTemplateContentRendererHandler;
    protected boolean contentAttributeOnly;
    protected final OrcsTokenService tokenService;

    public WordTemplateProcessorServer(OrcsApi orcsApi, AtsApi atsApi, DataAccessOperations dataAccessOperations, DataRightsOperations dataRightsOperations) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
        this.publishingErrorLog = new PublishingErrorLog();
        this.dataAccessOperations = dataAccessOperations;
        this.activityLog = orcsApi.getActivityLog();
        this.allAttributes = false;
        this.attributeOptionsList = null;
        this.allowedOutlineTypes = AllowedOutlineTypes.ANYTHING;
        this.branchSpecification = null;
        this.changedArtifactsTracker = new ChangedArtifactsTracker(this.atsApi, this.dataAccessOperations, this.publishingErrorLog);
        this.contentArtifactType = null;
        this.contentAttributeType = null;
        this.dataRightsOperations = dataRightsOperations;
        this.elementType = null;
        this.emptyFoldersArtifactAcceptor = null;
        this.excludedArtifactTypeArtifactAcceptor = null;
        this.formatIndicator = null;
        this.headerArtifacts = new HashSet<PublishingArtifact>();
        this.headingArtifactTypeToken = null;
        this.headingAttributeTypeToken = null;
        this.hierarchyComparator = new OseeHierarchyComparator(this.activityLog);
        this.includeHeadings = null;
        this.includeErrorLog = true;
        this.initialOutlineNumber = null;
        this.includeMetadataAttributes = null;
        this.logger = atsApi.getLogger();
        this.maximumOutlineDepth = null;
        this.outlineNumber = null;
        this.overrideClassification = null;
        this.overrideOutlineNumber = false;
        this.desktopClientLoopbackUrl = null;
        this.processedArtifactTracker = new ProcessedArtifactTracker();
        this.publishingArtifactLoader = new PublishingArtifactLoader(this.dataAccessOperations, this.publishingErrorLog, WordRenderArtifactWrapperServerImpl::new, WordRenderArtifactWrapperServerImpl::new, this.changedArtifactsTracker::loadByAtsTeamWorkflow);
        this.publishingTemplate = null;
        this.recurseChildren = null;
        this.renderer = null;
        this.contentAttributeOnly = false;
        this.templateFooter = false;
        this.tokenService = orcsApi.tokenService();
        this.wordRenderApplicabilityChecker = null;
    }

    protected List<PublishingArtifact> addContextToArtifactList(List<PublishingArtifact> changedArtifacts) {
        LinkedList<PublishingArtifact> artifactsWithContext = new LinkedList<PublishingArtifact>();
        for (PublishingArtifact artifact : changedArtifacts) {
            if (!artifactsWithContext.contains(artifact)) {
                artifactsWithContext.add(artifact);
            }
            List ancestors = (List)this.publishingArtifactLoader.loadAncestors(artifact, FilterForView.YES).orElseThrow();
            for (PublishingArtifact ancestor : ancestors) {
                if (artifactsWithContext.contains(ancestor) || !ancestor.notEqual((Id)CoreArtifactTokens.DefaultHierarchyRoot)) break;
                artifactsWithContext.add(ancestor);
            }
            List siblings = (List)this.publishingArtifactLoader.getSiblings(artifact, FilterForView.YES).orElseThrow();
            for (PublishingArtifact sibling : siblings) {
                if (artifactsWithContext.contains(sibling) || sibling.isOfType(new ArtifactTypeId[]{this.headingArtifactTypeToken})) continue;
                artifactsWithContext.add(sibling);
            }
        }
        return artifactsWithContext;
    }

    protected void addLinkNotInPublishErrors() {
        this.hyperlinkedIds.entrySet().stream().filter(arg_0 -> ((ProcessedArtifactTracker)this.processedArtifactTracker).isNotBookmarked(arg_0)).forEach(hyperlinkEntry -> {
            String linkReference = (String)hyperlinkEntry.getKey();
            ArtifactReadable artifactWithLink = (ArtifactReadable)hyperlinkEntry.getValue();
            String title = this.processedArtifactTracker.containsByLinkReference(linkReference) ? (this.processedArtifactTracker.isPublished(linkReference) ? "Artifact contains a link to an unbookmarked artifact." : "Artifact contains a link to a processed artifact that was excluded from the publish.") : (String)(WordCoreUtil.isLinkReferenceAnArtifactId((CharSequence)linkReference) ? this.dataAccessOperations.getArtifactReadableByIdentifier(new ArtifactSpecification(this.branchSpecification, ArtifactId.valueOf((String)linkReference))) : this.dataAccessOperations.getArtifactReadables(this.branchSpecification, null, List.of(linkReference), null, ArtifactTypeToken.SENTINEL, TransactionId.SENTINEL, IncludeDeleted.NO)).mapValue(artifactReadable -> "Artifact contains a link to an artifact that is not contained in the document.").orElseGet((Object)"Artifact contains a link to an unknown artifact. ");
            this.publishingErrorLog.error((Id)artifactWithLink, new Message().title((CharSequence)title).segment((CharSequence)"Artifact With Link", (Object)artifactWithLink.getIdString()).segment((CharSequence)"Link Reference", (Object)linkReference).toString());
        });
    }

    public void applyTemplate(List<ArtifactId> publishArtifactIds, @NonNull Writer writer) {
        if (Objects.isNull(publishArtifactIds) || publishArtifactIds.isEmpty()) {
            return;
        }
        this.applicabilityTokens = WordCoreUtilServer.getApplicabilityTokens(this.orcsApi, this.branchSpecification.getBranchIdWithOutViewId());
        String templateContent = Objects.nonNull(this.publishingTemplate) ? this.publishingTemplate.getTemplateContent() : "";
        List<PublishingArtifact> publishArtifacts = this.getSelectedArtifacts(publishArtifactIds);
        PublishingArtifact firstArtifact = publishArtifacts.get(0);
        this.initialOutlineNumber = this.outlineNumber.isValidOutlineNumber((CharSequence)this.initialOutlineNumber) ? this.initialOutlineNumber : WordRenderUtil.getStartingParagraphNumber((ArtifactReadable)firstArtifact, (PublishingTemplate)this.publishingTemplate);
        this.outlineNumber.setOutlineNumber((CharSequence)this.initialOutlineNumber);
        PublishingAppender publishingAppender = this.formatIndicator.createPublishingAppender((Appendable)writer, this.maximumOutlineDepth.intValue());
        WordRenderUtil.setupPublishingTemplate((FormatIndicator)this.formatIndicator, (PublishingTemplate)this.publishingTemplate, (PublishingAppender)publishingAppender, (String)this.initialOutlineNumber, null);
        WordCoreUtil.processPublishingTemplate((CharSequence)templateContent, segment -> {
            publishingAppender.append(segment);
            this.processArtifactSet(publishArtifacts, publishingAppender);
            if (this.formatIndicator.isWordMl() && this.includeErrorLog) {
                this.addLinkNotInPublishErrors();
                this.publishingErrorLog.publishErrorLog(publishingAppender);
            }
        }, tail -> {
            CharSequence cleanFooterText = this.formatIndicator.isWordMl() ? WordCoreUtil.cleanupFooter((CharSequence)tail) : tail;
            publishingAppender.append(cleanFooterText);
        });
    }

    protected boolean checkIsArtifactApplicable(ArtifactReadable artifact) {
        if (!this.branchSpecification.hasView()) {
            return true;
        }
        ApplicabilityId applicability = artifact.getApplicability();
        if (this.applicabilityMap.containsKey(applicability)) {
            return this.applicabilityMap.get(applicability);
        }
        boolean isApplicable = false;
        List validViews = this.orcsApi.getQueryFactory().applicabilityQuery().getBranchViewsForApplicability(this.branchSpecification.getBranchIdWithOutViewId(), applicability);
        if (validViews.contains(this.branchSpecification.getViewId())) {
            isApplicable = true;
        }
        this.applicabilityMap.put(applicability, isApplicable);
        return isApplicable;
    }

    public WordTemplateProcessorServer configure(PublishingTemplate publishingTemplate, RendererMap publishingOptions, String desktopClientLoopbackUrl) {
        this.publishingTemplate = publishingTemplate;
        this.renderer = publishingOptions;
        this.desktopClientLoopbackUrl = desktopClientLoopbackUrl;
        this.allAttributes = this.renderer.isRendererOptionSetAndTrue(RendererOption.ALL_ATTRIBUTES);
        this.formatIndicator = (FormatIndicator)this.renderer.getRendererOptionValue(RendererOption.PUBLISHING_FORMAT);
        this.contentAttributeOnly = (Boolean)this.renderer.getRendererOptionValue(RendererOption.CONTENT_ATTRIBUTE_ONLY);
        this.elementType = this.publishingTemplate.getPublishOptions().getElementType();
        if (!ARTIFACT.equals(this.elementType)) {
            throw new OseeCoreException(new Message().title((CharSequence)"MSWordTemplatePublisher::applyTemplate, publishing is only implement for ARTIFACT element types.").indentInc().segment((CharSequence)"Publishing Template", (Object)this.publishingTemplate.getName()).segment((CharSequence)"Element Type", (Object)this.elementType).toString(), new Object[0]);
        }
        int rendererOptionMaximumOutlineDepth = this.renderer.isRendererOptionSet(RendererOption.MAX_OUTLINE_DEPTH) ? (Integer)this.renderer.getRendererOptionValue(RendererOption.MAX_OUTLINE_DEPTH) : -1;
        int formatMaximumOutlineDepth = this.formatIndicator.getMaximumOutlineDepth();
        switch ((rendererOptionMaximumOutlineDepth == -1 ? 1 : 0) + (formatMaximumOutlineDepth == -1 ? 2 : 0)) {
            case 0: {
                this.maximumOutlineDepth = Math.min(rendererOptionMaximumOutlineDepth, formatMaximumOutlineDepth);
                break;
            }
            case 1: {
                this.maximumOutlineDepth = formatMaximumOutlineDepth;
                break;
            }
            case 2: {
                this.maximumOutlineDepth = rendererOptionMaximumOutlineDepth;
                break;
            }
            case 3: {
                this.maximumOutlineDepth = 100;
            }
        }
        this.outlineNumber = new OutlineNumber(this.maximumOutlineDepth.intValue(), 1, TrailingDot.NO, SectionNumberWhenMaximumOutlineLevelExceeded.INCREMENT_CURRENT_LEVEL);
        String overrideDataRights = (String)this.renderer.getRendererOptionValue(RendererOption.OVERRIDE_DATA_RIGHTS);
        this.overrideClassification = DataRightsClassification.isValid((String)overrideDataRights) ? overrideDataRights : "invalid";
        this.branchSpecification = new BranchSpecification((BranchId)this.renderer.getRendererOptionValue(RendererOption.BRANCH), (ArtifactId)this.renderer.getRendererOptionValue(RendererOption.VIEW));
        this.publishingArtifactLoader.configure(this.branchSpecification, 2048);
        this.wordRenderApplicabilityChecker = new WordRenderApplicabilityChecker((branchId, viewId) -> WordCoreUtilServer.getNonApplicableArtifacts(this.orcsApi, this.branchSpecification.getBranchIdWithOutViewId(), this.branchSpecification.getViewId()));
        this.wordRenderApplicabilityChecker.load(this.branchSpecification.getBranchId(), this.branchSpecification.getViewId());
        this.wordTemplateContentRendererHandler = new WordTemplateContentRendererHandler(this.orcsApi, this.dataAccessOperations, this.logger);
        PublishOptions publishOptions = publishingTemplate.getPublishOptions();
        OutliningOptions.setValues((OutliningOptions[])publishOptions.getOutliningOptions(), (FormatIndicator)this.formatIndicator, (RendererMap)this.renderer, (OrcsTokenService)this.tokenService, allowedOutlineTypes -> {
            AllowedOutlineTypes allowedOutlineTypes2 = this.allowedOutlineTypes = allowedOutlineTypes;
        }, contentAttributeType -> {
            AttributeTypeToken attributeTypeToken = this.contentAttributeType = contentAttributeType;
        }, excludedArtifactTypes -> {
            ArtifactAcceptor artifactAcceptor = this.excludedArtifactTypeArtifactAcceptor = WordRenderUtil.getExcludedArtifactTypeArtifactAcceptor((Collection)excludedArtifactTypes);
        }, headingArtifactType -> {
            ArtifactTypeToken artifactTypeToken = this.headingArtifactTypeToken = headingArtifactType;
        }, headingAttributeType -> {
            AttributeTypeToken attributeTypeToken = this.headingAttributeTypeToken = headingAttributeType;
        }, includeHeadings -> {
            IncludeHeadings includeHeadings2 = this.includeHeadings = includeHeadings;
        }, includeMainContentForHeadings -> {
            IncludeMainContentForHeadings includeMainContentForHeadings2 = this.includeMainContentForHeadings = includeMainContentForHeadings;
        }, includeMetadataAttributes -> {
            IncludeMetadataAttributes includeMetadataAttributes2 = this.includeMetadataAttributes = includeMetadataAttributes;
        }, initialOutlineNumber -> {
            String string = this.initialOutlineNumber = initialOutlineNumber;
        }, overrideOutlineNumber -> {
            boolean bl = this.overrideOutlineNumber = overrideOutlineNumber.booleanValue();
        }, recurseChildren -> {
            Boolean bl = this.recurseChildren = recurseChildren;
        }, templateFooter -> {
            boolean bl = this.templateFooter = templateFooter.booleanValue();
        });
        this.attributeOptionsList = AttributeOptions.setValues((AttributeOptions[])publishOptions.getAttributeOptions(), (OrcsTokenService)this.tokenService);
        return this;
    }

    protected Map<ApplicabilityId, ApplicabilityToken> getApplicabilityTokens() {
        if (this.applicabilityTokens == null) {
            this.applicabilityTokens = new HashMap<ApplicabilityId, ApplicabilityToken>();
            HashMap tokens = this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(this.branchSpecification.getBranchIdWithOutViewId());
            for (Map.Entry entry : tokens.entrySet()) {
                this.applicabilityTokens.put(ApplicabilityId.valueOf((Long)((Long)entry.getKey())), (ApplicabilityToken)entry.getValue());
            }
        }
        return this.applicabilityTokens;
    }

    protected String getArtifactFooter(ArtifactReadable artifact) {
        return "";
    }

    protected CharSequence getAttributeValueAsString(AttributeTypeToken token, ArtifactReadable artifact) {
        return artifact.getAttributeValuesAsString(token);
    }

    protected List<AttributeTypeToken> getOrderedAttributeTypes(Collection<AttributeTypeToken> attributeTypes) {
        LinkedList<AttributeTypeToken> orderedAttributeTypes = new LinkedList<AttributeTypeToken>();
        AttributeTypeToken contentAttributeType = this.formatIndicator.getContentAttributeTypeToken();
        AttributeTypeToken contentType = null;
        for (AttributeTypeToken attributeType : attributeTypes) {
            if (attributeType.matches(new Id[]{contentAttributeType})) {
                contentType = attributeType;
                continue;
            }
            orderedAttributeTypes.add(attributeType);
        }
        Collections.sort(orderedAttributeTypes);
        if (Objects.nonNull(contentType)) {
            switch (this.formatIndicator.getContentPosition()) {
                case START: {
                    orderedAttributeTypes.add(0, contentType);
                    break;
                }
                case END: {
                    orderedAttributeTypes.add(contentType);
                }
            }
        }
        return orderedAttributeTypes;
    }

    protected List<PublishingArtifact> getSelectedArtifacts(List<? extends ArtifactId> artifactIdentifiers) {
        List artifacts = (List)this.publishingArtifactLoader.getPublishingArtifactsByArtifactIdentifiers(PublishingArtifactLoader.BranchIndicator.PUBLISHING_BRANCH, artifactIdentifiers, FilterForView.YES, PublishingArtifactLoader.WhenNotFound.EMPTY, TransactionId.SENTINEL, IncludeDeleted.NO).orElseThrow(dataAccessException -> new OseeCoreException(new Message().title((CharSequence)"WordTemplateProcessorServer::getSelectedArtifacts, failed to load artifacts.").indentInc().segment((CharSequence)"Branch Identifier", (Object)this.branchSpecification.getBranchId().getIdString()).segment((CharSequence)"View Identifier", (Object)this.branchSpecification.getViewId().getIdString()).segmentIndexed((CharSequence)"Artifact Identifiers", (Collection)artifactIdentifiers, v -> v, 20).reasonFollows((Throwable)dataAccessException).toString(), (Throwable)dataAccessException));
        this.publishingArtifactLoader.sort(artifacts);
        return artifacts;
    }

    protected Map<PublishingArtifact, List<PublishingArtifact>> getSortedArtifactsInHeaderMap(List<PublishingArtifact> artifacts) {
        HashMap<PublishingArtifact, List<PublishingArtifact>> headerMap = new HashMap<PublishingArtifact, List<PublishingArtifact>>();
        PublishingArtifact lastHeader = null;
        LinkedList<PublishingArtifact> artList = new LinkedList<PublishingArtifact>();
        for (PublishingArtifact art : artifacts) {
            if (this.headerArtifacts.contains(art)) {
                if (lastHeader == null) {
                    lastHeader = art;
                    artList = new LinkedList();
                    continue;
                }
                headerMap.put(lastHeader, artList);
                lastHeader = art;
                artList = new LinkedList();
                continue;
            }
            artList.add(art);
        }
        headerMap.put(lastHeader, artList);
        return headerMap;
    }

    protected void populateOseeLinkedArtifacts(ArtifactTypeToken ... typeTokens) {
        ((List)this.publishingArtifactLoader.getPublishingArtifactsByGuids(PublishingArtifactLoader.BranchIndicator.PUBLISHING_BRANCH, this.hyperlinkedIds.keySet(), FilterForView.NO, PublishingArtifactLoader.WhenNotFound.ERROR, TransactionId.SENTINEL, IncludeDeleted.NO).orElseThrow(dataAccessException -> new OseeCoreException(new Message().title((CharSequence)"WordTemplateProcessorServer::populateOseeLinkedArtifacts, failed to load hyperlinked artifacts").indentInc().segmentIndexed((CharSequence)"Hyperlinked Artifacts", this.hyperlinkedIds.keySet()).toString(), (Throwable)dataAccessException))).forEach(artifact -> {
            if (artifact.isOfType((ArtifactTypeId[])typeTokens)) {
                ArtifactTypeToken artifactType = artifact.getArtifactType();
                if (this.oseeLinkedArtifactMap.containsKey(artifactType)) {
                    this.oseeLinkedArtifactMap.get(artifactType).add((PublishingArtifact)artifact);
                } else {
                    LinkedList<PublishingArtifact> artList = new LinkedList<PublishingArtifact>();
                    artList.add((PublishingArtifact)artifact);
                    this.oseeLinkedArtifactMap.put(artifactType, artList);
                }
                this.hyperlinkedIds.remove(artifact.getGuid());
            }
        });
    }

    protected void processArtifact(PublishingArtifact artifact, PublishingAppender publishingAppender, ArtifactAcceptor artifactAcceptor, DataRightContentBuilder dataRightContentBuilder, PublishingArtifactLoader.CacheReadMode cacheReadMode, ArtifactAcceptor includeBookmarkArtifactAcceptor, Consumer<PublishingArtifact> artifactPostProcess) {
        if (this.processedArtifactTracker.isOk((ArtifactId)artifact)) {
            return;
        }
        this.processedArtifactTracker.add(artifact);
        boolean startedSection = WordRenderUtil.renderArtifact((boolean)this.allAttributes, (AllowedOutlineTypes)this.allowedOutlineTypes, this.applicabilityTokens, this.attributeOptionsList, this::processAttribute, (PublishingArtifact)artifact, (ArtifactAcceptor)artifactAcceptor, artifactPostProcess, (boolean)this.contentAttributeOnly, (AttributeTypeToken)this.contentAttributeType, (DataRightContentBuilder)dataRightContentBuilder, (ArtifactAcceptor)this.emptyFoldersArtifactAcceptor, (ArtifactAcceptor)this.excludedArtifactTypeArtifactAcceptor, (FormatIndicator)this.formatIndicator, (ArtifactTypeToken)this.headingArtifactTypeToken, (AttributeTypeToken)this.headingAttributeTypeToken, lambdaHeadingText -> this.headingTextProcessor((CharSequence)lambdaHeadingText, artifact), (ArtifactAcceptor)IncludeBookmark.NO.getArtifactAcceptor(), (IncludeHeadings)this.includeHeadings, (IncludeMainContentForHeadings)this.includeMainContentForHeadings, (IncludeMetadataAttributes)this.includeMetadataAttributes, this::nonTemplateArtifactHandler, (MetadataOptions[])this.publishingTemplate.getPublishOptions().getMetadataOptions(), (RelationTableOptions)this.publishingTemplate.getRelationTableOptions(), (OrcsTokenService)this.tokenService, (PresentationType)PresentationType.PREVIEW, (PublishingAppender)publishingAppender, (boolean)false, () -> this.getOrderedAttributeTypes(artifact.getValidAttributeTypes()), (OutlineNumber)this.outlineNumber, (boolean)this.overrideOutlineNumber, (lambdaArtifact, lambdaParagraphNumber) -> this.paragraphNumberUpdater(lambdaParagraphNumber.toString(), (PublishingArtifact)lambdaArtifact), (ArtifactAcceptor)this.wordRenderApplicabilityChecker);
        List children = List.of();
        if (this.recurseChildren.booleanValue() && !(children = (List)this.publishingArtifactLoader.getChildren(artifact, FilterForView.YES, cacheReadMode).orElseThrow(dataAccessException -> new OseeCoreException(new Message().title((CharSequence)"WordTemplateProcessorServer::processArtifact, failed to load children of artifact.").indentInc().segment((CharSequence)ARTIFACT, (Object)artifact.getIdString()).reasonFollows((Throwable)dataAccessException).toString(), (Throwable)dataAccessException))).isEmpty()) {
            if (startedSection) {
                this.outlineNumber.startLevel();
            }
            for (PublishingArtifact childArtifact : children) {
                if (childArtifact == null) {
                    this.publishingErrorLog.error((Id)artifact, "Artifact has an empty child relation");
                    continue;
                }
                this.processArtifact(childArtifact, publishingAppender, artifactAcceptor, dataRightContentBuilder, cacheReadMode, includeBookmarkArtifactAcceptor, artifactPostProcess);
            }
            if (startedSection) {
                this.outlineNumber.endLevel();
            }
        }
        if (startedSection) {
            this.outlineNumber.nextSection();
            if (!this.outlineNumber.isAboveMaximumOutlingLevel()) {
                publishingAppender.endSubSection();
            }
        }
        this.processedArtifactTracker.setOk((ArtifactId)artifact);
    }

    protected void processArtifactSet(List<PublishingArtifact> artifacts, PublishingAppender publishingAppender) {
        this.emptyFoldersArtifactAcceptor = ArtifactAcceptor.ok();
        artifacts.forEach(artifact -> this.processArtifact((PublishingArtifact)artifact, publishingAppender, ArtifactAcceptor.ok(), null, PublishingArtifactLoader.CacheReadMode.LOAD_FROM_DATABASE, IncludeBookmark.NO.getArtifactAcceptor(), null));
    }

    protected void processAttribute(PublishingArtifact artifact, PublishingAppender publishingAppender, AttributeOptions attributeOptions, AttributeTypeToken attributeType, boolean allAttrs, PresentationType presentationType, boolean publishInLine, String footer, IncludeBookmark includeBookmark) {
        if (CoreAttributeTypes.WordOleData.equals((Object)attributeType) || CoreAttributeTypes.RelationOrder.equals((Object)attributeType) || !artifact.isAttributeTypeValid((AttributeTypeId)attributeType) || artifact.getAttributeValues(attributeType).isEmpty()) {
            return;
        }
        this.processedArtifactTracker.incrementAttributeCount((ArtifactId)artifact);
        if (attributeType.equals(this.formatIndicator.getContentAttributeTypeToken())) {
            this.renderMainContent(artifact, presentationType, publishingAppender, attributeOptions.getFormat(), attributeOptions.getLabel(), footer, includeBookmark);
            return;
        }
        WordRenderUtil.renderAttribute((FormatIndicator)this.formatIndicator, (AttributeTypeToken)attributeType, null, (ArtifactReadable)artifact, (PublishingAppender)publishingAppender, (String)attributeOptions.getLabel(), (String)attributeOptions.getFormat());
    }

    protected CharSequence headingTextProcessor(CharSequence headingText, PublishingArtifact artifact) {
        if (this.publishingArtifactLoader.isChangedArtifact((ArtifactId)artifact)) {
            headingText = WordCoreUtil.appendInlineChangeTagToHeadingText((CharSequence)headingText);
        }
        return headingText;
    }

    protected void nonTemplateArtifactHandler(PublishingArtifact publishingArtifact) {
        this.publishingErrorLog.error((Id)publishingArtifact, "WholeWordContent and NativeContent are not supported.");
    }

    protected void paragraphNumberUpdater(String paragraphNumber, PublishingArtifact artifact) {
        if (this.renderer.isRendererOptionSetAndTrue(RendererOption.UPDATE_PARAGRAPH_NUMBERS)) {
            this.artParagraphNumbers.put((ArtifactReadable)artifact, paragraphNumber);
        }
    }

    protected void renderMainContent(PublishingArtifact artifact, PresentationType presentationType, PublishingAppender publishingAppender, String format, String label, String footer, IncludeBookmark includeBookmark) {
        if (this.formatIndicator.isMarkdown()) {
            String markdownContent = artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.MarkdownContent);
            publishingAppender.append((CharSequence)"\n\n").append((CharSequence)markdownContent).append((CharSequence)"\n\n");
            return;
        }
        assert (Objects.nonNull(footer)) : "MSWordTemplatePublisher::renderWordTemplateContent, an artifact's footer must never be null.";
        HashSet<String> unknownGuids = new HashSet<String>();
        String wordMlContentDataAndFooter = WordRenderUtil.renderWordAttribute((PublishingArtifact)artifact, (ArtifactId)this.branchSpecification.getViewId(), (PublishingAppender)publishingAppender, (RendererMap)this.renderer, (PresentationType)presentationType, (String)label, (String)footer, (String)this.desktopClientLoopbackUrl, (boolean)this.publishingArtifactLoader.isChangedArtifact((ArtifactId)artifact), (IncludeBookmark)includeBookmark, (TransactionToken)(artifact.isHistorical() ? this.orcsApi.getTransactionFactory().getTx(artifact.getTransaction()) : TransactionToken.SENTINEL), unknownGuids, wordTemplateContentData -> this.wordTemplateContentRendererHandler.renderWordMLForArtifact((ArtifactReadable)artifact, (WordTemplateContentData)wordTemplateContentData), exception -> this.publishingErrorLog.error((Id)artifact, exception.getMessage()));
        this.trackDocumentLinks((ArtifactReadable)artifact, wordMlContentDataAndFooter, unknownGuids);
    }

    protected void sortQueryListByAttributeAlphabetical(List<PublishingArtifact> artifacts, AttributeTypeToken attributeToken) {
        try {
            artifacts.sort((Comparator<PublishingArtifact>)new AttributeAlphabeticalComparator(this.activityLog, attributeToken));
        }
        catch (Exception exception) {
            String errorMessage = String.format("There was an error when sorting the list on %s by alphabetical order", attributeToken.getName());
            this.publishingErrorLog.error(errorMessage);
        }
    }

    protected void sortQueryListByHierarchy(List<PublishingArtifact> artifacts) {
        artifacts.sort((Comparator<PublishingArtifact>)this.hierarchyComparator);
        for (Map.Entry entry : this.hierarchyComparator.errors.entrySet()) {
            ArtifactReadable artifact = (ArtifactReadable)entry.getKey();
            String description = (String)entry.getValue();
            this.publishingErrorLog.error((Id)artifact, description);
        }
    }

    protected void trackDocumentLinks(ArtifactReadable artifact, String data, Set<String> unknownIds) {
        if (!unknownIds.isEmpty()) {
            this.publishingErrorLog.error((Id)artifact, String.format("Artifact contains the following unknown GUIDs: %s (Delete or fix OSEE Link from Artifact)", unknownIds));
        }
        Pattern bookmarkHyperlinkPattern = Pattern.compile("(^<aml:annotation[^<>]+w:name=\"OSEE\\.([^\"]*)\"[^<>]+w:type=\"Word\\.Bookmark\\.Start\\\"/>)|(<w:instrText>\\s+HYPERLINK[^<>]+\"OSEE\\.([^\"]*)\"\\s+</w:instrText>)");
        Matcher match = bookmarkHyperlinkPattern.matcher(data);
        while (match.find()) {
            String hyperlinkIdentifier;
            boolean bookmarkMatch = Objects.nonNull(match.group(1));
            boolean hyperlinkMatch = Objects.nonNull(match.group(3));
            if (bookmarkMatch) {
                String bookmarkIdentifier = match.group(2);
                this.processedArtifactTracker.setBookmarked(bookmarkIdentifier);
            }
            if (!hyperlinkMatch || this.hyperlinkedIds.containsKey(hyperlinkIdentifier = match.group(4))) continue;
            this.hyperlinkedIds.put(hyperlinkIdentifier, artifact);
        }
    }

    protected void trackHyperLinks(ArtifactReadable artifact, String data, Set<String> unknownIds) {
        if (!unknownIds.isEmpty()) {
            this.publishingErrorLog.error((Id)artifact, String.format("Artifact contains the following unknown GUIDs: %s (Delete or fix OSEE Link from Artifact)", unknownIds));
        }
        Pattern bookmarkHyperlinkPattern = Pattern.compile("<w:instrText>\\s+HYPERLINK[^<>]+\"OSEE\\.([^\"]*)\"\\s+</w:instrText>");
        Matcher match = bookmarkHyperlinkPattern.matcher(data);
        while (match.find()) {
            String hyperlinkIdentifier = match.group(1);
            if (this.hyperlinkedIds.containsKey(hyperlinkIdentifier)) continue;
            this.hyperlinkedIds.put(hyperlinkIdentifier, artifact);
        }
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.startTime;
        long hours = elapsedTime / 3600000L;
        long minutes = (elapsedTime %= 3600000L) / 60000L;
        long seconds = (elapsedTime %= 60000L) / 1000L;
        outMessage.indent(indent).title((CharSequence)"WordTemplateProcessorServer, publish summary.").indentInc().segment((CharSequence)"Time", (Object)String.format("%s:%s:%s", hours, minutes, seconds)).toMessage((ToMessage)this.publishingArtifactLoader);
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }

    protected void updateParagraphNumbers() {
        TransactionBuilder transaction = this.orcsApi.getTransactionFactory().createTransaction(this.branchSpecification.getBranchIdWithOutViewId(), "Update paragraph number on artifact");
        int count = 0;
        for (Map.Entry<ArtifactReadable, CharSequence> art : this.artParagraphNumbers.entrySet()) {
            if (art.getKey().isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.ParagraphNumber)) {
                transaction.setSoleAttributeValue((ArtifactId)art.getKey(), (AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, (Object)art.getValue());
            }
            if (count++ <= 500) continue;
            transaction.commit();
            count = 0;
        }
        transaction.commit();
        this.artParagraphNumbers.clear();
    }
}

