/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publisher.publishing;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.query.IAtsQueryService;
import org.eclipse.osee.ats.api.workflow.IAtsBranchService;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactSpecification;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.publishing.DataAccessOperations;
import org.eclipse.osee.framework.core.publishing.FilterForView;
import org.eclipse.osee.framework.core.publishing.IncludeDeleted;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;
import org.eclipse.osee.framework.core.publishing.PublishingArtifactLoader;
import org.eclipse.osee.framework.core.publishing.PublishingErrorLog;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.Result;
import org.eclipse.osee.framework.jdk.core.util.ListMap;
import org.eclipse.osee.framework.jdk.core.util.Message;

public class ChangedArtifactsTracker {
    private final IAtsBranchService atsBranchService;
    private final IAtsQueryService atsQueryService;
    private final ListMap<ArtifactId, ArtifactReadable> map;
    private final PublishingErrorLog publishingErrorLog;
    private final DataAccessOperations dataAccessOperations;

    public ChangedArtifactsTracker(AtsApi atsApi, DataAccessOperations dataAccessOperations, PublishingErrorLog publishingErrorLog) {
        Objects.requireNonNull(atsApi, "ChangedArtifactsTracker::new, parameter \"atsApi\" cannot be null.");
        Objects.requireNonNull(dataAccessOperations, "ChangedArtifactsTracker::new, parameter \"dataAccessOperations\" cannot be null.");
        Objects.requireNonNull(publishingErrorLog, "ChangedArtifactsTracker::new, parameter \"publishingErrorLog\" cannot be null.");
        this.dataAccessOperations = Objects.requireNonNull(dataAccessOperations);
        this.atsBranchService = Objects.requireNonNull(atsApi.getBranchService());
        this.atsQueryService = Objects.requireNonNull(atsApi.getQueryService());
        this.publishingErrorLog = Objects.requireNonNull(publishingErrorLog);
        this.map = new ListMap();
    }

    private Stream<ArtifactId> getTeamworkflowArtifactIdentifiers(ArtifactId goalArtifactIdentifier) {
        return ((List)this.dataAccessOperations.getWorkFlowArtifactIdentifiers(goalArtifactIdentifier).orElseGet(dataAccessException -> {
            this.publishingErrorLog.error((Id)goalArtifactIdentifier, new Message().title((CharSequence)"Failed to get ATS Team Workflows for the goal Artifact.").segment((CharSequence)"Goal Artifact Identifier", (Object)goalArtifactIdentifier).reasonFollows((Throwable)dataAccessException).toString());
            return Result.ofValue(List.of());
        }, List::of)).stream();
    }

    private boolean isTeamWorkflowBranchValidAndCommitted(IAtsTeamWorkflow teamWorkflow, BranchId goalArtifactBranchIdentifier) {
        BranchToken workflowBranchToken = this.atsBranchService.getBranch(teamWorkflow);
        if (!workflowBranchToken.isValid()) {
            return false;
        }
        if (!this.atsBranchService.isBranchesAllCommitted(teamWorkflow) && workflowBranchToken.equals(goalArtifactBranchIdentifier)) {
            this.publishingErrorLog.error((Id)teamWorkflow, new Message().title((CharSequence)"The ATS Team Workflow branch has not been committed and will not be included in the publish.").indentInc().segment((CharSequence)"Goal Branch", (Object)goalArtifactBranchIdentifier.getIdString()).toString());
            return false;
        }
        return true;
    }

    public void loadByAtsTeamWorkflow(Collection<? extends PublishingArtifact> headerArtifacts, ArtifactId artifactIdentifier, PublishingArtifactLoader publishingArtifactLoader, BranchSpecification branchSpecification, Map<ArtifactId, PublishingArtifact> map) {
        Objects.requireNonNull(headerArtifacts, "ChangedArtifactsTracker::loadByAtsTeamWorkflow, parameter \"headerArtifacts\" cannot be null.");
        Objects.requireNonNull(artifactIdentifier, "ChangedArtifactsTracker::loadByAtsTeamWorkflow, parameter \"artifactIdentifier\" cannot be null.");
        ArtifactSpecification artifactSpecification = new ArtifactSpecification(branchSpecification, artifactIdentifier);
        if (headerArtifacts.isEmpty()) {
            return;
        }
        Set changedArtifactIds = this.getTeamworkflowArtifactIdentifiers(artifactSpecification.getArtifactId()).map(arg_0 -> ((IAtsQueryService)this.atsQueryService).getTeamWf(arg_0)).filter(teamWorkflow -> this.isTeamWorkflowBranchValidAndCommitted((IAtsTeamWorkflow)teamWorkflow, artifactSpecification.getBranchId())).map(teamWorkflow -> this.atsBranchService.getCommitTransactionRecord(teamWorkflow, artifactSpecification.getBranchId())).flatMap(commitTx -> this.atsBranchService.getChangeData((TransactionId)commitTx).stream()).map(ChangeItem::getArtId).collect(Collectors.toSet());
        if (changedArtifactIds.isEmpty()) {
            return;
        }
        HashSet<? extends PublishingArtifact> goodParents = new HashSet<PublishingArtifact>(headerArtifacts);
        ((List)publishingArtifactLoader.getPublishingArtifactsByArtifactIdentifiers(PublishingArtifactLoader.BranchIndicator.PUBLISHING_BRANCH, changedArtifactIds, FilterForView.NO, PublishingArtifactLoader.WhenNotFound.EMPTY, TransactionId.SENTINEL, IncludeDeleted.NO).orElseThrow()).stream().filter(artifactReadable -> publishingArtifactLoader.isRecursivelyRelated(goodParents, artifactReadable, FilterForView.NO)).collect(Collectors.toMap(Function.identity(), Function.identity(), (a, b) -> a, () -> this.map.mapView()));
    }
}

