/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publisher;

import java.util.Objects;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.define.operations.api.publisher.PublisherOperations;
import org.eclipse.osee.define.operations.api.publisher.datarights.DataRightsOperations;
import org.eclipse.osee.define.operations.api.publisher.publishing.PublishingOperations;
import org.eclipse.osee.define.operations.api.publisher.templatemanager.TemplateManagerOperations;
import org.eclipse.osee.define.operations.publisher.dataaccess.DataAccessOperationsImplArtifactReadOnlyImpl;
import org.eclipse.osee.define.operations.publisher.datarights.DataRightsOperationsImpl;
import org.eclipse.osee.define.operations.publisher.publishing.PublishingOperationsImpl;
import org.eclipse.osee.define.operations.publisher.templatemanager.TemplateManagerOperationsImpl;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.publishing.DataAccessOperations;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.osgi.service.event.EventAdmin;

public class PublisherOperationsImpl
implements PublisherOperations {
    private static volatile PublisherOperationsImpl publisherOperationsImpl = null;
    private final DataAccessOperations dataAccessOperations;
    private final DataRightsOperations dataRightsOperations;
    private final TemplateManagerOperations templateManagerOperations;
    private final PublishingOperations publishingOperations;

    public static synchronized PublisherOperations create(OrcsApi orcsApi, AtsApi atsApi, Log logger, EventAdmin eventAdmin) {
        if (Objects.nonNull(publisherOperationsImpl)) {
            return publisherOperationsImpl;
        }
        Objects.requireNonNull(orcsApi);
        Objects.requireNonNull(atsApi);
        Objects.requireNonNull(logger);
        Objects.requireNonNull(eventAdmin);
        JdbcService jdbcService = Objects.requireNonNull(orcsApi.getJdbcService());
        DataAccessOperationsImplArtifactReadOnlyImpl dataAccessOperations = DataAccessOperationsImplArtifactReadOnlyImpl.create(orcsApi);
        DataRightsOperationsImpl dataRightsOperations = DataRightsOperationsImpl.create(orcsApi);
        OrcsTokenService orcsTokenService = orcsApi.tokenService();
        TemplateManagerOperationsImpl templateManagerOperations = TemplateManagerOperationsImpl.create(jdbcService, logger, dataAccessOperations, orcsTokenService);
        PublishingOperationsImpl publishingOperations = PublishingOperationsImpl.create(orcsApi, atsApi, logger, eventAdmin, dataAccessOperations, dataRightsOperations, templateManagerOperations);
        PublisherOperationsImpl publisherOperations = new PublisherOperationsImpl(dataAccessOperations, dataRightsOperations, publishingOperations, templateManagerOperations);
        return publisherOperations;
    }

    private PublisherOperationsImpl(DataAccessOperations dataAccessOperations, DataRightsOperations dataRightsOperations, PublishingOperations publishingOperations, TemplateManagerOperations templateManagerOperations) {
        this.dataAccessOperations = dataAccessOperations;
        this.dataRightsOperations = dataRightsOperations;
        this.publishingOperations = publishingOperations;
        this.templateManagerOperations = templateManagerOperations;
    }

    public DataAccessOperations getDataAccessOperations() {
        return this.dataAccessOperations;
    }

    public DataRightsOperations getDataRightsOperations() {
        return this.dataRightsOperations;
    }

    public TemplateManagerOperations getTemplateManagerOperations() {
        return this.templateManagerOperations;
    }

    public PublishingOperations getPublishingOperations() {
        return this.publishingOperations;
    }

    public static synchronized void free() {
        DataAccessOperationsImplArtifactReadOnlyImpl.free();
        DataRightsOperationsImpl.free();
        PublishingOperationsImpl.free();
        TemplateManagerOperationsImpl.free();
        publisherOperationsImpl = null;
    }
}

