/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.query.AtsSearchDataResults;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.result.ResultRow;
import org.eclipse.osee.framework.jdk.core.result.ResultRows;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class AtsWorldResultRowOperation {
    private final AtsApi atsApi;
    private final AtsSearchData atsSearchData;
    private boolean teamWfsInState;

    public AtsWorldResultRowOperation(AtsApi atsApi, AtsSearchData atsSearchData) {
        this.atsApi = atsApi;
        this.atsSearchData = atsSearchData;
        AtsArtifactTypes.Action.getName();
    }

    public ResultRows run() {
        ResultRows rows = new ResultRows();
        if (this.atsSearchData.getCustomizeData() == null || this.atsSearchData.getCustomizeData().getColumnData().getColumns().isEmpty()) {
            rows.getRd().error("CustomizeData can not be null or empty.");
            return rows;
        }
        AtsSearchDataResults results = this.getArtifacts();
        ArrayList<XViewerColumn> showCols = new ArrayList<XViewerColumn>();
        for (XViewerColumn col : this.atsSearchData.getCustomizeData().getColumnData().getColumns()) {
            if (!col.isShow()) continue;
            showCols.add(col);
        }
        for (ArtifactToken art : results.getArtifacts()) {
            ResultRow row = new ResultRow(art.getId(), this.atsApi.getAtsBranch().getId(), new String[0]);
            rows.add(row);
            for (XViewerColumn col : showCols) {
                if (!col.isShow()) continue;
                this.addCellData(this.atsApi, art, row, col);
            }
        }
        return rows;
    }

    private AtsSearchDataResults getArtifacts() {
        if (this.teamWfsInState) {
            StringBuilder sb = new StringBuilder("'");
            for (Long teamDefId : this.atsSearchData.getTeamDefIds()) {
                sb.append(teamDefId.toString());
                sb.append("','");
            }
            String teamIds = sb.toString().replaceFirst(",'$", "");
            sb = new StringBuilder("'");
            for (StateType type : this.atsSearchData.getStateTypes()) {
                sb.append(type.toString());
                sb.append("','");
            }
            String stateType = sb.toString().replaceFirst(",'$", "");
            String query = String.format(this.getQuery(), teamIds, stateType);
            List artIds = this.atsApi.getQueryService().getArtifactIdsFromQuery(query, new Object[0]);
            return new AtsSearchDataResults(this.atsApi.getQueryService().getArtifacts((Collection)artIds, (BranchId)this.atsApi.getAtsBranch()), XResultData.OK_STATUS);
        }
        return this.atsApi.getQueryService().getArtifacts(this.atsSearchData, null);
    }

    private void addCellData(AtsApi atsApi, ArtifactToken art, ResultRow row, XViewerColumn xCol) {
        String value = "";
        if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) {
            IAtsWorkItem workItem = atsApi.getWorkItemService().getWorkItem(art);
            value = atsApi.getColumnService().getColumnText(xCol.getId(), (IAtsObject)workItem);
        }
        row.addValue(value);
    }

    public void setNew(boolean teamWfsInState) {
        this.teamWfsInState = teamWfsInState;
    }

    public String getQuery() {
        return "SELECT distinct art.art_id as art_id FROM osee_artifact art, osee_txs txs, OSEE_ATTRIBUTE attr \nWHERE attr.gamma_id = txs.gamma_id AND txs.tx_current = 1 AND txs.branch_id = 570 and \nattr.ART_ID = art.ART_ID and attr.ATTR_TYPE_ID = 4730961339090285773 and attr.VALUE \n IN (%s) \nAND art.art_id IN (SELECT distinct art.art_id AS art_id FROM osee_artifact art, osee_txs txs, OSEE_ATTRIBUTE attr \nWHERE attr.gamma_id = txs.gamma_id AND txs.tx_current = 1 AND txs.branch_id = 570 and \nattr.ART_ID = art.ART_ID and attr.ATTR_TYPE_ID = 1152921504606847147 and attr.VALUE in (%s))";
    }
}

