/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IArtifactResolver;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;

public class ArtifactResolverImpl
implements IArtifactResolver {
    private final AtsApi atsApi;

    public ArtifactResolverImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public ArtifactId get(IAtsObject atsObject) {
        if (atsObject.getStoreObject() instanceof ArtifactReadable) {
            return atsObject.getStoreObject();
        }
        return this.atsApi.getQueryService().getArtifact(atsObject);
    }

    public <A extends ArtifactId> A get(IAtsWorkItem workItem, Class<?> clazz) {
        Assert.isNotNull((Object)workItem, (String)"Work Item can not be null");
        ArtifactId artifact = this.get((IAtsObject)workItem);
        if (clazz.isInstance(artifact)) {
            return (A)artifact;
        }
        return null;
    }

    public <A extends ArtifactId> List<A> get(Collection<? extends IAtsWorkItem> workItems, Class<?> clazz) {
        Assert.isNotNull(workItems, (String)"Work Items can not be null");
        ArrayList<ArtifactReadable> arts = new ArrayList<ArtifactReadable>();
        for (IAtsWorkItem iAtsWorkItem : workItems) {
            ArtifactReadable artifact = (ArtifactReadable)this.get(iAtsWorkItem, clazz);
            if (artifact == null) continue;
            arts.add(artifact);
        }
        return arts;
    }

    public ArtifactTypeToken getArtifactType(IAtsWorkItem workItem) {
        Assert.isNotNull((Object)workItem, (String)"Work Item can not be null");
        return ((ArtifactReadable)workItem.getStoreObject()).getArtifactType();
    }
}

