/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.convert;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.util.IAtsDatabaseConversion;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public abstract class AbstractConvertGuidToId
implements IAtsDatabaseConversion {
    private static final String SELECT_BRANCH_ID_BY_GUID = "select branch_id from osee_branch where branch_guid = ?";
    protected final Log logger;
    protected final JdbcClient jdbcClient;
    protected final OrcsApi orcsApi;
    protected final AtsApi atsApi;

    public AbstractConvertGuidToId(Log logger, JdbcClient jdbcClient, OrcsApi orcsApi, AtsApi atsApi) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
    }

    protected OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    protected Log getLogger() {
        return this.logger;
    }

    protected JdbcClient getJdbcClient() {
        return this.jdbcClient;
    }

    protected BranchId getBranch(String guid) {
        return (BranchId)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(this.getBranchIdLegacy(guid))).getResultsAsId().getExactlyOne();
    }

    protected TransactionBuilder createTransactionBuilder() {
        TransactionFactory txFactory = this.getOrcsApi().getTransactionFactory();
        Conditions.checkNotNull((Object)txFactory, (String)"transaction factory");
        return txFactory.createTransaction((BranchId)CoreBranches.COMMON, this.getName());
    }

    private BranchId getBranchIdLegacy(String branchGuid) {
        BranchId branch = (BranchId)this.getJdbcClient().fetch((Object)BranchId.SENTINEL, SELECT_BRANCH_ID_BY_GUID, new Object[]{branchGuid});
        Conditions.checkExpressionFailOnTrue((boolean)branch.isInvalid(), (String)"Error getting branch_id for branch: [%s]", (Object[])new Object[]{branchGuid});
        return branch;
    }
}

