/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsDatabaseConversion;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.rest.AtsApiServer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;

public class ConvertCompCancelStateAndAssigneeAttributes
implements IAtsDatabaseConversion {
    private final AtsApiServer atsApiServer;
    private final String TITLE = "Convert Completed and Cancelled State Attrs";

    public ConvertCompCancelStateAndAssigneeAttributes(AtsApiServer atsApiServer) {
        this.atsApiServer = atsApiServer;
    }

    public void run(XResultData rd, boolean reportOnly, AtsApi atsApi) {
        ElapsedTime time = new ElapsedTime("Convert Completed and Cancelled State Attrs - Loading", false);
        HashSet uniqueArtIds = new HashSet();
        uniqueArtIds.addAll(this.atsApiServer.getOrcsApi().getQueryFactory().fromBranch((BranchId)atsApi.getAtsBranch()).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.AbstractWorkflowArtifact}).and((AttributeTypeToken)AtsAttributeTypes.CurrentStateType, Arrays.asList(StateType.Cancelled.name()), new QueryOption[0]).andNotExists((AttributeTypeToken)AtsAttributeTypes.CurrentStateName, "Cancelled").asArtifactIds());
        ArrayList artIds = new ArrayList();
        artIds.addAll(uniqueArtIds);
        List artIdLists = Collections.subDivide(artIds, (int)500);
        time.end();
        int x = 1;
        for (Collection artIdList : artIdLists) {
            this.convert(rd, reportOnly, atsApi, artIdList, x++, artIdLists.size());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void convert(XResultData rd, boolean reportOnly, AtsApi atsApi, Collection<ArtifactId> artIdList, int x, int size) {
        IAtsChangeSet changes = null;
        rd.logf("Processing art set %s/%s\n\n", new Object[]{x, size});
        if (!reportOnly) {
            AtsUser systemUser = atsApi.getUserService().getUserById((ArtifactId)AtsCoreUsers.SYSTEM_USER);
            changes = atsApi.createChangeSet("Convert Completed and Cancelled State Attrs", systemUser);
        }
        Collection allArtifacts = atsApi.getQueryService().getArtifacts(artIdList, (BranchId)atsApi.getAtsBranch());
        for (ArtifactToken artifact : allArtifacts) {
            List assignees;
            IAtsWorkItem workItem = atsApi.getWorkItemService().getWorkItem(artifact);
            String currStateFull = atsApi.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentState, "");
            String currStateName = currStateFull.replaceFirst(";.*$", "");
            if (!workItem.isCompletedOrCancelled()) continue;
            String currStateNameAttrVal = workItem.getCurrentStateName();
            if (!currStateName.equals(currStateNameAttrVal)) {
                rd.logf("--- Set CurrentStateName to [%s] for %s\n", new Object[]{currStateName, workItem.toStringWithId()});
                if (!reportOnly) {
                    changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateName, currStateName);
                }
            }
            if ((assignees = atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateAssignee)).isEmpty()) continue;
            rd.logf("--- Delete Assignees [%s] for %s\n\n", new Object[]{assignees, workItem.toStringWithId()});
            if (reportOnly) continue;
            changes.deleteAttributes((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateAssignee);
        }
        if (!reportOnly && !changes.isEmpty()) {
            TransactionToken tx = changes.executeIfNeeded();
            rd.logf("Transaction %s\n", new Object[]{tx.getIdString()});
        }
        rd.log("Complete");
    }

    public String getDescription() {
        StringBuffer data = new StringBuffer();
        data.append("Updates ATS completed/cancelled workflows to set ats.Current State Name and ats.Current State Assignee(required)\n\n");
        data.append("NOTE: Will need to bump server memory to 8GB.\n\n");
        data.append("Necessary for upgrade from 0.26.11\n\n");
        data.append("This will create new attrs as needed.\nCan be run multiple times without corruption.\nShould be run periodically on 0.26.11\n");
        return data.toString();
    }

    public String getName() {
        return "Convert Comp Cancel StateAndAssigneeAttributes";
    }
}

