/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.ActionableItemToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.workflow.CreateNewActionField;
import org.eclipse.osee.ats.rest.util.AbstractConfigResource;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryBuilder;

@Path(value="ai")
public class ActionableItemResource
extends AbstractConfigResource {
    public ActionableItemResource(AtsApi atsApi, OrcsApi orcsApi) {
        super(AtsArtifactTypes.ActionableItem, atsApi, orcsApi);
    }

    @GET
    @Path(value="all")
    @Produces(value={"application/json"})
    public List<ActionableItemToken> get(@QueryParam(value="workType") String workType, @QueryParam(value="orderByName") boolean orderByName) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andTypeEquals(new ArtifactTypeToken[]{AtsArtifactTypes.ActionableItem});
        if (Strings.isValid((String)workType)) {
            query = query.andAttributeIs((AttributeTypeToken)AtsAttributeTypes.WorkType, workType);
        }
        if (orderByName) {
            query = query.setOrderByAttribute((AttributeTypeToken)CoreAttributeTypes.Name);
        }
        return query.asArtifacts().stream().map(a -> new ActionableItemToken(a)).collect(Collectors.toList());
    }

    @GET
    @Path(value="{id}/additionalFields")
    @Produces(value={"application/json"})
    public Collection<CreateNewActionField> getAdditionalCreateActionFields(@PathParam(value="id") ArtifactId actionableItemId) {
        ActionableItem ai = this.atsApi.getActionableItemService().getActionableItemById(actionableItemId);
        if (ai == null || ai.isInvalid()) {
            return Collections.emptyList();
        }
        return this.atsApi.getActionService().getCreateActionFields(Arrays.asList(ai));
    }

    @GET
    @Path(value="{id}/teamdef")
    @Produces(value={"application/json"})
    public IAtsTeamDefinition getTeamDefinition(@PathParam(value="id") ArtifactId actionableItemId) {
        ActionableItem ai = this.atsApi.getActionableItemService().getActionableItemById(actionableItemId);
        if (ai == null || ai.isInvalid()) {
            return IAtsTeamDefinition.SENTINEL;
        }
        return ai.getTeamDefinition();
    }
}

