/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.agile.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.agile.kanban.JaxKbAvailableState;
import org.eclipse.osee.ats.api.agile.kanban.JaxKbSprint;
import org.eclipse.osee.ats.api.agile.kanban.JaxKbTask;
import org.eclipse.osee.ats.api.agile.kanban.KanbanRowType;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.NamedComparator;
import org.eclipse.osee.framework.jdk.core.util.SortOrder;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;

public class KanbanOperations {
    private final long sprintId;
    private final KanbanRowType rowType;
    private final long teamId;
    private final Map<Long, Set<String>> aItemToRowMap = new HashMap<Long, Set<String>>();
    private final Map<Long, Set<String>> aItemToRowIdMap = new HashMap<Long, Set<String>>();
    private final AtsApi atsApi;

    public KanbanOperations(AtsApi atsApi, long teamId, long sprintId, KanbanRowType rowType) {
        this.atsApi = atsApi;
        this.teamId = teamId;
        this.sprintId = sprintId;
        this.rowType = rowType;
    }

    public JaxKbSprint getSprintItemsForKb() {
        IAgileSprint sprint = this.atsApi.getAgileService().getAgileSprint(this.sprintId);
        if (sprint == null) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "sprintId is not valid", new Object[0]);
        }
        IAgileTeam agileTeam = this.atsApi.getAgileService().getAgileTeam(this.teamId);
        if (agileTeam == null) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "teamId is not valid", new Object[0]);
        }
        JaxKbSprint jSprint = new JaxKbSprint();
        jSprint.setId(sprint.getId());
        jSprint.setName(sprint.getName());
        jSprint.setActive(sprint.isActive());
        jSprint.setTeamId(sprint.getTeamId());
        jSprint.setRowType(this.rowType);
        Collection<String> ignoreStates = this.getIgnoreStates(agileTeam, this.atsApi);
        HashSet<ArtifactToken> teamMembers = new HashSet<ArtifactToken>();
        teamMembers.addAll(this.atsApi.getAgileService().getTeamMembersOrdered(agileTeam));
        for (IAgileItem aItem : this.atsApi.getAgileService().getItems(sprint)) {
            IAtsTeamWorkflow workItem = this.atsApi.getQueryService().getTeamWf(aItem.getId());
            if (workItem == null) {
                throw new RuntimeException("workItem is null");
            }
            ArtifactToken artifact = this.atsApi.getQueryService().getArtifact(workItem.getId());
            JaxKbTask task = this.createJaxKbTask(aItem, (IAtsWorkItem)workItem, artifact, agileTeam, this.atsApi);
            jSprint.getTasks().put(String.valueOf(aItem.getId()), task);
            if (this.rowType == KanbanRowType.BY_ASSIGNEE) {
                this.addRowsByAssignees(jSprint, task, aItem, (IAtsWorkItem)workItem, teamMembers);
                this.addAssigneesToTask(aItem, task, (IAtsWorkItem)workItem, KanbanRowType.BY_ASSIGNEE, teamMembers);
            } else {
                this.addRowsByStory(jSprint, task, aItem, (IAtsWorkItem)workItem);
                this.addAssigneesToTask(aItem, task, (IAtsWorkItem)workItem, KanbanRowType.BY_STORY, teamMembers);
            }
            jSprint.addStateNameToTaskId(workItem.getCurrentStateName(), aItem.getIdString());
            this.addAvailableStates(jSprint, aItem, (IAtsWorkItem)workItem, artifact, this.atsApi, ignoreStates);
        }
        LinkedList<ArtifactToken> teamMembersOrdered = new LinkedList<ArtifactToken>();
        teamMembersOrdered.addAll(teamMembers);
        Collections.sort(teamMembersOrdered, new NamedComparator(SortOrder.ASCENDING));
        for (ArtifactToken user : teamMembersOrdered) {
            jSprint.getUserNameToId().put(user.getName(), user.getIdString());
            jSprint.getTeamMembersOrdered().add(user.getName());
            jSprint.getUserIdToName().put(user.getIdString(), user.getName());
            if (this.rowType != KanbanRowType.BY_ASSIGNEE) continue;
            jSprint.getRowIdToName().put(user.getIdString(), user.getName());
        }
        for (ArtifactToken user : this.atsApi.getAgileService().getOtherMembersOrdered(agileTeam)) {
            if (teamMembers.contains(user)) continue;
            jSprint.getUserNameToId().put(user.getName(), user.getIdString());
            jSprint.getOtherMembersOrdered().add(user.getName());
            jSprint.getUserIdToName().put(user.getIdString(), user.getName());
        }
        return jSprint;
    }

    private void addAssigneesToTask(IAgileItem aItem, JaxKbTask task, IAtsWorkItem workItem, KanbanRowType rowType, Set<ArtifactToken> teamMembers) {
        Set<Object> assigneeIds = new HashSet();
        Set<Object> assigneeNames = new HashSet();
        if (rowType == KanbanRowType.BY_ASSIGNEE) {
            assigneeIds = this.aItemToRowIdMap.get(aItem.getId());
            assigneeNames = this.aItemToRowMap.get(aItem.getId());
        } else {
            Set assigneeImplementers = org.eclipse.osee.framework.jdk.core.util.Collections.setUnion((Collection[])new Collection[]{workItem.getAssignees(), this.atsApi.getImplementerService().getImplementers((IAtsObject)workItem)});
            for (AtsUser user : assigneeImplementers) {
                if (AtsCoreUsers.isSystemUser((AtsUser)user)) continue;
                teamMembers.add(user.getStoreObject());
                String name = user.getName();
                assigneeNames.add(name);
                assigneeIds.add(user.getIdString());
            }
        }
        String assigneesIdStr = assigneeIds == null ? "" : org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)"; ", assigneeIds);
        task.getAttributeMap().put("AssigneesIds", assigneesIdStr);
        String assigneesStr = assigneeNames == null ? "" : org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)"; ", assigneeNames);
        task.getAttributeMap().put("AssigneesStr", assigneesStr);
        task.getAttributeMap().put("AssigneesStrShort", Strings.truncate((String)assigneesStr, (int)30, (boolean)true));
    }

    private void addRowsByStory(JaxKbSprint jSprint, JaxKbTask task, IAgileItem aItem, IAtsWorkItem workItem) {
        ArtifactToken sprintArt = this.atsApi.getQueryService().getArtifact(jSprint.getId());
        Collection sprintStories = this.atsApi.getRelationResolver().getRelated((ArtifactId)sprintArt, AtsRelationTypes.AgileStoryToSprint_AgileStory);
        HashSet<String> rowNames = new HashSet<String>(sprintStories.size());
        HashSet<String> rowIds = new HashSet<String>(sprintStories.size());
        for (ArtifactToken sprintStory : sprintStories) {
            String name = sprintStory.getName();
            rowNames.add(name);
            rowIds.add(sprintStory.getIdString());
            jSprint.getRowIdToName().put(sprintStory.getIdString(), sprintStory.getName());
        }
        this.aItemToRowMap.put(aItem.getId(), rowNames);
        this.aItemToRowIdMap.put(aItem.getId(), rowIds);
        rowIds.clear();
        for (ArtifactToken story : this.atsApi.getRelationResolver().getRelated((IAtsObject)workItem, AtsRelationTypes.AgileStoryToItem_AgileStory)) {
            jSprint.addRowIdToTaskId(story.getIdString(), aItem.getIdString());
        }
    }

    private void addRowsByAssignees(JaxKbSprint jSprint, JaxKbTask task, IAgileItem aItem, IAtsWorkItem workItem, Set<ArtifactToken> teamMembers) {
        Set assigneeImplementers = org.eclipse.osee.framework.jdk.core.util.Collections.setUnion((Collection[])new Collection[]{workItem.getAssignees(), this.atsApi.getImplementerService().getImplementers((IAtsObject)workItem)});
        HashSet<String> assigneeNames = new HashSet<String>(assigneeImplementers.size());
        HashSet<String> assigneeIds = new HashSet<String>(assigneeImplementers.size());
        for (AtsUser user : assigneeImplementers) {
            if (AtsCoreUsers.isSystemUser((AtsUser)user)) continue;
            teamMembers.add(user.getStoreObject());
            String name = user.getName();
            assigneeNames.add(name);
            assigneeIds.add(user.getIdString());
            jSprint.getUserIdToName().put(user.getIdString(), user.getName());
            jSprint.getRowIdToName().put(user.getIdString(), user.getName());
        }
        this.aItemToRowMap.put(aItem.getId(), assigneeNames);
        this.aItemToRowIdMap.put(aItem.getId(), assigneeIds);
        LinkedList<String> assigneesIds = new LinkedList<String>();
        if (workItem.getCurrentStateType().isWorking()) {
            assigneesIds.addAll(this.getAssigneeUserIdsString(workItem, this.atsApi, teamMembers));
        } else {
            assigneesIds.addAll(this.getImplementerUserIdsString(workItem, this.atsApi, teamMembers));
        }
        for (String assigneeId : assigneeIds) {
            jSprint.addRowIdToTaskId(assigneeId, aItem.getIdString());
        }
    }

    private Collection<String> getIgnoreStates(IAgileTeam agileTeam, AtsApi atsApi) {
        ArrayList<String> values = new ArrayList<String>();
        String strValue = (String)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)agileTeam, (AttributeTypeToken)AtsAttributeTypes.KanbanIgnoreStates, (Object)"");
        if (Strings.isValid((String)strValue)) {
            String[] stringArray = strValue.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                values.add(value);
                ++n2;
            }
        }
        return values;
    }

    private Collection<String> getAssigneeUserIdsString(IAtsWorkItem workItem, AtsApi atsApi, Set<ArtifactToken> teamMembers) {
        List assignees = workItem.getAssignees();
        HashSet<String> ids = new HashSet<String>();
        for (AtsUser assignee : assignees) {
            if (!AtsCoreUsers.isSystemUser((AtsUser)assignee)) {
                teamMembers.add(assignee.getStoreObject());
                continue;
            }
            ids.add(assignee.getIdString());
        }
        return ids;
    }

    private Collection<String> getImplementerUserIdsString(IAtsWorkItem workItem, AtsApi atsApi, Set<ArtifactToken> teamMembers) {
        if (workItem.isCancelled()) {
            return Collections.singleton(workItem.getCancelledBy().getStoreObject().getIdString());
        }
        List implementers = atsApi.getImplementerService().getImplementers((IAtsObject)workItem);
        HashSet<String> ids = new HashSet<String>();
        for (AtsUser implementer : implementers) {
            if (AtsCoreUsers.isSystemUser((AtsUser)implementer)) continue;
            teamMembers.add(implementer.getStoreObject());
        }
        if (implementers.size() > 1) {
            implementers.remove(AtsCoreUsers.SYSTEM_USER);
        }
        for (AtsUser implementer : implementers) {
            ids.add(implementer.getIdString());
        }
        return ids;
    }

    private void addAvailableStates(JaxKbSprint items, IAgileItem aItem, IAtsWorkItem workItem, ArtifactToken artifact, AtsApi atsApi, Collection<String> ignoreStates) {
        try {
            WorkDefinition workDef = workItem.getWorkDefinition();
            for (StateDefinition stateDef : atsApi.getWorkDefinitionService().getStatesOrderedByOrdinal(workDef)) {
                if (ignoreStates.contains(stateDef.getName())) continue;
                JaxKbAvailableState state = null;
                for (JaxKbAvailableState availState : items.getAvailableStates()) {
                    if (!availState.getName().equals(stateDef.getName())) continue;
                    state = availState;
                    break;
                }
                if (state != null) continue;
                state = new JaxKbAvailableState();
                state.setName(stateDef.getName());
                state.setOrdinal(stateDef.getOrdinal());
                state.setStateType(stateDef.getStateType().name());
                for (StateDefinition toState : stateDef.getToStates()) {
                    state.getToStates().add(toState.getName());
                }
                items.getAvailableStates().add(state);
            }
        }
        catch (Exception exception) {}
    }

    private JaxKbTask createJaxKbTask(IAgileItem aItem, IAtsWorkItem wItem, ArtifactToken artifact, IAgileTeam agileTeam, AtsApi atsApi) {
        JaxKbTask task = new JaxKbTask();
        task.setName(aItem.getName());
        task.setGuid(aItem.getIdString());
        task.setCanEdit(true);
        task.setArtifactType(wItem.getArtifactTypeName());
        task.getAttributeMap().put("Shortname", wItem.getAtsId());
        IAtsVersion version = atsApi.getVersionService().getTargetedVersion(wItem);
        task.getAttributeMap().put("versionName", version != null ? version.getName() : "");
        Collection featureGroups = atsApi.getAgileService().getFeatureGroups(aItem);
        if (!featureGroups.isEmpty()) {
            String grps = org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", (Iterable)featureGroups);
            task.getAttributeMap().put("featureName", grps);
        }
        task.setBranchGuid(artifact.getBranchIdString());
        Collection attributes = atsApi.getAttributeResolver().getAttributes((ArtifactId)artifact);
        Collection attrTypes = atsApi.getStoreService().getAttributeTypes();
        HashSet<String> ais = new HashSet<String>();
        if (!attributes.isEmpty()) {
            for (AttributeTypeToken attrType : attrTypes) {
                Collection attributeValues;
                if (!attrType.getName().equals("ats.Log") && atsApi.getStoreService().isAttributeTypeValid((ArtifactId)artifact, attrType) && !(attributeValues = atsApi.getAttributeResolver().getAttributes((ArtifactId)artifact, attrType)).isEmpty()) {
                    task.getAttributeMap().put(attrType.getName(), org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)"; ", (Iterable)attributeValues));
                }
                if (attrType.getName().equals("ats.Actionable Item") || !attrType.equals(AtsAttributeTypes.ActionableItemReference)) continue;
                for (Object id : atsApi.getAttributeResolver().getAttributeValues((ArtifactId)artifact, (AttributeTypeToken)AtsAttributeTypes.ActionableItemReference)) {
                    ais.add(((IAtsObject)atsApi.getQueryService().getConfigItem((ArtifactId)id)).getName());
                }
            }
        }
        task.getAttributeMap().put("actionableItemName", org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)"; ", ais));
        return task;
    }
}

