/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.indexer.callable.producer;

import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Triplet;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreCallable;
import org.eclipse.osee.orcs.db.internal.search.indexer.IndexingTaskConsumer;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.TagQueueJoinQuery;
import org.eclipse.osee.orcs.search.IndexerCollector;

public final class IndexBranchesDatabaseCallable
extends AbstractDatastoreCallable<Integer> {
    private static final int BATCH_SIZE = 1000;
    private static final String FIND_ALL_TAGGABLE_ATTRIBUTES = "SELECT att.gamma_id FROM osee_join_id oji, osee_attribute att WHERE oji.query_id = ? AND oji.id = att.attr_type_id";
    private static final String FIND_ALL_TAGGABLE_ATTRIBUTES_REPLACE = "SELECT count(1) FROM osee_join_id oji, osee_attribute att WHERE oji.query_id = ? AND oji.id = att.attr_type_id";
    private static final String COUNT_ALL_TAGGABLE_ATTRIBUTES = "SELECT att.gamma_id FROM osee_join_id oji, osee_attribute att WHERE oji.query_id = ? AND oji.id = att.attr_type_id".replace("att.gamma_id", "count(1)");
    private static final String FIND_MISSING = "SELECT att.gamma_id FROM osee_join_id oji, osee_attribute att WHERE oji.query_id = ? AND oji.id = att.attr_type_id AND att.gamma_id NOT IN (SELECT gamma_id FROM osee_search_tags)";
    private static final String COUNT_MISSING = "SELECT count(1) FROM osee_join_id oji, osee_attribute att WHERE oji.query_id = ? AND oji.id = att.attr_type_id AND att.gamma_id NOT IN (SELECT gamma_id FROM osee_search_tags)";
    private static final String FIND_TAGGABLE_ATTRIBUTES_BY_BRANCH = "SELECT DISTINCT att.gamma_id FROM osee_join_id jid1, osee_join_id jid2, osee_txs txs, osee_attribute att WHERE jid1.query_id = ? AND jid1.id = txs.branch_id AND txs.gamma_id = att.gamma_id AND att.attr_type_id = jid2.id and jid2.query_id = ?";
    private static final String COUNT_TAGGABLE_ATTRIBUTES_BY_BRANCH = "SELECT DISTINCT att.gamma_id FROM osee_join_id jid1, osee_join_id jid2, osee_txs txs, osee_attribute att WHERE jid1.query_id = ? AND jid1.id = txs.branch_id AND txs.gamma_id = att.gamma_id AND att.attr_type_id = jid2.id and jid2.query_id = ?".replace("DISTINCT att.gamma_id", "count(DISTINCT att.gamma_id)");
    private static final String FIND_MISSING_BY_BRANCH = "SELECT DISTINCT att.gamma_id FROM osee_join_id jid1, osee_join_id jid2, osee_txs txs, osee_attribute att WHERE jid1.query_id = ? AND jid1.id = txs.branch_id AND txs.gamma_id = att.gamma_id AND att.attr_type_id = jid2.id and jid2.query_id = ? AND att.gamma_id NOT IN (SELECT gamma_id FROM osee_search_tags)";
    private static final String COUNT_MISSING_BY_BRANCH = String.valueOf(COUNT_TAGGABLE_ATTRIBUTES_BY_BRANCH) + " AND att.gamma_id NOT IN (SELECT gamma_id FROM osee_search_tags)";
    private final SqlJoinFactory joinFactory;
    private final OrcsTokenService tokenService;
    private final IndexingTaskConsumer consumer;
    private final IndexerCollector collector;
    private final Collection<Branch> branches;
    private final boolean tagOnlyMissingGammas;

    public IndexBranchesDatabaseCallable(Log logger, OrcsSession session, JdbcClient service, SqlJoinFactory joinFactory, OrcsTokenService tokenService, IndexingTaskConsumer consumer, IndexerCollector collector, Collection<Branch> branches, boolean tagOnlyMissingGammas) {
        super(logger, session, service);
        this.joinFactory = joinFactory;
        this.tokenService = tokenService;
        this.consumer = consumer;
        this.collector = collector;
        this.branches = branches;
        this.tagOnlyMissingGammas = tagOnlyMissingGammas;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Integer call() throws Exception {
        this.getLogger().info(this.getParamInfo(), new Object[0]);
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            IdJoinQuery branchJoin = this.joinFactory.createIdJoinQuery();
            try {
                try (IdJoinQuery typeJoin = this.joinFactory.createIdJoinQuery();){
                    Triplet<String, String, Object[]> data = this.createQueries(this.branches, branchJoin, typeJoin);
                    String countQuery = (String)data.getFirst();
                    String searchQuery = (String)data.getSecond();
                    Object[] params = (Object[])data.getThird();
                    for (AttributeTypeGeneric attrType : this.tokenService.getTaggedAttrs()) {
                        typeJoin.add(attrType.getId());
                    }
                    typeJoin.store();
                    branchJoin.store();
                    if (this.collector != null) {
                        int totalAttributes = (Integer)this.getJdbcClient().fetch((Object)-1, countQuery, params);
                        this.collector.onIndexTotalTaskItems((long)totalAttributes);
                    }
                    this.fetchAndProcessGammas(searchQuery, params);
                }
                if (branchJoin == null) return this.branches.size();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (branchJoin == null) throw throwable;
                branchJoin.close();
                throw throwable;
            }
            branchJoin.close();
            return this.branches.size();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void storeAndAddQueryId(TagQueueJoinQuery joinQuery) {
        try {
            if (!joinQuery.isEmpty()) {
                joinQuery.store();
                this.consumer.submitTaskId(this.getSession(), this.tokenService, this.collector, joinQuery.getQueryId());
            }
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    private void fetchAndProcessGammas(String query, Object ... params) {
        TagQueueJoinQuery[] queryHolder = new TagQueueJoinQuery[]{this.joinFactory.createTagQueueJoinQuery()};
        Consumer<JdbcStatement> consumer = stmt -> {
            long gammaId = stmt.getLong("gamma_id");
            queryHolder[0].add(gammaId);
            if (queryHolder[0].size() >= 1000) {
                this.storeAndAddQueryId(queryHolder[0]);
                tagQueueJoinQueryArray[0] = this.joinFactory.createTagQueueJoinQuery();
            }
        };
        this.getJdbcClient().runQuery(consumer, query, params);
        this.storeAndAddQueryId(queryHolder[0]);
    }

    private String getParamInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("Tagging");
        if (this.tagOnlyMissingGammas) {
            builder.append(" (Only Missing)");
        }
        builder.append(" Attributes for ");
        if (this.branches.isEmpty()) {
            builder.append("All Branches");
        } else {
            builder.append("Branch(es) ").append(this.branches);
        }
        return builder.toString();
    }

    private Triplet<String, String, Object[]> createQueries(Collection<? extends Id> branches, IdJoinQuery branchJoin, IdJoinQuery typeJoin) {
        String searchQuery;
        String countQuery;
        Object[] params;
        if (branches.isEmpty()) {
            params = new Object[]{typeJoin.getQueryId()};
            if (this.tagOnlyMissingGammas) {
                countQuery = COUNT_MISSING;
                searchQuery = FIND_MISSING;
            } else {
                countQuery = COUNT_ALL_TAGGABLE_ATTRIBUTES;
                searchQuery = FIND_ALL_TAGGABLE_ATTRIBUTES;
            }
        } else {
            branchJoin.addAll(branches);
            params = new Object[]{branchJoin.getQueryId(), typeJoin.getQueryId()};
            if (this.tagOnlyMissingGammas) {
                countQuery = COUNT_MISSING_BY_BRANCH;
                searchQuery = FIND_MISSING_BY_BRANCH;
            } else {
                countQuery = COUNT_TAGGABLE_ATTRIBUTES_BY_BRANCH;
                searchQuery = FIND_TAGGABLE_ATTRIBUTES_BY_BRANCH;
            }
        }
        return new Triplet((Object)countQuery, (Object)searchQuery, (Object)params);
    }
}

