/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.jdbc.ObjectType;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.db.internal.search.handlers.AbstractXtraTableSqlHandler;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;

public class XtraBranchDataSqlHandler
extends AbstractXtraTableSqlHandler {
    private final SqlHandlerPriority priority;
    private final ObjectType objectType;
    private String branchAlias;
    private String txsAlias;

    public XtraBranchDataSqlHandler(SqlHandlerPriority priority, ObjectType objectType) {
        this.priority = priority;
        this.objectType = objectType;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.branchAlias = writer.addTable(OseeDb.BRANCH_TABLE, this.objectType);
        this.txsAlias = writer.getFirstAlias(this.getLevel(), OseeDb.TXS_TABLE, this.objectType);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.writeEquals(this.txsAlias, this.branchAlias, "branch_id");
    }

    @Override
    public boolean hasPredicates() {
        return this.txsAlias != null && !this.txsAlias.isEmpty();
    }

    @Override
    public int getPriority() {
        return this.priority.ordinal();
    }
}

