/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaGetReferenceArtifact;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class GetReferenceDetailsHandler
extends SqlHandler<CriteriaGetReferenceArtifact> {
    CriteriaGetReferenceArtifact criteria;
    private String referenceAlias;
    private String mainAttAlias;
    private String artAlias;
    private String txsAlias;

    @Override
    public void setData(CriteriaGetReferenceArtifact criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.mainAttAlias = writer.getAliasManager().getFirstUsedAlias("atts");
        this.artAlias = writer.addTable(OseeDb.ARTIFACT_TABLE);
        this.txsAlias = writer.addTable(OseeDb.TXS_TABLE);
        if (OptionsUtil.getIncludeApplicabilityTokens((Options)writer.getOptions())) {
            writer.getMainTableAlias(OseeDb.OSEE_KEY_VALUE_TABLE);
        }
        if (OptionsUtil.getIncludeLatestTransactionDetails((Options)writer.getOptions())) {
            writer.getMainTableAlias(OseeDb.TX_DETAILS_TABLE);
        }
    }

    public void writeFromClause(AbstractSqlWriter writer) {
        writer.write("from " + this.mainAttAlias + ", osee_artifact " + this.artAlias + ", osee_txs " + this.txsAlias);
    }

    @Override
    public void writeSelectFields(AbstractSqlWriter writer) {
        writer.write("select " + this.artAlias + ".art_id, " + this.artAlias + ".art_type_id, " + this.txsAlias + ".app_id, " + this.txsAlias + ".transaction_id, " + this.txsAlias + ".mod_type, " + this.txsAlias + ".tx_current, 0 AS top, " + this.mainAttAlias + ".art_id source_art_id , " + this.mainAttAlias + ".art_type_id source_art_type_id, " + this.mainAttAlias + ".attr_id source_attr_id \n");
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.write(String.valueOf(this.mainAttAlias) + ".type_id = ? and " + this.mainAttAlias + ".value = " + writer.getJdbcClient().getDbType().getPostgresCastStart() + this.artAlias + ".art_id " + writer.getJdbcClient().getDbType().getPostgresCastVarCharEnd() + " and " + this.artAlias + ".gamma_id = " + this.txsAlias + ".gamma_id and " + this.txsAlias + ".branch_id = ? and " + this.txsAlias + ".tx_current =  ? ");
        writer.addParameter(this.criteria.getAttributeType().getId());
        writer.addParameter(writer.getRootQueryData().getBranch().getId());
        writer.addParameter(1);
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.REFERENCE_ARTIFACT.ordinal();
    }
}

