/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaBranchName;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class BranchNameSqlHandler
extends SqlHandler<CriteriaBranchName> {
    private CriteriaBranchName criteria;
    private String brAlias;

    @Override
    public void setData(CriteriaBranchName criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.brAlias = writer.getMainTableAlias(OseeDb.BRANCH_TABLE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        String value = this.criteria.getValue();
        if (this.criteria.isLike()) {
            writer.write("LOWER(" + this.brAlias + ".branch_name) like LOWER('" + value + "%')");
        } else if (this.criteria.isPatternIgnoreCase()) {
            writer.write(String.format("LOWER(" + this.brAlias + ".branch_name) like LOWER('%s')", value));
        } else if (this.criteria.isPattern()) {
            writer.writePatternMatch(this.brAlias, "branch_name", value);
        } else {
            writer.write(this.brAlias);
            writer.write(".branch_name = ?");
            writer.addParameter(value);
        }
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.BRANCH_NAME.ordinal();
    }
}

