/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.core.ds.ApplicabilityDsQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class ApplicabilityDsQueryImpl
implements ApplicabilityDsQuery {
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory sqlJoinFactory;
    private static final String SELECT_APPLIC_FOR_ART = "SELECT art_id, key, value FROM osee_artifact art, osee_txs txs1, osee_key_value WHERE art_id = ? and art.gamma_id = txs1.gamma_id and txs1.branch_id = ? AND txs1.tx_current <> ? AND txs1.app_id = key";
    private static final String SELECT_APPLIC_FOR_ARTS = "SELECT art_id, key, value FROM osee_join_id jid, osee_artifact art, osee_txs txs1, osee_key_value WHERE jid.query_id = ? and jid.id = art_id and art.gamma_id = txs1.gamma_id and txs1.branch_id = ? AND txs1.tx_current <> ? AND txs1.app_id = key";

    ApplicabilityDsQueryImpl(JdbcClient jdbcClient, SqlJoinFactory sqlJoinFactory) {
        this.jdbcClient = jdbcClient;
        this.sqlJoinFactory = sqlJoinFactory;
    }

    public ApplicabilityToken getApplicabilityToken(ArtifactId artId, BranchId branch) {
        return (ApplicabilityToken)this.jdbcClient.fetch((Object)ApplicabilityToken.BASE, stmt -> new ApplicabilityToken(stmt.getLong("key"), stmt.getString("value")), SELECT_APPLIC_FOR_ART, new Object[]{artId, branch, TxCurrent.NOT_CURRENT});
    }

    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokens(List<? extends ArtifactId> artIds, BranchId branch) {
        ArrayList<Pair<ArtifactId, ApplicabilityToken>> result = new ArrayList<Pair<ArtifactId, ApplicabilityToken>>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (IdJoinQuery idJoin = this.sqlJoinFactory.createIdJoinQuery();){
            for (ArtifactId artifactId : artIds) {
                idJoin.add((Id)artifactId);
            }
            idJoin.store();
            this.jdbcClient.runQuery(stmt -> {
                boolean bl = result.add(new Pair((Object)ArtifactId.valueOf((Long)stmt.getLong("art_id")), (Object)ApplicabilityToken.valueOf((long)stmt.getLong("key"), (String)stmt.getString("value"))));
            }, SELECT_APPLIC_FOR_ARTS, new Object[]{idJoin.getQueryId(), branch, TxCurrent.NOT_CURRENT});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    public Set<ArtifactId> getExcludedArtifacts(BranchId branch, ArtifactId view) {
        HashSet<ArtifactId> result = new HashSet<ArtifactId>();
        this.jdbcClient.runQuery(stmt -> {
            boolean bl = result.add(ArtifactId.valueOf((Long)stmt.getLong("key")));
        }, OseeSql.LOAD_EXCLUDED_ARTIFACT_IDS.getSql(), new Object[]{branch, view, branch, TxCurrent.NOT_CURRENT});
        return result;
    }
}

