/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.proxy;

import java.util.Map;
import java.util.Objects;
import org.eclipse.osee.framework.core.data.MapEntryAttributeUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.eclipse.osee.framework.jdk.core.util.Zip;
import org.eclipse.osee.orcs.db.internal.proxy.AbstractDataProxy;
import org.eclipse.osee.orcs.db.internal.proxy.Storage;

public class MapEntryDataProxy
extends AbstractDataProxy<Map.Entry<String, String>>
implements org.eclipse.osee.orcs.core.ds.MapEntryDataProxy,
ToMessage {
    private static final String ENCODED_CHARSET_NAME = "";
    private static final String ENCODED_EXTENSION = "zip";
    private static final String ENCODED_MEDIA_TYPE = "application/zip";
    private final MapEntryAttributeUtil.LocalData localData = new MapEntryAttributeUtil.LocalData();

    public void clear() {
        this.localData.clear();
    }

    public String getDisplayableString() {
        this.updateFromDataStore();
        return this.localData.getStorageString();
    }

    public Map.Entry<String, String> getRawValue() {
        this.updateFromDataStore();
        return this.localData.getMapEntry();
    }

    public String getStorageString() {
        if (this.getStorage().isLoadingAllowed()) {
            return ENCODED_CHARSET_NAME;
        }
        this.updateFromDataStore();
        return this.localData.getStorageString();
    }

    @Override
    public String getUri() {
        return super.getUri();
    }

    @Override
    public void persist() {
        super.persist();
    }

    public void setData(Map.Entry<String, String> value, String uri) {
        throw new UnsupportedOperationException();
    }

    public void setDataByObject(Object value, String uri) {
        int state = (MapEntryAttributeUtil.isValidMapEntry((Object)value) ? 1 : 0) + (Strings.isValidAndNonBlank((String)uri) ? 2 : 0) + (Strings.isValidAndNonBlank((Object)value) ? 4 : 0);
        switch (state) {
            case 0: {
                return;
            }
            case 1: {
                Map.Entry valueMapEntry = (Map.Entry)value;
                this.setValue(valueMapEntry);
                return;
            }
            case 2: {
                this.localData.clear();
                this.getStorage().clear();
                this.getStorage().setLocator(uri);
                return;
            }
            case 3: 
            case 6: {
                assert (false) : new Message().title((CharSequence)"MapEntryAttributeDataProvider::loadData, both value and uri are unexpected.").indentInc().segment((CharSequence)"Value", value).segment((CharSequence)"URI", (Object)uri).toString();
                return;
            }
        }
        throw Conditions.invalidCase((Object)state, (String)"state", string -> new OseeCoreException(string, new Object[0]));
    }

    public void setDisplayableString(String toDisplay) {
        throw new UnsupportedOperationException();
    }

    public boolean setValue(Map.Entry<String, String> mapEntry) {
        if (!MapEntryAttributeUtil.isValidMapEntry(mapEntry)) {
            this.localData.clear();
            this.getStorage().clear();
            return false;
        }
        this.updateFromDataStore();
        if (this.localData.isEqual(mapEntry)) {
            return false;
        }
        this.localData.set(mapEntry);
        this.getStorage().clear();
        if (this.localData.size() <= 4000) {
            return true;
        }
        try {
            String filenameForZip = this.getResolver().getInternalFileName();
            byte[] uncompressedBytes = this.localData.getStorageBytes();
            byte[] compressedBytes = Zip.compressBytes((byte[])uncompressedBytes, (String)filenameForZip);
            this.getStorage().clear();
            this.getStorage().setContent(compressedBytes, ENCODED_EXTENSION, ENCODED_MEDIA_TYPE, ENCODED_CHARSET_NAME);
            return true;
        }
        catch (Exception exception) {
            this.localData.clear();
            this.getStorage().clear();
            return false;
        }
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"MapEntryAttributeDataProvider").indentInc();
        if (this.localData.isDataValid()) {
            outMessage.title((CharSequence)"Local data is valid.");
        }
        if (this.getStorage().isLocatorValid()) {
            outMessage.title((CharSequence)"DataStore locator is valid.").indentInc().segment((CharSequence)"locator", (Object)this.getStorage().getLocator()).indentDec();
        }
        if (this.getStorage().isDataValid()) {
            outMessage.title((CharSequence)"DataStore data is valid.");
        }
        return outMessage;
    }

    @Override
    public String toString() {
        return this.toMessage(0, null).toString();
    }

    private void updateFromDataStore() {
        if (this.localData.isDataValid()) {
            return;
        }
        Storage storage = this.getStorage();
        byte[] compressedContent = storage.getContent();
        boolean status = this.localData.setFromCompressed(compressedContent);
        if (!status) {
            storage.clear();
        }
    }
}

