/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.proxy;

import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.Attribute;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.ds.ResourceNameResolver;
import org.eclipse.osee.orcs.db.internal.proxy.Storage;

public abstract class AbstractDataProxy<T>
implements DataProxy<T> {
    private Storage storage;
    private Log logger;
    private GammaId gammaId;
    private boolean isNewGammaId;
    private ResourceNameResolver resolver;
    private Attribute<T> attribute;

    public void setAttribute(Attribute<T> attribute) {
        this.attribute = attribute;
    }

    protected Attribute<T> getAttribute() {
        return this.attribute;
    }

    public String getUri() {
        return this.getStorage().getLocator();
    }

    public void setGamma(GammaId gammaId, boolean isNewGammaId) {
        this.gammaId = gammaId;
        this.isNewGammaId = isNewGammaId;
    }

    public GammaId getGammaId() {
        return this.gammaId;
    }

    public void persist() {
        if (this.isNewGammaId) {
            this.storage.persist(this.gammaId.getId());
        }
    }

    public void rollBack() {
        if (this.isNewGammaId) {
            this.purge();
        }
    }

    protected Storage getStorage() {
        return this.storage;
    }

    protected void setStorage(Storage storage) {
        this.storage = storage;
    }

    protected Log getLogger() {
        return this.logger;
    }

    protected void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setResolver(ResourceNameResolver resolver) {
        this.resolver = resolver;
    }

    protected ResourceNameResolver getResolver() {
        return this.resolver;
    }

    public boolean isInMemory() {
        return this.storage.isInitialized() && this.storage.isDataValid();
    }

    public String toString() {
        return String.format("%s [value:[%s]]", this.getClass().getSimpleName(), this.getDisplayableString());
    }

    public void purge() {
        this.storage.purge();
    }
}

