/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange;

import java.io.File;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.db.internal.exchange.IOseeExchangeDataProvider;
import org.eclipse.osee.orcs.db.internal.exchange.handler.IExportItem;

public class StandardOseeDbExportDataProvider
implements IOseeExchangeDataProvider {
    private final File exportDataRootPath;
    private final boolean wasZipExtractionRequired;
    private final Log logger;
    private final String exchangeBasePath;

    public StandardOseeDbExportDataProvider(String exchangeBasePath, Log logger, File exportDataRootPath, boolean wasZipExtractionRequired) {
        this.exchangeBasePath = exchangeBasePath;
        this.logger = logger;
        this.wasZipExtractionRequired = wasZipExtractionRequired;
        this.exportDataRootPath = exportDataRootPath;
    }

    @Override
    public File getFile(IExportItem item) {
        return this.getFile(item.getFileName());
    }

    @Override
    public File getFile(String fileName) {
        return new File(this.exportDataRootPath, fileName);
    }

    @Override
    public boolean wasZipExtractionRequired() {
        return this.wasZipExtractionRequired;
    }

    @Override
    public File getExportedDataRoot() {
        return this.exportDataRootPath;
    }

    @Override
    public Log getLogger() {
        return this.logger;
    }

    @Override
    public String getExchangeBasePath() {
        return this.exchangeBasePath;
    }
}

