/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.orcs.search.ArtifactIdReportColumn;
import org.eclipse.osee.orcs.search.AttributeReportColumn;
import org.eclipse.osee.orcs.search.ReportColumn;

public final class ExecutedCommandHistory
extends NamedIdBase {
    private final String executedCommandHistory;
    private final String commandHistoryId;
    private String[][] data;
    private List<ReportColumn> columnHeaders;

    public ExecutedCommandHistory(UserToken user, ArtifactReadable executedCommandHx, List<String> headers) {
        super(user.getId(), user.getName());
        this.executedCommandHistory = executedCommandHx.getName();
        this.commandHistoryId = executedCommandHx.getIdString();
        this.setColumnHeaders(this.createColumns(executedCommandHx));
        this.setData(this.createData(executedCommandHx, headers));
    }

    public ExecutedCommandHistory(UserToken user) {
        super(user.getId(), user.getName());
        this.executedCommandHistory = "No history available";
        this.commandHistoryId = "";
        this.columnHeaders = new ArrayList<ReportColumn>();
        this.data = new String[0][0];
    }

    public String getExecutedCommandHistory() {
        return this.executedCommandHistory;
    }

    public String getCommandHistoryId() {
        return this.commandHistoryId;
    }

    public void setColumnHeaders(List<AttributeReportColumn> columns) {
        ArtifactIdReportColumn artifactIdColumn = new ArtifactIdReportColumn();
        ArrayList<ReportColumn> headers = new ArrayList<ReportColumn>();
        headers.add((ReportColumn)artifactIdColumn);
        headers.addAll(columns);
        this.columnHeaders = headers;
    }

    public List<ReportColumn> getColumns() {
        return this.columnHeaders;
    }

    private void setData(String[][] createdData) {
        this.data = createdData;
    }

    public String[][] getData() {
        return this.data;
    }

    private List<AttributeReportColumn> createColumns(ArtifactReadable executedCommandHistory) {
        ArrayList<AttributeReportColumn> attributeColumns = new ArrayList<AttributeReportColumn>();
        if (!executedCommandHistory.getRelated(CoreRelationTypes.DefaultHierarchical_Child, ArtifactTypeToken.SENTINEL).isEmpty()) {
            ArtifactReadable executedCommand = (ArtifactReadable)executedCommandHistory.getRelated(CoreRelationTypes.DefaultHierarchical_Child, ArtifactTypeToken.SENTINEL).get(0);
            Collection attributeList = executedCommand.getExistingAttributeTypes();
            attributeList.forEach(column -> {
                boolean bl = attributeColumns.add(new AttributeReportColumn(column));
            });
        }
        return attributeColumns;
    }

    private String[][] createData(ArtifactReadable executedCommandHistory, List<String> columns) {
        if (!executedCommandHistory.getRelated(CoreRelationTypes.DefaultHierarchical_Child, ArtifactTypeToken.SENTINEL).isEmpty()) {
            List executedCommandList = executedCommandHistory.getRelated(CoreRelationTypes.DefaultHierarchical_Child, ArtifactTypeToken.SENTINEL).stream().map(executedCommand -> this.createRowData((ArtifactReadable)executedCommand)).collect(Collectors.toList());
            this.data = new String[executedCommandList.size()][columns.size()];
            int i = 0;
            while (i < executedCommandList.size()) {
                this.data[i] = (String[])executedCommandList.get(i);
                ++i;
            }
            return this.data;
        }
        this.data = new String[0][0];
        return this.data;
    }

    private String[] createRowData(ArtifactReadable command) {
        String[] arrayEl = new String[]{command.getIdString(), command.getName(), command.getAttributeValuesAsString((AttributeTypeToken)CoreAttributeTypes.ParameterizedCommand), command.getAttributeValuesAsString((AttributeTypeToken)CoreAttributeTypes.ExecutionFrequency), command.getAttributeValuesAsString((AttributeTypeToken)CoreAttributeTypes.CommandTimestamp), command.getAttributeValuesAsString((AttributeTypeToken)CoreAttributeTypes.IsValidated), command.getAttributeValuesAsString((AttributeTypeToken)CoreAttributeTypes.Favorite)};
        return arrayEl;
    }
}

