/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.orcs.rest.model.CommandParameter;

public class CommandsRelatedToContext
extends NamedIdBase {
    private final String contextGroup;
    private Map<String, String> attributes;
    private CommandParameter parameter;

    public CommandsRelatedToContext() {
        this.contextGroup = "";
    }

    public CommandsRelatedToContext(ArtifactReadable command, ArtifactReadable context) {
        super(command.getId(), command.getName());
        this.contextGroup = context.getName();
        this.setAttributes(this.createAttributeMap(command));
        this.setParameter(this.createParameter(command));
    }

    public String getContextGroup() {
        return this.contextGroup;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public CommandParameter getParameter() {
        return this.parameter;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setParameter(CommandParameter parameter) {
        this.parameter = parameter;
    }

    private Map<String, String> createAttributeMap(ArtifactReadable command) {
        HashMap<String, String> collectedAttributes = new HashMap<String, String>();
        if (!command.getExistingAttributeTypes().isEmpty()) {
            Collection types = command.getExistingAttributeTypes();
            for (AttributeTypeToken type : types) {
                if (!type.notEqual((Id)CoreAttributeTypes.Name)) continue;
                collectedAttributes.put(type.getName().toLowerCase(), command.getAttributeValuesAsString(type));
            }
        }
        return collectedAttributes;
    }

    private CommandParameter createParameter(ArtifactReadable command) {
        if (!command.getRelated(CoreRelationTypes.DefaultHierarchical_Child, ArtifactTypeToken.SENTINEL).isEmpty()) {
            List paramList = command.getRelated(CoreRelationTypes.DefaultHierarchical_Child, ArtifactTypeToken.SENTINEL).stream().map(param -> new CommandParameter((ArtifactReadable)param)).collect(Collectors.toList());
            CommandParameter parameter = (CommandParameter)((Object)paramList.get(0));
            return parameter;
        }
        return CommandParameter.SENTINEL;
    }
}

