/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;

public class CommandParameter
extends NamedIdBase {
    public static final CommandParameter SENTINEL = new CommandParameter();
    public String type;
    private Map<String, String> attributes;

    public CommandParameter() {
    }

    public CommandParameter(ArtifactReadable parameter) {
        super(parameter.getId(), parameter.getName());
        this.type = parameter.getArtifactType().toString();
        this.setAttributes(this.createAttributeMap(parameter));
    }

    public String getTypeAsString() {
        return this.type;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    private Map<String, String> createAttributeMap(ArtifactReadable parameter) {
        HashMap<String, String> collectedAttributes = new HashMap<String, String>();
        Collection types = parameter.getExistingAttributeTypes();
        for (AttributeTypeToken type : types) {
            if (!type.notEqual((Id)CoreAttributeTypes.Name)) continue;
            collectedAttributes.put(type.getName().toLowerCase(), parameter.getAttributeValuesAsString(type));
        }
        return collectedAttributes;
    }
}

