/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionResult;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.model.transaction.AddRelation;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionBuilderData;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionBuilderDataFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.testscript.ScriptDefApi;
import org.eclipse.osee.testscript.TmoImportApi;
import org.eclipse.osee.testscript.internal.ImportTmoReader;
import org.eclipse.osee.testscript.internal.ScriptBatchToken;
import org.eclipse.osee.testscript.internal.ScriptDefToken;
import org.eclipse.osee.testscript.internal.ScriptResultToken;
import org.eclipse.osee.testscript.internal.TmoImportResult;

public class TmoImportApiImpl
implements TmoImportApi {
    private final OrcsApi orcsApi;
    private final ScriptDefApi scriptDefApi;
    private int keyIndex = 0;

    public TmoImportApiImpl(OrcsApi orcsApi, ScriptDefApi scriptDefApi) {
        this.orcsApi = orcsApi;
        this.scriptDefApi = scriptDefApi;
    }

    @Override
    public ScriptDefToken getScriptDefinition(InputStream stream, ArtifactId ciSetId) {
        return new ImportTmoReader().getScriptDefinition(stream, ciSetId);
    }

    @Override
    public ScriptDefToken getScriptDefinition(File file, ArtifactId ciSetId) {
        return new ImportTmoReader().getScriptDefinition(file, ciSetId);
    }

    @Override
    public TransactionBuilderData getTxBuilderData(BranchId branch, ScriptDefToken scriptDef) {
        return this.getTxBuilderData(branch, scriptDef, true);
    }

    @Override
    public TransactionBuilderData getTxBuilderData(BranchId branch, ScriptDefToken scriptDef, boolean resetKey) {
        String scriptDefKey;
        ScriptDefToken existingDef;
        TransactionBuilderData data = new TransactionBuilderData();
        data.setBranch(branch.getIdString());
        data.setTxComment("TMO Import");
        data.setCreateArtifacts(new LinkedList());
        data.setAddRelations(new LinkedList());
        if (resetKey) {
            this.keyIndex = 0;
        }
        if ((existingDef = this.scriptDefApi.getAllByFilter(branch, scriptDef.getFullScriptName(), Arrays.asList(CoreAttributeTypes.ScriptName)).stream().filter(def -> def.getFullScriptName().equals(scriptDef.getFullScriptName())).findFirst().orElse(ScriptDefToken.SENTINEL)).isValid()) {
            scriptDefKey = existingDef.getArtifactId().getIdString();
        } else {
            scriptDefKey = this.getKey();
            CreateArtifact scriptDefArtifact = scriptDef.createArtifact(scriptDefKey);
            data.getCreateArtifacts().add(scriptDefArtifact);
        }
        ScriptResultToken scriptResult = scriptDef.getScriptResults().get(0);
        CreateArtifact scriptResultArtifact = scriptResult.createArtifact(this.getKey());
        data.getCreateArtifacts().add(scriptResultArtifact);
        data.getAddRelations().add(this.createAddRelation(CoreRelationTypes.TestScriptDefToTestScriptResults, scriptDefKey, scriptResultArtifact.getKey()));
        return data;
    }

    @Override
    public TmoImportResult importFile(InputStream stream, BranchId branch, ArtifactId ciSetId) {
        TransactionResult txResult = new TransactionResult();
        XResultData resultData = new XResultData();
        txResult.setResults(resultData);
        TmoImportResult result = new TmoImportResult(txResult);
        File file = this.getTempFile(ciSetId);
        try {
            Lib.inputStreamToFile((InputStream)stream, (File)file);
        }
        catch (IOException iOException) {
            if (file != null && file.exists()) {
                file.delete();
            }
            resultData.error("Error reading uploaded file");
            return result;
        }
        ScriptDefToken scriptDef = this.getScriptDefinition(file, ciSetId);
        if (scriptDef.getScriptResults().isEmpty()) {
            if (file != null && file.exists()) {
                file.delete();
            }
            resultData.error("Error parsing TMO");
            return result;
        }
        ScriptResultToken scriptResult = scriptDef.getScriptResults().get(0);
        String zipPathString = String.valueOf(this.getFolderPath(ciSetId)) + scriptDef.getName() + "_" + scriptResult.getExecutionDate().getTime() + ".zip";
        scriptResult.setFileUrl(zipPathString);
        File zipPath = new File(zipPathString);
        if (zipPath.exists()) {
            if (file != null && file.exists()) {
                file.delete();
            }
            resultData.error(String.valueOf(scriptDef.getName()) + "_" + scriptResult.getExecutionDate().getTime() + ".zip" + " already exists in CI Set " + ciSetId + ". Did not create artifacts.");
            return result;
        }
        try {
            this.moveFileToZip(file, zipPath, scriptDef);
        }
        catch (IOException iOException) {
            resultData.error("Error creating zip file");
            if (file != null && file.exists()) {
                file.delete();
            }
            if (zipPath.exists()) {
                zipPath.delete();
            }
            this.keyIndex = 0;
            return result;
        }
        ObjectMapper mapper = new ObjectMapper();
        TransactionBuilderDataFactory txBdf = new TransactionBuilderDataFactory(this.orcsApi);
        TransactionBuilderData txData = this.getTxBuilderData(branch, scriptDef);
        try {
            TransactionBuilder tx = txBdf.loadFromJson(mapper.writeValueAsString((Object)txData));
            TransactionToken token = tx.commit();
            txResult.setTx(token);
            resultData.setIds(tx.getTxDataReadables().stream().map(readable -> readable.getIdString()).collect(Collectors.toList()));
        }
        catch (JsonProcessingException jsonProcessingException) {
            resultData.error("Error processing tx json");
        }
        if (txResult.isFailed() && zipPath.exists()) {
            zipPath.delete();
        }
        return result;
    }

    @Override
    public TmoImportResult importBatch(InputStream stream, BranchId branch, ArtifactId ciSetId) {
        String batchId = String.valueOf(System.currentTimeMillis() + (long)((int)(Math.random() * 100.0)));
        String testEnvBatchId = "";
        LinkedList<String> fileNames = new LinkedList<String>();
        Date batchExecutionDate = new Date();
        String batchMachineName = "";
        SimpleDateFormat executionDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a");
        TransactionBuilderDataFactory txBdf = new TransactionBuilderDataFactory(this.orcsApi);
        TransactionBuilder tx = null;
        TransactionResult txResult = new TransactionResult();
        XResultData resultData = new XResultData();
        txResult.setResults(resultData);
        TmoImportResult result = new TmoImportResult(txResult);
        String batchFolderPath = this.getFolderPath(ciSetId, batchId);
        ObjectMapper mapper = new ObjectMapper();
        try {
            Throwable throwable = null;
            Object var18_20 = null;
            try (ZipInputStream zipStream = new ZipInputStream(stream);){
                ZipEntry zipEntry = null;
                while ((zipEntry = zipStream.getNextEntry()) != null) {
                    if (zipEntry.getName().equals("runId.txt")) {
                        testEnvBatchId = new String(zipStream.readAllBytes()).trim();
                        continue;
                    }
                    if (!zipEntry.getName().toLowerCase().endsWith(".tmo")) continue;
                    File file = this.getTempFile(ciSetId);
                    try {
                        Object object = null;
                        Object var23_27 = null;
                        try (FileOutputStream outputStream = new FileOutputStream(file);){
                            Lib.inputStreamToOutputStream((InputStream)zipStream, (OutputStream)outputStream);
                        }
                        catch (Throwable throwable2) {
                            if (object == null) {
                                object = throwable2;
                            } else if (object != throwable2) {
                                ((Throwable)object).addSuppressed(throwable2);
                            }
                            throw object;
                        }
                    }
                    catch (IOException iOException) {
                        if (file != null && file.exists()) {
                            file.delete();
                        }
                        resultData.addRaw("Error reading uploaded file");
                        continue;
                    }
                    ScriptDefToken scriptDef = this.getScriptDefinition(file, ciSetId);
                    if (scriptDef.getScriptResults().isEmpty()) {
                        if (file != null && file.exists()) {
                            file.delete();
                        }
                        resultData.addRaw("Error parsing " + scriptDef.getName() + ".tmo");
                        continue;
                    }
                    ScriptResultToken scriptResult = scriptDef.getScriptResults().get(0);
                    File batchFolder = new File(batchFolderPath);
                    if (!batchFolder.exists()) {
                        batchFolder.mkdirs();
                    }
                    String zipPathString = String.valueOf(batchFolderPath) + scriptDef.getName() + "_" + scriptResult.getExecutionDate().getTime() + ".zip";
                    scriptResult.setFileUrl(zipPathString);
                    File zipPath = new File(zipPathString);
                    if (zipPath.exists()) {
                        if (file != null && file.exists()) {
                            file.delete();
                        }
                        resultData.addRaw(String.valueOf(scriptDef.getName()) + " TMO already exists. Did not create artifacts.");
                        continue;
                    }
                    try {
                        this.moveFileToZip(file, zipPath, scriptDef);
                    }
                    catch (IOException iOException) {
                        if (file != null && file.exists()) {
                            file.delete();
                        }
                        if (zipPath.exists()) {
                            zipPath.delete();
                        }
                        resultData.addRaw("Error creating zip file for " + scriptDef.getName());
                        continue;
                    }
                    fileNames.add(zipPathString);
                    TransactionBuilderData txData = this.getTxBuilderData(branch, scriptDef, false);
                    try {
                        tx = tx == null ? txBdf.loadFromJson(mapper.writeValueAsString((Object)txData)) : txBdf.loadFromJson(mapper.writeValueAsString((Object)txData), tx);
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        resultData.error("Error processing tx json");
                    }
                    batchExecutionDate = scriptResult.getExecutionDate().before(batchExecutionDate) ? scriptResult.getExecutionDate() : batchExecutionDate;
                    batchMachineName = scriptResult.getMachineName();
                }
                if (!testEnvBatchId.isEmpty() && tx != null) {
                    TransactionBuilderData batchTxData = new TransactionBuilderData();
                    batchTxData.setBranch(branch.getIdString());
                    batchTxData.setTxComment("TMO Import");
                    batchTxData.setCreateArtifacts(new LinkedList());
                    batchTxData.setAddRelations(new LinkedList());
                    ScriptBatchToken scriptBatch = new ScriptBatchToken(-1L, String.valueOf(executionDateFormat.format(batchExecutionDate)) + " - " + batchMachineName);
                    scriptBatch.setExecutionDate(batchExecutionDate);
                    scriptBatch.setMachineName(batchMachineName);
                    scriptBatch.setBatchId(batchId);
                    scriptBatch.setTestEnvBatchId(testEnvBatchId);
                    scriptBatch.setFolderUrl(batchFolderPath);
                    CreateArtifact batchArt = scriptBatch.createArtifact(this.getKey());
                    batchTxData.getCreateArtifacts().add(batchArt);
                    List resultIds = tx.getTxDataReadables().stream().filter(art -> art.getArtifactType().equals(CoreArtifactTypes.TestScriptResults)).map(art -> art.getIdString()).collect(Collectors.toList());
                    for (String id : resultIds) {
                        batchTxData.getAddRelations().add(this.createAddRelation(CoreRelationTypes.ScriptBatchToTestScriptResult, batchArt.getKey(), id));
                    }
                    batchTxData.getAddRelations().add(this.createAddRelation(CoreRelationTypes.ScriptSetToScriptBatch, ciSetId.getIdString(), batchArt.getKey()));
                    try {
                        tx = txBdf.loadFromJson(mapper.writeValueAsString((Object)batchTxData), tx);
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        resultData.error("Error processing batch tx json");
                    }
                }
                if (tx != null) {
                    TransactionToken token = tx.commit();
                    txResult.setTx(token);
                    resultData.setIds(tx.getTxDataReadables().stream().map(readable -> readable.getIdString()).collect(Collectors.toList()));
                }
                if (txResult.isFailed()) {
                    for (String fileName : fileNames) {
                        File f = new File(fileName);
                        if (!f.exists()) continue;
                        f.delete();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
        this.keyIndex = 0;
        return result;
    }

    private String getFolderPath(ArtifactId ciSetId) {
        String basePath = this.orcsApi.getSystemProperties().getValue("osee.application.server.data");
        return String.valueOf(basePath) + File.separator + "testscripts" + File.separator + ciSetId.getIdString() + File.separator;
    }

    private String getFolderPath(ArtifactId ciSetId, String batchId) {
        String basePath = this.orcsApi.getSystemProperties().getValue("osee.application.server.data");
        return String.valueOf(basePath) + File.separator + "testscripts" + File.separator + ciSetId.getIdString() + File.separator + batchId + File.separator;
    }

    private File getTempFile(ArtifactId ciSetId) {
        String folderPath = this.getFolderPath(ciSetId);
        File ciSetFolder = new File(folderPath);
        if (!ciSetFolder.exists()) {
            ciSetFolder.mkdirs();
        }
        String fileName = String.valueOf(System.currentTimeMillis() + (long)((int)(Math.random() * 100.0))) + ".tmo";
        File file = new File(String.valueOf(folderPath) + fileName);
        return file;
    }

    private void moveFileToZip(File file, File zipPath, ScriptDefToken scriptDef) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create("jar:" + Paths.get(zipPath.getAbsolutePath(), new String[0]).toUri());
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileSystem fs = FileSystems.newFileSystem(uri, env);){
            Path nf = fs.getPath(String.valueOf(scriptDef.getName()) + ".tmo", new String[0]);
            Files.move(Paths.get(file.getAbsolutePath(), new String[0]), nf, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getKey() {
        ++this.keyIndex;
        return "key" + this.keyIndex;
    }

    private AddRelation createAddRelation(RelationTypeToken relType, String artAId, String artBId) {
        AddRelation rel = new AddRelation();
        rel.setTypeId(relType.getIdString());
        rel.setaArtId(artAId);
        rel.setbArtId(artBId);
        return rel;
    }
}

