/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeDouble;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;
import org.eclipse.osee.testscript.internal.AttentionLocationToken;
import org.eclipse.osee.testscript.internal.ScriptLogToken;
import org.eclipse.osee.testscript.internal.TestPointToken;
import org.eclipse.osee.testscript.internal.TraceToken;

public class TestCaseToken
extends ArtifactAccessorResultWithoutGammas {
    public static final TestCaseToken SENTINEL = new TestCaseToken();
    private Double testNumber;
    private List<TestPointToken> testPoints;
    private List<AttentionLocationToken> attentionMessages;
    private List<ScriptLogToken> logs;
    private List<TraceToken> trace;
    private boolean isInitial = false;
    private boolean isCleanup = false;

    public TestCaseToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public TestCaseToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(art.getName());
        this.setTestNumber((Double)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.TestNumber, (Object)0.0));
        this.setInitial(art.getArtifactType().equals(CoreArtifactTypes.TestCaseInitial));
        this.setCleanup(art.getArtifactType().equals(CoreArtifactTypes.TestCaseCleanup));
        this.setTestPoints(art.getRelated(CoreRelationTypes.TestCaseToTestPoint_TestPoint).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new TestPointToken((ArtifactReadable)a)).collect(Collectors.toList()));
        this.setAttentionMessages(art.getRelated(CoreRelationTypes.TestCaseToAttentionLocation_AttentionLocation).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new AttentionLocationToken((ArtifactReadable)a)).collect(Collectors.toList()));
        this.setLogs(art.getRelated(CoreRelationTypes.TestCaseToScriptLog_ScriptLog).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new ScriptLogToken((ArtifactReadable)a)).collect(Collectors.toList()));
        this.setTrace(art.getRelated(CoreRelationTypes.TestCaseToTrace_Trace).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new TraceToken((ArtifactReadable)a)).collect(Collectors.toList()));
    }

    public TestCaseToken(Long id, String name) {
        super(id, name);
        this.setTestNumber(0.0);
        this.setTestPoints(new LinkedList<TestPointToken>());
        this.setAttentionMessages(new LinkedList<AttentionLocationToken>());
        this.setLogs(new LinkedList<ScriptLogToken>());
        this.setTrace(new LinkedList<TraceToken>());
    }

    public TestCaseToken() {
    }

    public Double getTestNumber() {
        return this.testNumber;
    }

    public void setTestNumber(Double testNumber) {
        this.testNumber = testNumber;
    }

    public List<TestPointToken> getTestPoints() {
        return this.testPoints;
    }

    public void setTestPoints(List<TestPointToken> testPoints) {
        this.testPoints = testPoints;
    }

    @JsonIgnore
    public List<AttentionLocationToken> getAttentionMessages() {
        return this.attentionMessages;
    }

    public void setAttentionMessages(List<AttentionLocationToken> attentionMessages) {
        this.attentionMessages = attentionMessages;
    }

    @JsonIgnore
    public List<ScriptLogToken> getLogs() {
        return this.logs;
    }

    public void setLogs(List<ScriptLogToken> logs) {
        this.logs = logs;
    }

    @JsonIgnore
    public List<TraceToken> getTrace() {
        return this.trace;
    }

    public void setTrace(List<TraceToken> trace) {
        this.trace = trace;
    }

    @JsonIgnore
    public boolean isInitial() {
        return this.isInitial;
    }

    public void setInitial(boolean isInitial) {
        this.isInitial = isInitial;
    }

    @JsonIgnore
    public boolean isCleanup() {
        return this.isCleanup;
    }

    public void setCleanup(boolean isCleanup) {
        this.isCleanup = isCleanup;
    }

    public CreateArtifact createArtifact(String key) {
        HashMap<AttributeTypeDouble, String> values = new HashMap<AttributeTypeDouble, String>();
        values.put(CoreAttributeTypes.TestNumber, Double.toString(this.getTestNumber()));
        CreateArtifact art = new CreateArtifact();
        art.setName(this.getName());
        ArtifactTypeToken artType = CoreArtifactTypes.ScriptTestCase;
        if (this.isInitial()) {
            artType = CoreArtifactTypes.TestCaseInitial;
        }
        if (this.isCleanup()) {
            artType = CoreArtifactTypes.TestCaseCleanup;
        }
        art.setTypeId(artType.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : artType.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setkey(key);
        return art;
    }
}

