/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.testscript.TestCaseApi;
import org.eclipse.osee.testscript.TestCaseEndpoint;
import org.eclipse.osee.testscript.internal.TestCaseToken;

public class TestCaseEndpointImpl
implements TestCaseEndpoint {
    private final TestCaseApi testCaseTypeApi;
    private final BranchId branch;

    public TestCaseEndpointImpl(BranchId branch, TestCaseApi testCaseTypeApi) {
        this.testCaseTypeApi = testCaseTypeApi;
        this.branch = branch;
    }

    @Override
    public Collection<TestCaseToken> getAllTestCaseTypes(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        ArtifactId artifactId = viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        if (Strings.isValid((String)filter)) {
            return this.testCaseTypeApi.getAllByFilter(this.branch, viewId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        }
        return this.testCaseTypeApi.getAll(this.branch, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public TestCaseToken getTestCaseType(ArtifactId testCaseTypeId) {
        return this.testCaseTypeApi.get(this.branch, testCaseTypeId);
    }

    @Override
    public int getCount(String filter, ArtifactId viewId) {
        return this.testCaseTypeApi.getCountWithFilter(this.branch, viewId, filter);
    }
}

