/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;
import org.eclipse.osee.testscript.internal.AttentionLocationToken;
import org.eclipse.osee.testscript.internal.LoggingSummaryToken;
import org.eclipse.osee.testscript.internal.ScriptLogToken;
import org.eclipse.osee.testscript.internal.TestCaseToken;
import org.eclipse.osee.testscript.internal.TestPointToken;
import org.eclipse.osee.testscript.internal.VersionInformationToken;

public class ScriptResultToken
extends ArtifactAccessorResultWithoutGammas {
    public static final ScriptResultToken SENTINEL = new ScriptResultToken();
    private String fileUrl;
    private String setId;
    private String processorId;
    private Date executionDate;
    private String executionEnvironment;
    private String machineName;
    private int passedCount;
    private int failedCount;
    private int interactiveCount;
    private boolean scriptAborted;
    private int elapsedTime;
    private Date startDate;
    private Date endDate;
    private String osArchitecture;
    private String osName;
    private String osVersion;
    private String oseeServerJar;
    private String oseeServer;
    private String oseeVersion;
    private String javaVersion;
    private String result;
    private int scriptHealth;
    private String qualificationLevel;
    private String executedBy;
    private String userId;
    private String userName;
    private String email;
    private int totalTestPoints;
    private List<String> witnesses;
    private List<String> runtimeVersions;
    private List<TestCaseToken> testCases;
    private List<TestPointToken> testPoints;
    private List<AttentionLocationToken> attentionMessages;
    private List<ScriptLogToken> logs;
    private List<VersionInformationToken> versionInformation;
    private List<LoggingSummaryToken> loggingSummaries;
    private ArtifactId definitionId = ArtifactId.SENTINEL;

    public ScriptResultToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public ScriptResultToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(art.getName());
        this.setFileUrl(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ContentUrl, ""));
        this.setSetId((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.SetId, (Object)""));
        this.setProcessorId(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ProcessorId, ""));
        this.setExecutionDate((Date)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ExecutionDate, (Object)new Date()));
        this.setExecutionEnvironment(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ExecutionEnvironment, ""));
        this.setMachineName(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.MachineName, ""));
        this.setPassedCount((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.PassedCount, (Object)0));
        this.setFailedCount((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.FailedCount, (Object)0));
        this.setInteractiveCount((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InteractiveCount, (Object)0));
        this.setScriptAborted((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ScriptAborted, (Object)false));
        this.setElapsedTime((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ElapsedTime, (Object)0));
        this.setStartDate((Date)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.StartDate, (Object)new Date()));
        this.setEndDate((Date)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.EndDate, (Object)new Date()));
        this.setOsArchitecture(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.OsArchitecture, ""));
        this.setOsName(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.OsName, ""));
        this.setOsVersion(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.OsVersion, ""));
        this.setOseeServerJar(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.OseeServerJarVersion, ""));
        this.setOseeServer(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.OseeServerTitle, ""));
        this.setOseeVersion(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.OseeVersion, ""));
        this.setJavaVersion(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.JavaVersion, ""));
        this.setResult(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Result, ""));
        this.setScriptHealth((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ScriptHealth, (Object)0));
        this.setQualificationLevel(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.QualificationLevel, ""));
        this.setExecutedBy(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ExecutedBy, ""));
        this.setUserId(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.UserId, ""));
        this.setUserName(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.UserName, ""));
        this.setEmail(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Email, ""));
        this.setWitnesses(art.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.Witness));
        this.setRuntimeVersions(art.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.RuntimeVersion));
        this.setTestCases(art.getRelated(CoreRelationTypes.TestScriptResultsToTestCase_TestCase).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new TestCaseToken((ArtifactReadable)a)).collect(Collectors.toList()));
        this.setTestPoints(art.getRelated(CoreRelationTypes.TestScriptResultsToTestPoint_TestPoint).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new TestPointToken((ArtifactReadable)a)).collect(Collectors.toList()));
        this.setAttentionMessages(art.getRelated(CoreRelationTypes.TestScriptResultsToAttentionMessage_AttentionMessage).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new AttentionLocationToken((ArtifactReadable)a)).collect(Collectors.toList()));
        this.setLogs(art.getRelated(CoreRelationTypes.TestScriptResultsToScriptLog_ScriptLog).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new ScriptLogToken((ArtifactReadable)a)).collect(Collectors.toList()));
        this.setVersionInformation(art.getRelated(CoreRelationTypes.TestScriptResultsToVersionInformation_VersionInformation).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new VersionInformationToken((ArtifactReadable)a)).collect(Collectors.toList()));
        this.setLoggingSummaries(art.getRelated(CoreRelationTypes.TestScriptResultsToLoggingSummary_LoggingSummary).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new LoggingSummaryToken((ArtifactReadable)a)).collect(Collectors.toList()));
        this.setTotalTestPoints(this.getTestPoints().size());
        this.setDefinitionId(((ArtifactReadable)this.getArtifactReadable().getRelated(CoreRelationTypes.TestScriptDefToTestScriptResults_TestScriptDef).getOneOrDefault((Object)ArtifactReadable.SENTINEL)).getArtifactId());
    }

    public ScriptResultToken(Long id, String name) {
        super(id, name);
        this.setFileUrl("");
        this.setSetId("");
        this.setProcessorId("");
        this.setExecutionDate(new Date());
        this.setExecutionEnvironment("");
        this.setMachineName("");
        this.setPassedCount(0);
        this.setFailedCount(0);
        this.setInteractiveCount(0);
        this.setScriptAborted(false);
        this.setElapsedTime(0);
        this.setStartDate(new Date());
        this.setEndDate(new Date());
        this.setOsArchitecture("");
        this.setOsName("");
        this.setOsVersion("");
        this.setOseeServerJar("");
        this.setOseeServer("");
        this.setOseeVersion("");
        this.setJavaVersion("");
        this.setResult("");
        this.setScriptHealth(-1);
        this.setQualificationLevel("");
        this.setExecutedBy("");
        this.setUserId("");
        this.setUserName("");
        this.setEmail("");
        this.setTotalTestPoints(0);
        this.setWitnesses(new LinkedList<String>());
        this.setRuntimeVersions(new LinkedList<String>());
        this.setTestCases(new LinkedList<TestCaseToken>());
        this.setTestPoints(new LinkedList<TestPointToken>());
        this.setAttentionMessages(new LinkedList<AttentionLocationToken>());
        this.setLogs(new LinkedList<ScriptLogToken>());
        this.setVersionInformation(new LinkedList<VersionInformationToken>());
        this.setLoggingSummaries(new LinkedList<LoggingSummaryToken>());
    }

    public ScriptResultToken() {
    }

    @JsonIgnore
    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getSetId() {
        return this.setId;
    }

    public void setSetId(String setId) {
        this.setId = setId;
    }

    public String getProcessorId() {
        return this.processorId;
    }

    public void setProcessorId(String processorId) {
        this.processorId = processorId;
    }

    @JsonIgnore
    public List<String> getRuntimeVersions() {
        return this.runtimeVersions;
    }

    public void setRuntimeVersions(List<String> runtimeVersions) {
        this.runtimeVersions = runtimeVersions;
    }

    public Date getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = executionDate;
    }

    public String getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void setExecutionEnvironment(String executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public void setMachineName(String machine) {
        this.machineName = machine;
    }

    public int getPassedCount() {
        return this.passedCount;
    }

    public void setPassedCount(int passedCount) {
        this.passedCount = passedCount;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public void setFailedCount(int failedCount) {
        this.failedCount = failedCount;
    }

    public int getInteractiveCount() {
        return this.interactiveCount;
    }

    public void setInteractiveCount(int interactiveCount) {
        this.interactiveCount = interactiveCount;
    }

    public boolean getScriptAborted() {
        return this.scriptAborted;
    }

    public void setScriptAborted(boolean scriptAborted) {
        this.scriptAborted = scriptAborted;
    }

    public int getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(int elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getOsArchitecture() {
        return this.osArchitecture;
    }

    public void setOsArchitecture(String osArchitecture) {
        this.osArchitecture = osArchitecture;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getOseeServerJar() {
        return this.oseeServerJar;
    }

    public void setOseeServerJar(String oseeServerJar) {
        this.oseeServerJar = oseeServerJar;
    }

    public String getOseeServer() {
        return this.oseeServer;
    }

    public void setOseeServer(String oseeServer) {
        this.oseeServer = oseeServer;
    }

    public String getOseeVersion() {
        return this.oseeVersion;
    }

    public void setOseeVersion(String oseeVersion) {
        this.oseeVersion = oseeVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public int getScriptHealth() {
        return this.scriptHealth;
    }

    public void setScriptHealth(int scriptHealth) {
        this.scriptHealth = scriptHealth;
    }

    public String getQualificationLevel() {
        return this.qualificationLevel;
    }

    public void setQualificationLevel(String qualification) {
        this.qualificationLevel = qualification;
    }

    public String getExecutedBy() {
        return this.executedBy;
    }

    public void setExecutedBy(String executedBy) {
        this.executedBy = executedBy;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public List<String> getWitnesses() {
        return this.witnesses;
    }

    public void setWitnesses(List<String> witnesses) {
        this.witnesses = witnesses;
    }

    @JsonIgnore
    public List<TestCaseToken> getTestCases() {
        return this.testCases;
    }

    public void setTestCases(List<TestCaseToken> testCases) {
        this.testCases = testCases;
    }

    public List<TestPointToken> getTestPoints() {
        return this.testPoints;
    }

    public void setTestPoints(List<TestPointToken> testPoints) {
        this.testPoints = testPoints;
    }

    @JsonIgnore
    public List<AttentionLocationToken> getAttentionMessages() {
        return this.attentionMessages;
    }

    public void setAttentionMessages(List<AttentionLocationToken> attentionMessages) {
        this.attentionMessages = attentionMessages;
    }

    @JsonIgnore
    public List<ScriptLogToken> getLogs() {
        return this.logs;
    }

    public void setLogs(List<ScriptLogToken> logs) {
        this.logs = logs;
    }

    @JsonIgnore
    public List<VersionInformationToken> getVersionInformation() {
        return this.versionInformation;
    }

    public void setVersionInformation(List<VersionInformationToken> versionInformation) {
        this.versionInformation = versionInformation;
    }

    @JsonIgnore
    public List<LoggingSummaryToken> getLoggingSummaries() {
        return this.loggingSummaries;
    }

    public void setLoggingSummaries(List<LoggingSummaryToken> loggingSummaries) {
        this.loggingSummaries = loggingSummaries;
    }

    public int getTotalTestPoints() {
        return this.totalTestPoints;
    }

    public void setTotalTestPoints(int totalTestPoints) {
        this.totalTestPoints = totalTestPoints;
    }

    public ArtifactId getDefinitionId() {
        return this.definitionId;
    }

    private void setDefinitionId(ArtifactId id) {
        this.definitionId = id;
    }

    public CreateArtifact createArtifact(String key) {
        Attribute attr;
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put(CoreAttributeTypes.ContentUrl, this.getFileUrl());
        values.put(CoreAttributeTypes.ElapsedTime, Integer.toString(this.getElapsedTime()));
        values.put(CoreAttributeTypes.Email, this.getEmail());
        values.put(CoreAttributeTypes.EndDate, Long.toString(this.getEndDate().getTime()));
        values.put(CoreAttributeTypes.ExecutedBy, this.getExecutedBy());
        values.put(CoreAttributeTypes.ExecutionDate, Long.toString(this.getExecutionDate().getTime()));
        values.put(CoreAttributeTypes.ExecutionEnvironment, this.getExecutionEnvironment());
        values.put(CoreAttributeTypes.FailedCount, Integer.toString(this.getFailedCount()));
        values.put(CoreAttributeTypes.InteractiveCount, Integer.toString(this.getInteractiveCount()));
        values.put(CoreAttributeTypes.MachineName, this.getMachineName());
        values.put(CoreAttributeTypes.OsArchitecture, this.getOsArchitecture());
        values.put(CoreAttributeTypes.OsName, this.getOsName());
        values.put(CoreAttributeTypes.OsVersion, this.getOsVersion());
        values.put(CoreAttributeTypes.OseeServerJarVersion, this.getOseeServerJar());
        values.put(CoreAttributeTypes.OseeServerTitle, this.getOseeServer());
        values.put(CoreAttributeTypes.OseeVersion, this.getOseeVersion());
        values.put(CoreAttributeTypes.JavaVersion, this.getJavaVersion());
        values.put(CoreAttributeTypes.PassedCount, Integer.toString(this.getPassedCount()));
        values.put(CoreAttributeTypes.ProcessorId, this.getProcessorId());
        values.put(CoreAttributeTypes.QualificationLevel, this.getQualificationLevel());
        values.put(CoreAttributeTypes.Result, this.getResult());
        values.put(CoreAttributeTypes.ScriptAborted, Boolean.toString(this.getScriptAborted()));
        values.put(CoreAttributeTypes.ScriptHealth, Integer.toString(this.getScriptHealth()));
        values.put(CoreAttributeTypes.SetId, this.getSetId());
        values.put(CoreAttributeTypes.StartDate, Long.toString(this.getStartDate().getTime()));
        values.put(CoreAttributeTypes.UserId, this.getUserId());
        values.put(CoreAttributeTypes.UserName, this.getUserName());
        CreateArtifact art = new CreateArtifact();
        art.setName(this.getName());
        art.setTypeId(CoreArtifactTypes.TestScriptResults.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.TestScriptResults.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr2 = new Attribute(type.getIdString());
            attr2.setValue(Arrays.asList(value));
            attrs.add(attr2);
        }
        if (this.getWitnesses().size() > 0) {
            attr = new Attribute(CoreAttributeTypes.Witness.getIdString());
            attr.setValue(this.getWitnesses());
            attrs.add(attr);
        }
        if (this.getRuntimeVersions().size() > 0) {
            attr = new Attribute(CoreAttributeTypes.RuntimeVersion.getIdString());
            attr.setValue(this.getRuntimeVersions());
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setkey(key);
        return art;
    }
}

