/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import org.eclipse.osee.accessor.ArtifactAccessor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.testscript.ScriptResultApi;
import org.eclipse.osee.testscript.internal.ImportTmoReader;
import org.eclipse.osee.testscript.internal.ScriptDefToken;
import org.eclipse.osee.testscript.internal.ScriptResultAccessor;
import org.eclipse.osee.testscript.internal.ScriptResultToken;
import org.eclipse.osee.testscript.internal.TestPointToken;

public class ScriptResultApiImpl
implements ScriptResultApi {
    private ArtifactAccessor<ScriptResultToken> accessor;
    private final List<AttributeTypeId> attributes;

    public ScriptResultApiImpl(OrcsApi orcsApi) {
        this.setAccessor((ArtifactAccessor<ScriptResultToken>)new ScriptResultAccessor(orcsApi));
        this.attributes = new LinkedList<AttributeTypeId>();
        this.attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
    }

    private void setAccessor(ArtifactAccessor<ScriptResultToken> scriptResultTypeAccessor) {
        this.accessor = scriptResultTypeAccessor;
    }

    @Override
    public ScriptResultToken get(BranchId branch, ArtifactId scriptResultTypeId) {
        try {
            return (ScriptResultToken)((Object)this.accessor.get(branch, scriptResultTypeId));
        }
        catch (Exception exception) {
            return new ScriptResultToken();
        }
    }

    @Override
    public ScriptResultToken getWithTestPointsAndFilter(BranchId branch, ArtifactId resultId, String filter, int pageNum, int count) {
        ScriptResultToken resultToken = ScriptResultToken.SENTINEL;
        try {
            resultToken = (ScriptResultToken)((Object)this.accessor.get(branch, resultId));
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        if (resultToken.isValid()) {
            String url = resultToken.getFileUrl();
            File f = new File(url);
            if (!f.exists()) {
                return resultToken;
            }
            try {
                FileInputStream fis = new FileInputStream(f);
                ZipInputStream zis = new ZipInputStream(fis);
                if (zis.getNextEntry() != null) {
                    ImportTmoReader reader = new ImportTmoReader();
                    ScriptDefToken tmoToken = reader.getScriptDefinition(zis, ArtifactId.SENTINEL);
                    resultToken = tmoToken.getScriptResults().get(0);
                    zis.close();
                    fis.close();
                    resultToken.setId(resultId.getId());
                    List<TestPointToken> testPoints = resultToken.getTestPoints();
                    if (Strings.isValid((String)filter)) {
                        testPoints = testPoints.stream().filter(tp -> tp.getName().toLowerCase().contains(filter.toLowerCase())).collect(Collectors.toList());
                    }
                    resultToken.setTestPoints(testPoints);
                    resultToken.setTotalTestPoints(testPoints.size());
                    if (pageNum > 0 && count > 0) {
                        int startIndex = (pageNum - 1) * count;
                        int endIndex = Math.min(testPoints.size(), startIndex + count);
                        if (startIndex > testPoints.size() - 1) {
                            resultToken.setTestPoints(new LinkedList<TestPointToken>());
                        } else {
                            resultToken.setTestPoints(testPoints.subList(startIndex, endIndex));
                        }
                    }
                    return resultToken;
                }
                zis.close();
                fis.close();
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
        }
        return resultToken;
    }

    @Override
    public Collection<ScriptResultToken> getAllForSet(BranchId branch, ArtifactId viewId, ArtifactId setId) {
        try {
            return this.accessor.getAllByFilter(branch, setId.getIdString(), Arrays.asList(CoreAttributeTypes.SetId), viewId);
        }
        catch (Exception ex) {
            System.out.println(ex);
            return new LinkedList<ScriptResultToken>();
        }
    }

    @Override
    public Collection<ScriptResultToken> getAllForBatch(BranchId branch, ArtifactId viewId, ArtifactId batchId, String filter, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        try {
            return this.accessor.getAllByRelationAndFilter(branch, CoreRelationTypes.ScriptBatchToTestScriptResult_ScriptBatch, batchId, filter, this.attributes, pageNum, pageSize, orderByAttribute, viewId);
        }
        catch (Exception ex) {
            System.out.println(ex);
            return new LinkedList<ScriptResultToken>();
        }
    }

    @Override
    public int getAllForBatchCount(BranchId branch, ArtifactId viewId, ArtifactId batchId, String filter) {
        if (Strings.isValid((String)filter)) {
            return this.accessor.getAllByRelationAndFilterAndCount(branch, CoreRelationTypes.ScriptBatchToTestScriptResult_ScriptBatch, batchId, filter, this.attributes, viewId);
        }
        return this.accessor.getAllByRelationAndCount(branch, CoreRelationTypes.ScriptBatchToTestScriptResult_ScriptBatch, batchId, viewId);
    }

    @Override
    public Collection<ScriptResultToken> getAll(BranchId branch) {
        return this.getAll(branch, ArtifactId.SENTINEL);
    }

    @Override
    public Collection<ScriptResultToken> getAll(BranchId branch, ArtifactId viewId) {
        return this.getAll(branch, viewId, AttributeTypeId.SENTINEL);
    }

    @Override
    public Collection<ScriptResultToken> getAll(BranchId branch, AttributeTypeId orderByAttribute) {
        return this.getAll(branch, ArtifactId.SENTINEL, orderByAttribute);
    }

    @Override
    public Collection<ScriptResultToken> getAll(BranchId branch, ArtifactId viewId, AttributeTypeId orderByAttribute) {
        return this.getAll(branch, viewId, 0L, 0L, orderByAttribute);
    }

    @Override
    public Collection<ScriptResultToken> getAll(BranchId branch, long pageNum, long pageSize) {
        return this.getAll(branch, ArtifactId.SENTINEL, pageNum, pageSize);
    }

    @Override
    public Collection<ScriptResultToken> getAll(BranchId branch, ArtifactId viewId, long pageNum, long pageSize) {
        return this.getAll(branch, viewId, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public Collection<ScriptResultToken> getAll(BranchId branch, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        return this.getAll(branch, ArtifactId.SENTINEL, pageNum, pageSize, orderByAttribute);
    }

    @Override
    public Collection<ScriptResultToken> getAll(BranchId branch, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        try {
            return this.accessor.getAll(branch, pageNum, pageSize, orderByAttribute);
        }
        catch (Exception exception) {
            return new LinkedList<ScriptResultToken>();
        }
    }

    @Override
    public Collection<ScriptResultToken> getAllByFilter(BranchId branch, String filter) {
        return this.getAllByFilter(branch, ArtifactId.SENTINEL, filter);
    }

    @Override
    public Collection<ScriptResultToken> getAllByFilter(BranchId branch, ArtifactId viewId, String filter) {
        return this.getAllByFilter(branch, viewId, filter, AttributeTypeId.SENTINEL);
    }

    @Override
    public Collection<ScriptResultToken> getAllByFilter(BranchId branch, String filter, AttributeTypeId orderByAttribute) {
        return this.getAllByFilter(branch, ArtifactId.SENTINEL, filter, orderByAttribute);
    }

    @Override
    public Collection<ScriptResultToken> getAllByFilter(BranchId branch, ArtifactId viewId, String filter, AttributeTypeId orderByAttribute) {
        return this.getAllByFilter(branch, viewId, filter, 0L, 0L, orderByAttribute);
    }

    @Override
    public Collection<ScriptResultToken> getAllByFilter(BranchId branch, String filter, long pageNum, long pageSize) {
        return this.getAllByFilter(branch, ArtifactId.SENTINEL, filter, pageNum, pageSize);
    }

    @Override
    public Collection<ScriptResultToken> getAllByFilter(BranchId branch, ArtifactId viewId, String filter, long pageNum, long pageSize) {
        return this.getAllByFilter(branch, viewId, filter, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public Collection<ScriptResultToken> getAllByFilter(BranchId branch, String filter, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        return this.getAllByFilter(branch, ArtifactId.SENTINEL, filter, pageNum, pageSize, orderByAttribute);
    }

    @Override
    public Collection<ScriptResultToken> getAllByFilter(BranchId branch, ArtifactId viewId, String filter, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        try {
            return this.accessor.getAllByFilter(branch, filter, this.attributes, pageNum, pageSize, orderByAttribute);
        }
        catch (Exception exception) {
            return new LinkedList<ScriptResultToken>();
        }
    }

    @Override
    public Collection<ScriptResultToken> getAllByRelation(BranchId branch, RelationTypeSide relation, ArtifactId relatedId) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.accessor.getAllByRelation(branch, relation, relatedId, ArtifactId.SENTINEL);
    }

    @Override
    public int getCountWithFilter(BranchId branch, ArtifactId viewId, String filter) {
        return this.accessor.getAllByFilterAndCount(branch, filter, Arrays.asList(CoreAttributeTypes.Name), viewId);
    }
}

