/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;

public class ScriptBatchToken
extends ArtifactAccessorResultWithoutGammas {
    public static final ScriptBatchToken SENTINEL = new ScriptBatchToken();
    private String batchId;
    private String testEnvBatchId;
    private Date executionDate;
    private String machineName;
    private String folderUrl;

    public ScriptBatchToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public ScriptBatchToken(ArtifactReadable art) {
        super(art);
        this.setBatchId(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.BatchId, ""));
        this.setTestEnvBatchId(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.TestEnvBatchId, ""));
        this.setExecutionDate((Date)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ExecutionDate, (Object)new Date()));
        this.setMachineName(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.MachineName, ""));
        this.setFolderUrl(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ContentUrl, ""));
    }

    public ScriptBatchToken(Long id, String name) {
        super(id, name);
        this.setBatchId("");
        this.setTestEnvBatchId("");
        this.setExecutionDate(new Date());
        this.setMachineName("");
        this.setFolderUrl("");
    }

    public ScriptBatchToken() {
    }

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getTestEnvBatchId() {
        return this.testEnvBatchId;
    }

    public void setTestEnvBatchId(String testEnvBatchId) {
        this.testEnvBatchId = testEnvBatchId;
    }

    public Date getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = executionDate;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }

    @JsonIgnore
    public String getFolderUrl() {
        return this.folderUrl;
    }

    public void setFolderUrl(String folderUrl) {
        this.folderUrl = folderUrl;
    }

    public CreateArtifact createArtifact(String key) {
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put(CoreAttributeTypes.ExecutionDate, String.valueOf(this.getExecutionDate().getTime()));
        values.put(CoreAttributeTypes.MachineName, this.getMachineName());
        values.put(CoreAttributeTypes.BatchId, this.getBatchId());
        values.put(CoreAttributeTypes.TestEnvBatchId, this.getTestEnvBatchId());
        values.put(CoreAttributeTypes.ContentUrl, this.getFolderUrl());
        CreateArtifact art = new CreateArtifact();
        art.setName(this.getName());
        art.setTypeId(CoreArtifactTypes.ScriptBatch.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.ScriptBatch.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setkey(key);
        return art;
    }
}

